/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.andromda.core.metafacade.MetafacadeMapping;
import org.andromda.core.metafacade.MetafacadeMappings;
import org.andromda.core.metafacade.MetafacadeMappingsException;
import org.apache.log4j.Logger;

final class MetafacadeUtils {
    static /* synthetic */ Class class$org$andromda$core$metafacade$ModelAccessFacade;

    MetafacadeUtils() {
    }

    static boolean propertiesValid(MetafacadeBase metafacade, MetafacadeMapping mapping) {
        boolean valid = false;
        Collection propertyGroups = mapping.getMappingPropertyGroups();
        if (propertyGroups != null && !propertyGroups.isEmpty()) {
            try {
                if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                    MetafacadeUtils.getLogger().debug((Object)("evaluating " + propertyGroups.size() + " property groups(s) on metafacade '" + metafacade + "'"));
                }
                Introspector introspector = Introspector.instance();
                Iterator tterator = propertyGroups.iterator();
                while (tterator.hasNext()) {
                    MetafacadeMapping.PropertyGroup propertyGroup = (MetafacadeMapping.PropertyGroup)tterator.next();
                    Iterator propertyIterator = propertyGroup.getProperties().iterator();
                    while (propertyIterator.hasNext()) {
                        MetafacadeMapping.Property property = (MetafacadeMapping.Property)propertyIterator.next();
                        valid = introspector.containsValidProperty(metafacade, property.getName(), property.getValue());
                        if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                            MetafacadeUtils.getLogger().debug((Object)("property '" + property.getName() + "', with value '" + property.getValue() + "' on metafacade '" + metafacade + "', evaluated to --> '" + valid + "'"));
                        }
                        if (valid) continue;
                        break;
                    }
                    if (!valid) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                    MetafacadeUtils.getLogger().debug((Object)("An error occured while evaluating properties on metafacade '" + metafacade + "', setting valid to 'false'"), throwable);
                }
                valid = false;
            }
            if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                MetafacadeUtils.getLogger().debug((Object)("completed evaluating " + propertyGroups.size() + " properties on metafacade '" + metafacade + "' with a result of --> '" + valid + "'"));
            }
        }
        return valid;
    }

    static MetafacadeBase constructMetafacade(Class metafacadeClass, Object mappingObject, String context) throws Exception {
        if (MetafacadeUtils.getLogger().isDebugEnabled()) {
            MetafacadeUtils.getLogger().debug((Object)("constructing metafacade from class '" + metafacadeClass + "' mapping object '" + mappingObject + "', and context '" + context + "'"));
        }
        Constructor<?> constructor = metafacadeClass.getDeclaredConstructors()[0];
        return (MetafacadeBase)constructor.newInstance(mappingObject, context);
    }

    public static String getInheritedMappingClassName(MetafacadeMapping mapping) {
        Class metafacadeClass = mapping.getMetafacadeClass();
        List interfaces = org.apache.commons.lang.ClassUtils.getAllInterfaces((Class)metafacadeClass);
        MetafacadeImpls metafacadeImpls = MetafacadeImpls.instance();
        Map mappingInstances = MetafacadeMappings.getAllMetafacadeMappingInstances();
        String className = null;
        Iterator iterator = interfaces.iterator();
        while (iterator.hasNext() && className == null) {
            String metafacadeInterface = ((Class)iterator.next()).getName();
            Class metafacadeImplClass = metafacadeImpls.getMetafacadeImplClass(metafacadeInterface);
            className = (String)mappingInstances.get(metafacadeImplClass);
        }
        if (className == null) {
            throw new MetafacadeMappingsException("No mapping class could be found for '" + metafacadeClass.getName() + "'");
        }
        return className;
    }

    public static boolean isMetafacadeModelPresent(String namespace) {
        boolean present = false;
        if (ClassUtils.isClassOfTypePresent(Namespaces.instance().getResourceRoots(namespace), class$org$andromda$core$metafacade$ModelAccessFacade == null ? (class$org$andromda$core$metafacade$ModelAccessFacade = MetafacadeUtils.class$("org.andromda.core.metafacade.ModelAccessFacade")) : class$org$andromda$core$metafacade$ModelAccessFacade)) {
            present = true;
        }
        return present;
    }

    private static Logger getLogger() {
        return MetafacadeFactory.getInstance().getLogger();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

