/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.engine;

import org.andromda.core.configuration.Configuration;
import org.andromda.core.engine.ModelProcessor;
import org.andromda.core.metafacade.ModelValidationMessage;

public class Engine {
    private ModelProcessor modelProcessor = ModelProcessor.newInstance();

    public static Engine newInstance() {
        return new Engine();
    }

    private Engine() {
    }

    public void initialize(Configuration configuration) {
        this.modelProcessor.initialize(configuration);
    }

    public ModelValidationMessage[] loadModelsIfNecessary(Configuration configuration) {
        ModelValidationMessage[] messages = null;
        if (configuration != null) {
            messages = this.modelProcessor.loadIfNecessary(configuration.getRepositories()).toArray(new ModelValidationMessage[0]);
        }
        return messages == null ? new ModelValidationMessage[]{} : messages;
    }

    public ModelValidationMessage[] run(Configuration configuration) {
        ModelValidationMessage[] messages = null;
        if (configuration != null) {
            messages = this.modelProcessor.process(configuration);
        }
        return messages == null ? new ModelValidationMessage[]{} : messages;
    }

    public void shutdown() {
        this.modelProcessor.shutdown();
    }
}

