/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.cartridge;

import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.andromda.core.cartridge.CartridgeException;
import org.andromda.core.cartridge.Resource;
import org.andromda.core.cartridge.template.ModelElement;
import org.andromda.core.cartridge.template.ModelElements;
import org.andromda.core.cartridge.template.Template;
import org.andromda.core.cartridge.template.Type;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.BasePlugin;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.common.PathMatcher;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.apache.commons.lang.BooleanUtils;

public class Cartridge
extends BasePlugin {
    private static final String FORWARD_SLASH = "/";
    private static final String PATH_PATTERN = "\\*.*";
    private final List resources = new ArrayList();
    private final Map conditions = new LinkedHashMap();
    private boolean conditionsEvaluated = false;

    public void processModelElements(MetafacadeFactory factory) {
        ExceptionUtils.checkNull("factory", factory);
        List resources = this.getResources();
        if (resources != null && !resources.isEmpty()) {
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (resource instanceof Template) {
                    this.processTemplate(factory, (Template)resource);
                    continue;
                }
                this.processResource(resource);
            }
        }
    }

    protected void processTemplate(MetafacadeFactory factory, Template template) {
        ExceptionUtils.checkNull("template", template);
        ModelElements templateModelElements = template.getSupportedModeElements();
        if (templateModelElements != null && !templateModelElements.isEmpty()) {
            Iterator iterator = templateModelElements.getModelElements().iterator();
            while (iterator.hasNext()) {
                ModelElement templateModelElement = (ModelElement)iterator.next();
                if (templateModelElement.hasStereotype()) {
                    templateModelElement.setMetafacades(factory.getMetafacadesByStereotype(templateModelElement.getStereotype()));
                    continue;
                }
                if (!templateModelElement.hasTypes()) continue;
                templateModelElement.setMetafacades(factory.getAllMetafacades());
            }
            this.processTemplateWithMetafacades(factory, template);
        } else {
            this.processTemplateWithoutMetafacades(template);
        }
    }

    protected void processTemplateWithMetafacades(MetafacadeFactory factory, Template template) {
        ExceptionUtils.checkNull("template", template);
        ModelElements modelElements = template.getSupportedModeElements();
        if (modelElements != null && !modelElements.isEmpty()) {
            try {
                Set allMetafacades = modelElements.getAllMetafacades();
                if (template.isOutputToSingleFile() && (template.isOutputOnEmptyElements() || !allMetafacades.isEmpty())) {
                    LinkedHashMap<String, Set> templateContext = new LinkedHashMap<String, Set>();
                    String modelElementsVariable = modelElements.getVariable();
                    if (modelElementsVariable != null && modelElementsVariable.trim().length() > 0) {
                        templateContext.put(modelElements.getVariable(), allMetafacades);
                    }
                    Iterator iterator = modelElements.getModelElements().iterator();
                    while (iterator.hasNext()) {
                        ModelElement modelElement = (ModelElement)iterator.next();
                        String modelElementVariable = modelElement.getVariable();
                        if (modelElementVariable == null || modelElementVariable.trim().length() <= 0) continue;
                        Collection metafacades = (Collection)templateContext.get(modelElementVariable);
                        if (metafacades != null) {
                            metafacades.addAll(modelElement.getMetafacades());
                            continue;
                        }
                        metafacades = modelElement.getMetafacades();
                        templateContext.put(modelElementVariable, new LinkedHashSet(metafacades));
                    }
                    this.processWithTemplate(template, templateContext, null, null);
                } else {
                    Iterator iterator = allMetafacades.iterator();
                    while (iterator.hasNext()) {
                        LinkedHashMap templateContext = new LinkedHashMap();
                        Object metafacade = iterator.next();
                        ModelAccessFacade model = factory.getModel();
                        Iterator elements = modelElements.getModelElements().iterator();
                        while (elements.hasNext()) {
                            ModelElement modelElement = (ModelElement)elements.next();
                            String variable = modelElement.getVariable();
                            if (variable == null || variable.trim().length() == 0) {
                                variable = modelElements.getVariable();
                            }
                            if (variable != null && variable.trim().length() > 0) {
                                templateContext.put(variable, metafacade);
                            }
                            if (this.processPropertyTemplates(template, metafacade, templateContext, modelElement)) continue;
                            this.processWithTemplate(template, templateContext, model.getName(metafacade), model.getPackageName(metafacade));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw new CartridgeException(throwable);
            }
        }
    }

    private boolean processPropertyTemplates(Template template, Object metafacade, Map templateContext, ModelElement modelElement) {
        boolean propertyTemplatesEvaluated = false;
        Iterator types = modelElement.getTypes().iterator();
        while (types.hasNext()) {
            Type type = (Type)types.next();
            Iterator properties = type.getProperties().iterator();
            while (properties.hasNext()) {
                Type.Property property = (Type.Property)properties.next();
                String variable = property.getVariable();
                propertyTemplatesEvaluated = variable != null && variable.trim().length() > 0;
                if (!propertyTemplatesEvaluated) continue;
                Object value = Introspector.instance().getProperty(metafacade, property.getName());
                if (value instanceof Collection) {
                    Iterator values = ((Collection)value).iterator();
                    while (values.hasNext()) {
                        templateContext.put(variable, values.next());
                        this.processWithTemplate(template, templateContext, null, null);
                    }
                    continue;
                }
                templateContext.put(variable, value);
                this.processWithTemplate(template, templateContext, null, null);
            }
        }
        return propertyTemplatesEvaluated;
    }

    protected void processTemplateWithoutMetafacades(Template template) {
        ExceptionUtils.checkNull("template", template);
        LinkedHashMap templateContext = new LinkedHashMap();
        this.processWithTemplate(template, templateContext, null, null);
    }

    private void processWithTemplate(Template template, Map templateContext, String metafacadeName, String metafacadePackage) {
        ExceptionUtils.checkNull("template", template);
        ExceptionUtils.checkNull("templateContext", templateContext);
        File outputFile = null;
        try {
            String location;
            this.populateTemplateContext(templateContext);
            StringWriter output = new StringWriter();
            this.getTemplateEngine().processTemplate(template.getPath(), templateContext, output);
            if (this.isValidOutputCondition(template.getOutputCondition(), templateContext) && (location = Namespaces.instance().getPropertyValue(this.getNamespace(), this.getTemplateEngine().getEvaluatedExpression(template.getOutlet(), templateContext))) != null && (outputFile = template.getOutputLocation(metafacadeName, metafacadePackage, new File(location), this.getTemplateEngine().getEvaluatedExpression(template.getOutputPattern(), templateContext))) != null && (!outputFile.exists() || template.isOverwrite())) {
                String outputString = output.toString();
                AndroMDALogger.setSuffix(this.getNamespace());
                if (outputString != null && outputString.trim().length() > 0 || template.isGenerateEmptyFiles()) {
                    ResourceWriter.instance().writeStringToFile(outputString, outputFile, this.getNamespace());
                    AndroMDALogger.info("Output: '" + outputFile.toURI() + "'");
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Empty Output: '" + outputFile.toURI() + "' --> not writing"));
                }
                AndroMDALogger.reset();
            }
        }
        catch (Throwable throwable) {
            if (outputFile != null) {
                outputFile.delete();
                this.getLogger().info((Object)("Removed: '" + outputFile + "'"));
            }
            String message = "Error processing template '" + template.getPath() + "' with template context '" + templateContext + "' using cartridge '" + this.getNamespace() + "'";
            throw new CartridgeException(message, throwable);
        }
    }

    protected void processResource(Resource resource) {
        ExceptionUtils.checkNull("resource", resource);
        URL resourceUrl = ResourceUtils.getResource(resource.getPath(), this.getMergeLocation());
        if (resourceUrl == null) {
            List contents = this.getContents();
            if (contents != null) {
                AndroMDALogger.setSuffix(this.getNamespace());
                Iterator iterator = contents.iterator();
                while (iterator.hasNext()) {
                    String content = (String)iterator.next();
                    if (content == null || content.trim().length() <= 0 || !PathMatcher.wildcardMatch(content, resource.getPath()) || (resourceUrl = ResourceUtils.getResource(content, this.getMergeLocation())).toString().endsWith(FORWARD_SLASH)) continue;
                    this.writeResource(resource, resourceUrl);
                }
                AndroMDALogger.reset();
            }
        } else {
            this.writeResource(resource, resourceUrl);
        }
    }

    private void writeResource(Resource resource, URL resourceUrl) {
        File outputFile = null;
        try {
            String location;
            String resourceUri = ResourceUtils.normalizePath(resourceUrl.toString());
            String uriSuffix = resource.getPath().replaceAll(PATH_PATTERN, "");
            uriSuffix = resourceUri.indexOf(uriSuffix) != -1 ? resourceUri.substring(resourceUri.indexOf(uriSuffix) + uriSuffix.length(), resourceUri.length()) : resourceUri.substring(resourceUri.lastIndexOf(FORWARD_SLASH), resourceUri.length());
            LinkedHashMap templateContext = new LinkedHashMap();
            this.populateTemplateContext(templateContext);
            if (this.isValidOutputCondition(resource.getOutputCondition(), templateContext) && (location = Namespaces.instance().getPropertyValue(this.getNamespace(), this.getTemplateEngine().getEvaluatedExpression(resource.getOutlet(), templateContext))) != null) {
                outputFile = resource.getOutputLocation(new String[]{uriSuffix}, new File(location), this.getTemplateEngine().getEvaluatedExpression(resource.getOutputPattern(), templateContext));
                boolean lastModifiedCheck = resource.isLastModifiedCheck();
                if ((!lastModifiedCheck || lastModifiedCheck && ResourceUtils.getLastModifiedTime(resourceUrl) > outputFile.lastModified()) && (!outputFile.exists() || resource.isOverwrite())) {
                    ResourceWriter.instance().writeUrlToFile(resourceUrl, outputFile.toString());
                    AndroMDALogger.info("Output: '" + outputFile.toURI() + "'");
                }
            }
        }
        catch (Throwable throwable) {
            if (outputFile != null) {
                outputFile.delete();
                this.getLogger().info((Object)("Removed: '" + outputFile + "'"));
            }
            throw new CartridgeException(throwable);
        }
    }

    public List getResources() {
        return this.resources;
    }

    public void addResource(Resource resource) {
        ExceptionUtils.checkNull("resource", resource);
        resource.setCartridge(this);
        this.resources.add(resource);
    }

    protected void populateTemplateContext(Map templateContext) {
        super.populateTemplateContext(templateContext);
        templateContext.putAll(this.getEvaluatedConditions(templateContext));
    }

    public void addCondition(String name, String value) {
        this.conditions.put(name, value != null ? value.trim() : "");
    }

    public Map getConditions() {
        return this.conditions;
    }

    private Map getEvaluatedConditions(Map templateContext) {
        if (!this.conditionsEvaluated) {
            Iterator iterator = this.conditions.keySet().iterator();
            while (iterator.hasNext()) {
                String evaluationResult;
                String name = (String)iterator.next();
                String value = (String)this.conditions.get(name);
                String string = evaluationResult = value != null ? value.trim() : null;
                if (evaluationResult != null && evaluationResult.trim().length() > 0) {
                    evaluationResult = this.getTemplateEngine().getEvaluatedExpression(evaluationResult, templateContext);
                }
                this.conditions.put(name, BooleanUtils.toBoolean((String)evaluationResult));
            }
            this.conditionsEvaluated = true;
        }
        return this.conditions;
    }

    private Boolean getGlobalConditionResult(String outputCondition, Map templateContext) {
        return (Boolean)this.getEvaluatedConditions(templateContext).get(outputCondition);
    }

    private boolean isValidOutputCondition(String outputCondition, Map templateContext) {
        boolean validOutputCondition = true;
        if (outputCondition != null && outputCondition.trim().length() > 0) {
            Boolean result = this.getGlobalConditionResult(outputCondition, templateContext);
            if (result == null) {
                String outputConditionResult = this.getTemplateEngine().getEvaluatedExpression(outputCondition, templateContext);
                result = BooleanUtils.toBoolean((String)(outputConditionResult != null ? outputConditionResult.trim() : null));
            }
            validOutputCondition = result != null ? result : false;
        }
        return validOutputCondition;
    }

    public void shutdown() {
        super.shutdown();
        this.conditions.clear();
    }
}

