/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core;

import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.engine.Engine;
import org.andromda.core.metafacade.ModelValidationMessage;
import org.andromda.core.server.Client;
import org.apache.log4j.Logger;

public class AndroMDA {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$core$AndroMDA == null ? (class$org$andromda$core$AndroMDA = AndroMDA.class$("org.andromda.core.AndroMDA")) : class$org$andromda$core$AndroMDA));
    private Engine engine;
    static /* synthetic */ Class class$org$andromda$core$AndroMDA;
    static /* synthetic */ Class class$org$andromda$core$server$Client;

    public static AndroMDA newInstance() {
        return new AndroMDA();
    }

    private AndroMDA() {
        AndroMDALogger.initialize();
        this.engine = Engine.newInstance();
    }

    public void run(URL configurationUri) {
        ExceptionUtils.checkNull("configurationUri", configurationUri);
        this.run(Configuration.getInstance(configurationUri));
    }

    public void run(InputStream configurationStream) {
        ExceptionUtils.checkNull("configurationStream", configurationStream);
        this.run(Configuration.getInstance(configurationStream));
    }

    public void run(String configuration) {
        ExceptionUtils.checkEmpty("configuration", configuration);
        this.run(Configuration.getInstance(configuration));
    }

    public void initialize(Configuration configuration) {
        ExceptionUtils.checkNull("configuration", configuration);
        this.engine.initialize(configuration);
    }

    public void initialize(InputStream configurationStream) {
        ExceptionUtils.checkNull("configurationStream", configurationStream);
        this.engine.initialize(Configuration.getInstance(configurationStream));
    }

    public void initialize(String configuration) {
        ExceptionUtils.checkEmpty("configuration", configuration);
        this.engine.initialize(Configuration.getInstance(configuration));
    }

    public void initialize(URL configurationUri) {
        ExceptionUtils.checkNull("configurationUri", configurationUri);
        this.run(Configuration.getInstance(configurationUri));
    }

    public ModelValidationMessage[] run(Configuration configuration) {
        ModelValidationMessage[] messages = null;
        if (configuration != null) {
            Client serverClient = (Client)ComponentContainer.instance().findRequiredComponent(class$org$andromda$core$server$Client == null ? (class$org$andromda$core$server$Client = AndroMDA.class$("org.andromda.core.server.Client")) : class$org$andromda$core$server$Client);
            boolean client = true;
            if (configuration.getServer() != null) {
                try {
                    serverClient.start(configuration);
                }
                catch (ConnectException exception) {
                    client = false;
                }
            } else {
                client = false;
            }
            if (!client) {
                this.engine.initialize(configuration);
                messages = this.engine.run(configuration);
            }
        } else {
            logger.warn((Object)"AndroMDA could not run because no configuration was defined");
        }
        return messages == null ? new ModelValidationMessage[]{} : messages;
    }

    public void shutdown() {
        this.engine.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

