/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected void doAction() throws Exception {
        TuttiProtocol saved;
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = context.getPersistenceService();
        TuttiProtocol bean = (TuttiProtocol)model.toBean();
        ArrayList speciesProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getSpeciesRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            speciesProtocols.add(protocol);
        }
        bean.setSpecies(speciesProtocols);
        ArrayList benthosProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getBenthosRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            benthosProtocols.add(protocol);
        }
        bean.setBenthos(benthosProtocols);
        if (log.isDebugEnabled()) {
            log.debug((Object)("protocol id to save: " + bean.getId()));
        }
        if (TuttiEntities.isNew(bean)) {
            saved = persistenceService.createProtocol(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n._((String)"tutti.flash.info.protocolCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = persistenceService.saveProtocol(bean);
            this.sendMessage(I18n._((String)"tutti.flash.info.protocolSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProtocolId(saved.getId());
        model.setModify(false);
    }

    @Override
    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditProtocolUIHandler.getTitle(true));
        ((EditProtocolUI)this.getUI()).getSaveWarningContainer().setVisible(false);
    }
}

