/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class BenthosFrequencyTableModel
extends AbstractTuttiTableModel<BenthosFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<BenthosFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId("lengthStep", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosFrequencyRowModel> NUMBER = ColumnIdentifier.newId("number", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosFrequencyRowModel> WEIGHT = ColumnIdentifier.newId("weight", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]));
    private final BenthosFrequencyUIModel uiModel;
    private final Map<Float, BenthosFrequencyRowModel> rowCache;

    public BenthosFrequencyTableModel(TableColumnModelExt columnModel, BenthosFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.uiModel = uiModel;
        this.rowCache = Maps.newTreeMap();
        this.setNoneEditableCols(new ColumnIdentifier[0]);
    }

    @Override
    public BenthosFrequencyRowModel createNewRow() {
        BenthosFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && (lengthStep = (rowModel = (BenthosFrequencyRowModel)this.getEntry(rowCount - 1)).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep()));
        }
        BenthosFrequencyRowModel result = new BenthosFrequencyRowModel();
        result.addPropertyChangeListener("lengthStep", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BenthosFrequencyRowModel row;
                Float lengthStep;
                Float oldValue = (Float)evt.getOldValue();
                if (oldValue != null) {
                    BenthosFrequencyTableModel.this.rowCache.remove(oldValue);
                }
                if ((lengthStep = (row = (BenthosFrequencyRowModel)evt.getSource()).getLengthStep()) != null) {
                    BenthosFrequencyTableModel.this.rowCache.put(lengthStep, row);
                }
            }
        });
        result.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        result.setLengthStep(defaultStep);
        result.setValid(true);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<BenthosFrequencyRowModel> propertyName, BenthosFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
    }

    public Map<Float, BenthosFrequencyRowModel> getRowCache() {
        return this.rowCache;
    }

    @Override
    protected void onRowsChanged(List<BenthosFrequencyRowModel> data) {
        this.rowCache.clear();
        for (BenthosFrequencyRowModel row : data) {
            Float lengthStep = row.getLengthStep();
            if (lengthStep == null) continue;
            this.rowCache.put(lengthStep, row);
        }
    }
}

