/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.andromda.metafacades.uml.Service;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;

public class HibernateUtils {
    private String hibernateVersion;
    private String hibernateXmlPersistence;
    private String hibernateMappingStrategy;

    public Collection getAllRoles(Collection services) {
        final LinkedHashSet allRoles = new LinkedHashSet();
        CollectionUtils.forAllDo((Collection)services, (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Service) {
                    allRoles.addAll(((Service)object).getAllRoles());
                }
            }
        });
        return allRoles;
    }

    public void setHibernateVersion(String hibernateVersion) {
        this.hibernateVersion = hibernateVersion;
    }

    public String getHibernatePackage() {
        return this.isVersion3() ? "org.hibernate" : "net.sf.hibernate";
    }

    public String getHibernateUserTypePackage() {
        return this.isVersion3() ? this.getHibernatePackage() + ".usertype" : this.getHibernatePackage();
    }

    public boolean isVersion3() {
        return HibernateUtils.isVersion3(this.hibernateVersion);
    }

    public static boolean isVersion3(String hibernateVersionPropertyValue) {
        boolean version3 = false;
        if (hibernateVersionPropertyValue != null) {
            version3 = hibernateVersionPropertyValue.equals("3");
        }
        return version3;
    }

    public void setHibernateXMLPersistence(String hibernateXmlPersistence) {
        this.hibernateXmlPersistence = hibernateXmlPersistence;
    }

    public boolean isXmlPersistenceActive() {
        return HibernateUtils.isXmlPersistenceActive(this.hibernateVersion, this.hibernateXmlPersistence);
    }

    public static boolean isXmlPersistenceActive(String hibernateVersionPropertyValue, String hibernateXMLPersistencePropertyValue) {
        return HibernateUtils.isVersion3(hibernateVersionPropertyValue) && "true".equalsIgnoreCase(hibernateXMLPersistencePropertyValue);
    }

    public void setHibernateMappingStrategy(String hibernateMappingStrategy) {
        this.hibernateMappingStrategy = hibernateMappingStrategy;
    }

    public boolean isMapSubclassesInSeparateFile() {
        return HibernateUtils.mapSubclassesInSeparateFile(this.hibernateMappingStrategy);
    }

    public static boolean mapSubclassesInSeparateFile(String hibernateMappingStrategy) {
        return "subclass".equalsIgnoreCase(hibernateMappingStrategy);
    }

    public static String convertDocumentationIntoComments(String documentation) {
        if (documentation == null || documentation.length() == 0) {
            return null;
        }
        String comments = documentation;
        comments = comments.replaceAll("<p>[ \n\r\t]*-", ", ");
        comments = comments.replaceAll("<p>", "\n");
        comments = comments.replaceAll("</p>", "\n");
        comments = comments.replaceAll("<i>", "\"");
        comments = comments.replaceAll("</i>", "\"");
        comments = comments.replaceAll("</?[^>]+>", " ");
        comments = comments.replaceAll("[\r\n\t ]+", " ");
        comments = comments.trim();
        comments = comments.replaceAll("[']+", "''");
        comments = comments.replaceAll(": ,", ":");
        comments = comments.replaceAll(" ,", ",");
        if ((comments = comments.replaceAll("[,]+", ",")).length() == 0) {
            return null;
        }
        return comments;
    }

    public Integer substract(Object value, Object minus) {
        int valueInt = 0;
        int minusInt = 0;
        if (value instanceof Short) {
            valueInt = ((Short)value).intValue();
        } else if (value instanceof Integer) {
            valueInt = (Integer)value;
        } else if (value instanceof Float) {
            valueInt = ((Float)value).intValue();
        } else if (value instanceof Double) {
            valueInt = ((Double)value).intValue();
        } else if (value instanceof Long) {
            valueInt = ((Long)value).intValue();
        }
        if (minus instanceof Short) {
            minusInt = ((Short)minus).intValue();
        } else if (minus instanceof Integer) {
            minusInt = (Integer)minus;
        } else if (minus instanceof Float) {
            minusInt = ((Float)minus).intValue();
        } else if (minus instanceof Double) {
            minusInt = ((Double)minus).intValue();
        } else if (minus instanceof Long) {
            minusInt = ((Long)minus).intValue();
        }
        return new Integer(valueInt - minusInt);
    }
}

