/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.reflect.Array;
import java.util.Collection;
import org.nuiton.util.StringUtil;

public class ArrayUtil {
    public static int[] asIntArray(String[] a) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = StringUtil.toInt(a[i]);
        }
        return result;
    }

    public static int[] sum(int[] a, int[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("Au moins des tableaux est null ou les tableaux ne font pas la m\u00eame taille");
        }
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static int[] concat(int[] ... tabs) {
        int length = 0;
        for (int[] tab : tabs) {
            if (tab == null) continue;
            length += tab.length;
        }
        int[] result = new int[length];
        length = 0;
        for (int[] tab : tabs) {
            if (tab == null) continue;
            System.arraycopy(tab, 0, result, length, tab.length);
            length += tab.length;
        }
        return result;
    }

    public static Object[] concat(Object[] ... tabs) {
        Object[] result = null;
        Class<Object> clazz = null;
        int length = 0;
        for (Object[] tab : tabs) {
            if (tab == null) continue;
            length += tab.length;
            Class<?> tmp = tab.getClass().getComponentType();
            if (clazz == null) {
                clazz = tmp;
                continue;
            }
            if (tmp.isAssignableFrom(clazz)) {
                clazz = tmp;
                continue;
            }
            if (clazz.isAssignableFrom(tmp)) continue;
            clazz = Object.class;
        }
        if (clazz != null) {
            result = (Object[])Array.newInstance(clazz, length);
            length = 0;
            for (Object[] tab : tabs) {
                if (tab == null) continue;
                System.arraycopy(tab, 0, result, length, tab.length);
                length += tab.length;
            }
        }
        return result;
    }

    public static <E, F extends E> E[] concatElems(E[] tab, F ... elems) {
        Object[] result = ArrayUtil.concat(tab, elems);
        return result;
    }

    public static <A> A search(Object[] tab, Class<A> clazz) {
        A result = null;
        for (Object o : tab) {
            if (!clazz.isInstance(o)) continue;
            result = clazz.cast(o);
        }
        return result;
    }

    public static <T> T[] toArray(Collection list, Class<T> clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, list == null ? 0 : list.size());
        int i = 0;
        for (Object o : list) {
            result[i++] = o;
        }
        return result;
    }
}

