package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class ImportPupitriPopupUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVTW8bRRh+7cb5ctqUWP2CAiGNBEhoXDigiqDST6uJXIhIKip8gPHuJJ4yOzvMzLYbRSAk+AH8BLhzQeLGCXHgzIEL4i8gxIEr6ju79m42GcuJBJZ2vZp53uf9mveZ7/6EhtHw0iOapkQn0vKIkY2bDx++13/EAnuHmUBzZWMN+a9Wh3oPmmGxbixc6XWdeXto3r4dRyqWTB6wXuvCvLF7gpkBY9bC81WLwJj2VrG9lqpEj1iLoHys3/z9V/3r8Itv6wCpwuiamMryJKsyk6ku1HloYQk9PaZtQeUuhqG53MV4T7u124Ia8y6N2KfwOcx0YVpRjWQWVo6fcsaR2afKQosjUtvNRHH0dIdTEe9a2NzRhO9oFjFNbGItJwkn5glGQoJYWiQmsWKaWh5LElAbDJghRrGA4//6QcbNWCXqwbpSmctpC7Ms5Jb2BbPwjEuJuDTJrTgWjMoSNjOgMhRMW/jgv47lXs5c+pqLKJebVDJh4WKlXbmbbReuw84VJmcsQj7pcMG6tO/sllwu6dBgI1t00KXSSWFhYdXjxJUl1sQB7mafVfOlgGodJ4aJwqnbuVBFna6g3OKzVcDs6kaW6NXDEWerVexCQGXAxC2sOdYZWhV8vuqQL5ZFeUwFD6ll5ebqEKHhuUrOOGGknLByBGo9aOgEl7ETvaND+T5u5eN48dA4OsJs99/zrd9+/OOHzmgG59D3OS/0gITgbCjtTpHlzvViPoCJ5aJ9n6q1HrIwgfqT6ctlT2Bbw20MDv3lB9uZk3vUDJCiMfP7Tz+f//jXU1DvwLyIadihDr+O52KgsQqxCFP1zo0sooUns/g+i0/dQsNy687MpfzsV8aVDPcaURxSPIRTeMZYitW57KlOEWJ/7pd/Wlvf3xhVqIYRXxoLL6vU+BCmuRRcskynhhLk1aWmMiwJ41JqfOIDfvVRw8F8LXtf9dVkVrjz30FLaO4Xc/WZKwBLUQ2v+Gq1w5kISYFOE0f/Zpa/+7oGR6Z6UiRT6BD94ZEg+x+9suJt0IiQIJBJgxq18ioGuujsRuLM3Xi9dQIKEpaWGd0FGgRM2Zsim3t8LNMPDMO7pLFDhcEjcjbkOuvn3l3p5KzY8tWh1KqTNWNxv6I/ZUNeHt+QioUvGI/yHb8xb4yraoV0YnOun5Dm/25QVeePU468D608hyCOouyydPpuYR6lCANdd9cpTI9WF/jr1+R9yRDJA1Q9jymJiu2mxRt8m6vtsX58eVSumOOnca5CP7p1DiVyiobhkSxe8FqOzcPvyCsd1btvUi41LLSgezGC4czbaEeX+1yGeLVeP8Jec+/5iYxu+Uv3+srPsIwMTwGLH83oXwsAAA==";
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected FileEditor carrouselFile;
    protected JLabel carrouselFileLabel;
    protected Boolean editable;
    protected ImportPupitriPopupUIHandler handler;
    protected ImportPupitriPopupUI importPupitriDialog = this;
    protected Table mainPanel;
    protected FileEditor trunkFile;
    protected JLabel trunkFileLabel;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        getHandler().afterInitUI();
    }
    
    public void open() {
        handler.open();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriPopupUI(TuttiUIContext context) {
        super(context.getMainUI());
            setContextValue(context);
            ImportPupitriPopupUIHandler handler = new ImportPupitriPopupUIHandler(context, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public ImportPupitriPopupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI() {
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public FileEditor getCarrouselFile() {
        return carrouselFile;
    }

    public JLabel getCarrouselFileLabel() {
        return carrouselFileLabel;
    }

    public Boolean getEditable() {
        return editable;
    }

    public ImportPupitriPopupUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public FileEditor getTrunkFile() {
        return trunkFile;
    }

    public JLabel getTrunkFileLabel() {
        return trunkFileLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportPupitriDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(trunkFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(trunkFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.common.cancel"));
        cancelButton.setToolTipText(_("tutti.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCarrouselFile() {
        $objectMap.put("carrouselFile", carrouselFile = new FileEditor());
        
        carrouselFile.setName("carrouselFile");
        carrouselFile.setAcceptAllFileFilterUsed(false);
        carrouselFile.setDirectoryEnabled(false);
    }

    protected void createCarrouselFileLabel() {
        $objectMap.put("carrouselFileLabel", carrouselFileLabel = new JLabel());
        
        carrouselFileLabel.setName("carrouselFileLabel");
        carrouselFileLabel.setText(_("tutti.importPupitri.field.carrouselFile"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ImportPupitriPopupUIHandler.class));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createTrunkFile() {
        $objectMap.put("trunkFile", trunkFile = new FileEditor());
        
        trunkFile.setName("trunkFile");
        trunkFile.setAcceptAllFileFilterUsed(false);
        trunkFile.setDirectoryEnabled(false);
    }

    protected void createTrunkFileLabel() {
        $objectMap.put("trunkFileLabel", trunkFileLabel = new JLabel());
        
        trunkFileLabel.setName("trunkFileLabel");
        trunkFileLabel.setText(_("tutti.importPupitri.field.trunkFile"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(_("tutti.common.validate"));
        validateButton.setToolTipText(_("tutti.common.validate"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportPupitriDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 12 property setters
        trunkFileLabel.setLabelFor(trunkFile);
        trunkFile.setExts(_("tutti.importPupitri.trunkFile.extension"));
        trunkFile.setExtsDescription(_("tutti.importPupitri.trunkFile.extension.description"));
        carrouselFileLabel.setLabelFor(carrouselFile);
        carrouselFile.setExts(_("tutti.importPupitri.carrouselFile.extension"));
        carrouselFile.setExtsDescription(_("tutti.importPupitri.carrouselFile.extension.description"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.common.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("add"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.common.validate.mnemonic"),'Z'));
        // late initializer
        importPupitriDialog.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("importPupitriDialog", importPupitriDialog);
        createEditable();
        createHandler();
        createMainPanel();
        createTrunkFileLabel();
        createTrunkFile();
        createCarrouselFileLabel();
        createCarrouselFile();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of importPupitriDialog
        setName("importPupitriDialog");
        importPupitriDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(_("tutti.importPupitri.title"));
        setModal(true);
        
        $completeSetup();
    }

}