package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FishingOperationsUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<FishingOperationsUIModel, FishingOperationsUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCHES_TAB_ENABLED = "catchesTab.enabled";
    public static final String BINDING_DELETE_FISHING_OPERATION_BUTTON_ENABLED = "deleteFishingOperationButton.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";
    public static final String BINDING_WARNING_LABEL_TEXT = "warningLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXT28bRRSfOHH+lzREDQlNpU0aiiOFTRMRCApNGzsxccmfKnFFRQ5l7J3E065nltlx7WAF8RH4CHCBCxckbpwQB84cekF8BYQ4cEW8mbW9XnvXTppIdZyZ937vvd97897rD3+huCvQ7DNcqZiixCQtEvPh5pMnB7lnJC+3iJsX1JFcIO+nJ4Zix2jEapy7Et0+3lXqSzX1pRQvOpwR1qS9vouGXXlmE7dAiJToVlAj77pLR43r9YpTEnXUhlNhqN/883fsa+urb2MIVRzwbhxCMbpp+ZH07aIYtSR6HSy9wEs2ZqfghqDsFPy9ps5SNnbdfVwkn6Mv0cAu6newADCJ5i4essbQ+hVHoukT6hbAwoFDBJaUMzfLnUeYEVui+yfCpCeCFIkwZUlKapao6ZZB2sxzJgHe5HU1M92K8zjjONpOv0QDBcwsmwiJ0lfE3PGAfOh4kVvK2a0rAu8pGB+2Pyf4c+XwQjRuVv25A1pJLesrD8oGh1OB9Nf0cM7WGRxqaEy1pgEymONJXpFoNQSBWBRSauYIZmYSPtLUlqAIsHU9hXvDd2j+ofbnLhSXqqNKDcc7DcpOM1Ju5ScJkQKJaCKg7J0qtZsN7RlgkUgSDqBkjKD89TIWDCRTAI8pI0Kd3wp6NFqT2cU5RWkwAn2oBG/71SZxTgUm0RsBUeA9Ryx1EyT/zVbyQTDl1YxEycvU1TbkpTX0xxllJtGwNp7HMl8gbrORzcsYqelrYynve6uNEcazAlNZj/XtYMATIQEDDeGlmmEn3C/tYd97dbIKNwLdDGhC9zT97um3t55jFBclOIZyP25vuIdw5bXaqZZWqwD17X+TEy9//vOndL2/XgPbN0JFm8YD9D1HKPYkVabHvOZaktRe2sPO+jEacqFk897smAlx7Kh2Dc6BvXGlbip1cwe7BYCID/zxy6+Tn/3ei2JpNGxzbKWxks+gIVkQwAK3rYpz/4H2aLQ8CJ/X4V+vRH3qAUO9VnUPOwd26fIaeyTICYWHP+ZVQs35M1OCpwVePiSuGll9UpRIBdiaCWGr4XJu6Ld/J45+fFBnrAcimI4U91mLf4r6KbPhQeqZVBs3oTNoxHFJyeL+WAkbNAhGzWR4p6rV1j39udlGUw+0+KcFaLISGdU5j5K2mWUqgbnzSklhZHSc6tvHqNOAc7pYjkM+IJGgklGPEPViC4bz6FPtw6a+kGi2ut/eLr1LM68IgKyOqqzuMVLkjOYlWo8KwjNmhvRfs9jQHpGc21nqZEkFquC9V8CSsA80OF2P5rQDRAe6I6dHN7pV4yZMVQaw/I73JMxTIr3iJFYramLBmL1nsJKtH05zovq9GdSWq/nqVuhw6pyujS78hA+8yIx98GpwgaRtdE1aBEp03jrO7W6pg1Y26tbSlJGkKNFbF8kfcD1Y724wE9wIQT/u96PjPqHEttrOOwQcuXF1CzYGdfqCuhQKFcq9OusFSl09ire9AtaxDedw/vmp4CUGBT1XhYdh6NmByxL+H2BzkVh5d3XRWFleWzTW1hZCvWxbjy6Qij6pC+2gWlu6VRK0c580rVGJcLcXjcD5Ppdp5X9iYaH1kQ3UPFOrMheWWpVXGjHWVy7vxtwuOvIsqb8nIOLlu4uG/hUec2Dd6xZvT3PX+OgyXcO4c8eIyF2YV02LzwUqZKLABf1CJc3etOkpK+o1b6zqratmans/u3143shVZFOgsHyZjLcXdv2xhLnavP1dgL9+G59xsI9e+9DCEhs5yiywtdEG3aM+hy+AOKj2muyZo1eE78NxprviqOPvOiDMXBlhHhD+B0qILCdyEAAA";
    private static final Log log = LogFactory.getLog(FishingOperationsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected TabInfo catchesTab;
    protected EditCatchesUI catchesTabContent;
    protected JButton deleteFishingOperationButton;
    protected BeanFilterableComboBox<FishingOperation> fishingOperationComboBox;
    protected TabInfo fishingOperationTab;
    protected EditFishingOperationUI fishingOperationTabContent;
    protected FishingOperationsUI fishingOperationsTopPanel = this;
    protected FishingOperationsUIHandler handler;
    protected FishingOperationsUIModel model;
    protected JButton newFishingOperationButton;
    protected JLabel noTraitPane;
    protected JTabbedPane tabPane;
    protected Table topPanel;
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationsUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            FishingOperationsUIHandler handler = new FishingOperationsUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishingOperationsUI() {
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public TabInfo getCatchesTab() {
        return catchesTab;
    }

    public EditCatchesUI getCatchesTabContent() {
        return catchesTabContent;
    }

    public JButton getDeleteFishingOperationButton() {
        return deleteFishingOperationButton;
    }

    public BeanFilterableComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public TabInfo getFishingOperationTab() {
        return fishingOperationTab;
    }

    public EditFishingOperationUI getFishingOperationTabContent() {
        return fishingOperationTabContent;
    }

    public FishingOperationsUIHandler getHandler() {
        return handler;
    }

    public FishingOperationsUIModel getModel() {
        return model;
    }

    public JButton getNewFishingOperationButton() {
        return newFishingOperationButton;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFishingOperationsTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane);
        add(noTraitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(fishingOperationTabContent);
        tabPane.add(catchesTabContent);
        fishingOperationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation"));
        catchesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.catches"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(fishingOperationComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(warningContainer, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.fishingOperations.help"));
    }

    protected void createCatchesTab() {
        $objectMap.put("catchesTab", catchesTab = new TabInfo());
        
        catchesTab.setTitle(_("tutti.label.tab.catches"));
    }

    protected void createCatchesTabContent() {
        $objectMap.put("catchesTabContent", catchesTabContent = new EditCatchesUI(this));
        
        catchesTabContent.setName("catchesTabContent");
    }

    protected void createDeleteFishingOperationButton() {
        $objectMap.put("deleteFishingOperationButton", deleteFishingOperationButton = new JButton());
        
        deleteFishingOperationButton.setName("deleteFishingOperationButton");
        deleteFishingOperationButton.setToolTipText(_("tutti.fishingOperations.action.deleteFishingOperation.tip"));
        deleteFishingOperationButton.putClientProperty("help", "tutti.fishingOperations.action.deleteFishingOperation.help");
        deleteFishingOperationButton.putClientProperty("tuttiAction", DeleteFishingOperationAction.class);
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanFilterableComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setI18nPrefix("tutti.property.");
        fishingOperationComboBox.setProperty("selectedFishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.fishingOperations.field.fishingOperation.help");
    }

    protected void createFishingOperationTab() {
        $objectMap.put("fishingOperationTab", fishingOperationTab = new TabInfo());
        
        fishingOperationTab.setTitle(_("tutti.label.tab.fishingOperation"));
    }

    protected void createFishingOperationTabContent() {
        $objectMap.put("fishingOperationTabContent", fishingOperationTabContent = new EditFishingOperationUI(this));
        
        fishingOperationTabContent.setName("fishingOperationTabContent");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishingOperationsUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationsUIModel.class));
    }

    protected void createNewFishingOperationButton() {
        $objectMap.put("newFishingOperationButton", newFishingOperationButton = new JButton());
        
        newFishingOperationButton.setName("newFishingOperationButton");
        newFishingOperationButton.setToolTipText(_("tutti.fishingOperations.action.newFishingOperation.tip"));
        newFishingOperationButton.putClientProperty("help", "tutti.fishingOperations.action.newFishingOperation.help");
        newFishingOperationButton.putClientProperty("tuttiAction", NewFishingOperationAction.class);
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.fishingOperations.info.no.fishingOperation.selected"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFishingOperationsTopPanel();
        addChildrenToTopPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(newFishingOperationButton);
        $JPanel0.add(deleteFishingOperationButton);
        addChildrenToWarningContainer();
        addChildrenToTabPane();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        fishingOperationComboBox.setBean(model);
        newFishingOperationButton.setIcon(SwingUtil.createActionIcon("add"));
        newFishingOperationButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.fishingOperations.action.newFishingOperation.mnemonic"),'Z'));
        deleteFishingOperationButton.setIcon(SwingUtil.createActionIcon("delete"));
        deleteFishingOperationButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.fishingOperations.action.deleteFishingOperation.mnemonic"),'Z'));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, fishingOperationsTopPanel, "tutti.fishingOperations.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.fishingOperations.field.fishingOperation.help");
        registerHelpId(_broker, newFishingOperationButton, "tutti.fishingOperations.action.newFishingOperation.help");
        registerHelpId(_broker, deleteFishingOperationButton, "tutti.fishingOperations.action.deleteFishingOperation.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("fishingOperationsTopPanel", fishingOperationsTopPanel);
        createHandler();
        createModel();
        createBroker();
        createTopPanel();
        createFishingOperationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createNewFishingOperationButton();
        createDeleteFishingOperationButton();
        createWarningContainer();
        createWarningLabel();
        createTabPane();
        createFishingOperationTabContent();
        createCatchesTabContent();
        createNoTraitPane();
        createFishingOperationTab();
        createCatchesTab();
        // inline creation of fishingOperationsTopPanel
        setName("fishingOperationsTopPanel");
        setLayout(new BorderLayout());
        fishingOperationsTopPanel.putClientProperty("help", "tutti.fishingOperations.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getSelectedFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_FISHING_OPERATION_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    deleteFishingOperationButton.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("catchNotFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningLabel.setText(_(handler.getCatchWarningLabel(model.isCatchEnabled(), model.isCatchNotFound())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("catchNotFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_TAB_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesTab.setEnabled(model.getSelectedFishingOperation() != null && model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
    }

}