package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportMultiPostAction.java 1089 2013-06-10 09:50:08Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/marinelitter/ImportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractImportMultiPostAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;

import javax.swing.JTextArea;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportMultiPostAction extends AbstractImportMultiPostAction<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {

    protected Map<String, Object> notImportedData;

    public ImportMultiPostAction(MarineLitterBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiMarineLitter";
    }

    @Override
    protected String getFileExtensionDescription() {
        return _("tutti.common.file.tuttiMarineLitter");
    }

    @Override
    protected String getFileChooserTitle() {
        return _("tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return _("tutti.editMarineLitterBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    protected void releaseAction() {
        notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        notImportedData = multiPostImportExportService.importMarineLitter(file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        if (!notImportedData.isEmpty()) {
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog) getContext().getActionUI());

            Collection<MarineLitterBatch> notImportedMarineLitterBatches =
                    (Collection<MarineLitterBatch>) notImportedData.get(TuttiMultiPostImportExportService.BATCHES_KEY);

            StringBuffer stringBuffer = new StringBuffer();
            Float totalWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_MARINE_LITTER_TOTAL_WEIGHT);
            if (totalWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.totalWeight", totalWeight) + "\n");
            }

            for (MarineLitterBatch mlb : notImportedMarineLitterBatches) {
                stringBuffer.append("- " + decorate(mlb.getMarineLitterCategory()) + " / " + decorate(mlb.getMarineLitterSizeCategory()) + "\n");
            }

            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(getContext().getMainUI());
                dialog.setVisible(true);
            }
        }

        sendMessage(_("tutti.editMarineLitterBatch.action.importMultiPost.success", file));
    }
}
