package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportTemporaryReferentialAction.java 882 2013-04-29 12:31:29Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/ImportTemporaryReferentialAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiScreen;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.StringUtil;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import static org.nuiton.i18n.I18n._;

/**
 * Open screen to import referential
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportTemporaryReferentialAction extends AbstractChangeScreenAction {

    public ImportTemporaryReferentialAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            String answer;
            do {
                answer = JOptionPane.showInputDialog(getContext().getActionUI(),
                                                     _("tutti.manageTemporaryReferential.passwordDialog.message"),
                                                     _("tutti.manageTemporaryReferential.passwordDialog.title"),
                                                     JOptionPane.WARNING_MESSAGE);
                if (answer != null) {
                    String cryptedAnswer = StringUtil.encodeMD5(answer);
                    String correctAnswer = getConfig().getAdminPassword();
                    result = StringUtils.equals(cryptedAnswer, correctAnswer);

                    if (!result) {
                        JOptionPane.showMessageDialog(getContext().getActionUI(),
                                                      _("tutti.manageTemporaryReferential.passwordDialog.error.message"),
                                                      _("tutti.manageTemporaryReferential.passwordDialog.error.title"),
                                                      JOptionPane.ERROR_MESSAGE);
                    }

                } else {
                    result = false;
                }

            } while (!result && answer != null);
        }
        return result;
    }

    @Override
    protected void doAction() throws Exception {
        super.doAction();
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                getContext().getMainUI().getBody().revalidate();
            }
        });

    }
}
