/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.common.TemplateObjectException;
import org.andromda.core.configuration.Namespaces;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class TemplateObject {
    private static Logger logger = Logger.getLogger((Class)(class$org$andromda$core$common$TemplateObject == null ? (class$org$andromda$core$common$TemplateObject = TemplateObject.class$("org.andromda.core.common.TemplateObject")) : class$org$andromda$core$common$TemplateObject));
    private String name;
    private final Map objectCache = new HashMap();
    private String className;
    private final Collection propertyReferences = new ArrayList();
    private URL resource;
    private String namespace;
    static /* synthetic */ Class class$org$andromda$core$common$TemplateObject;

    public String getName() {
        String methodName = "TemplateObject.getName";
        if (StringUtils.isEmpty((String)this.name)) {
            throw new TemplateObjectException("TemplateObject.getName - templateObject '" + this + "' has no name defined");
        }
        return this.name;
    }

    public Object getObject() {
        String methodName = "TemplateObject.getTemplateObject";
        if (StringUtils.isEmpty((String)this.className)) {
            throw new TemplateObjectException("TemplateObject.getTemplateObject - templateObject '" + this + "' has no className defined");
        }
        Object templateObject = this.objectCache.get(this.className);
        try {
            if (templateObject == null) {
                Class templateObjectClass = ClassUtils.loadClass(this.className);
                templateObject = templateObjectClass.newInstance();
                this.objectCache.put(this.className, templateObject);
            }
            this.setProperties(templateObject);
        }
        catch (Throwable throwable) {
            throw new TemplateObjectException(throwable);
        }
        return templateObject;
    }

    protected void setProperties(Object templateObject) {
        Iterator iterator = this.propertyReferences.iterator();
        while (iterator.hasNext()) {
            String reference = (String)iterator.next();
            String value = Namespaces.instance().getPropertyValue(this.getNamespace(), reference);
            if (value == null) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("populating template object '" + this.name + "' property '" + reference + "' with value '" + value + "' for namespace '" + this.namespace + "'"));
            }
            try {
                Introspector.instance().setProperty(templateObject, reference, value);
            }
            catch (Exception exception) {
                String message = "Error setting property '" + reference + "' with '" + value + "' on templateObject --> '" + templateObject + "'";
                logger.warn((Object)message);
            }
        }
    }

    public void setName(String name) {
        this.name = StringUtils.trimToEmpty((String)name);
    }

    public void setClassName(String className) {
        ExceptionUtils.checkEmpty("className", className);
        this.className = className;
    }

    public void addPropertyReference(String reference) {
        this.propertyReferences.add(reference);
    }

    public URL getResource() {
        return this.resource;
    }

    public void setResource(URL resource) {
        this.resource = resource;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = StringUtils.trimToEmpty((String)namespace);
    }

    protected Logger getLogger() {
        return AndroMDALogger.getNamespaceLogger(this.namespace);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

