package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id: MarineLitterBatchTableModel.java 832 2013-04-19 17:16:10Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/marinelitter/MarineLitterBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class MarineLitterBatchTableModel extends AbstractTuttiTableModel<MarineLitterBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<MarineLitterBatchRowModel> MACRO_WASTE_CATEGORY = ColumnIdentifier.newId(
            MarineLitterBatchRowModel.PROPERTY_MARINE_LITTER_CATEGORY,
            n_("tutti.editMarineLitterBatch.table.header.marineLitterCategory"),
            n_("tutti.editMarineLitterBatch.table.header.marineLitterCategory.tip"));

    public static final ColumnIdentifier<MarineLitterBatchRowModel> MACRO_WASTE_SIZE_CATEGORY = ColumnIdentifier.newId(
            MarineLitterBatchRowModel.PROPERTY_MARINE_LITTER_SIZE_CATEGORY,
            n_("tutti.editMarineLitterBatch.table.header.marineLitterSizeCategory"),
            n_("tutti.editMarineLitterBatch.table.header.marineLitterSizeCategory.tip"));

    public static final ColumnIdentifier<MarineLitterBatchRowModel> NUMBER = ColumnIdentifier.newId(
            MarineLitterBatchRowModel.PROPERTY_NUMBER,
            n_("tutti.editMarineLitterBatch.table.header.number"),
            n_("tutti.editMarineLitterBatch.table.header.number.tip"));

    public static final ColumnIdentifier<MarineLitterBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            MarineLitterBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.editMarineLitterBatch.table.header.weight"),
            n_("tutti.editMarineLitterBatch.table.header.weight.tip"));

    public static final ColumnIdentifier<MarineLitterBatchRowModel> COMMENT = ColumnIdentifier.newId(
            MarineLitterBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editMarineLitterBatch.table.header.comment"),
            n_("tutti.editMarineLitterBatch.table.header.comment.tip"));

    public static final ColumnIdentifier<MarineLitterBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId(
            MarineLitterBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editMarineLitterBatch.table.header.file"),
            n_("tutti.editMarineLitterBatch.table.header.file.tip"));

    public MarineLitterBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);

        setNoneEditableCols(MACRO_WASTE_CATEGORY, MACRO_WASTE_SIZE_CATEGORY);
    }

    @Override
    public MarineLitterBatchRowModel createNewRow() {
        MarineLitterBatchRowModel result = new MarineLitterBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }
}