package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import java.awt.Color;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiComputedOrNotDataEditor extends NumberEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_COMPUTED_DATA_COLOR = "computedDataColor";
    public static final String PROPERTY_DECIMAL_NUMBER = "decimalNumber";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVSy0oDQRBsF42iRHyABETwdZ548eRJo6ISIqiHQE6T3TaO7GPs6dXNRfwEP0HvHr35Hd78BRF/QJzd1awvUHCO3VXVVUPdPMKAIZg7lkkiKA5ZBSh2VpvN3fYxuryOxiWlOSLIX58DTgtGvN7cMCy06im9+kav1qJARyGGH9grdRg23PXRHCEyw8xnhmtMdb+3Xkl0TO+qPVM/qV49PzmX3sW1A5Bo665ko8z+xiqS9NfBUR7DhL10Kqu+DDvWBqmwY/2W01nNl8Y0ZIAncA6DdShpSVaMYf7vkTONjJ9ohtHFRhy0kTY8ZUFLDGuHJNQhYYAkOGZWIlbCnFkTImblC8yA4iBdpWdiRm+XGhGvS5a5itaZfolhSFOkkbjLMJb6F2kmkWcqUP1tlCHD8i+Xfz5ZyIy7b7t0XIv8iGy87Ko8Y5ENCvDgkQw931qD7f8H3sq1CvWyh64KpJ//rbVWhN8OGTsZlmD6Uzds60TRuqIWfS0YoNiOGSqt70Xds6u8opUvFU0Fs+3L1OT93cPt5nsv4RXHd1F5ZwMAAA==";
    private static final Log log = LogFactory.getLog(TuttiComputedOrNotDataEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Color computedDataColor;
    protected Integer decimalNumber;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TuttiComputedOrNotDataEditor $NumberEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProperty(String property) {
            // cannot change the property
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiComputedOrNotDataEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor() {
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public TuttiComputedOrNotData<?> getBean() {
        return (TuttiComputedOrNotData<?>) super.getBean();
    }

    public Color getComputedDataColor() {
        return computedDataColor;
    }

    public Integer getDecimalNumber() {
        return decimalNumber;
    }

    @Override
    public TuttiComputedOrNotDataEditorHandler getHandler() {
        return (TuttiComputedOrNotDataEditorHandler) super.getHandler();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setComputedDataColor(Color computedDataColor) {
        Color oldValue = this.computedDataColor;
        this.computedDataColor = computedDataColor;
        firePropertyChange(PROPERTY_COMPUTED_DATA_COLOR, oldValue, computedDataColor);
    }

    public void setDecimalNumber(Integer decimalNumber) {
        Integer oldValue = this.decimalNumber;
        this.decimalNumber = decimalNumber;
        firePropertyChange(PROPERTY_DECIMAL_NUMBER, oldValue, decimalNumber);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createComputedDataColor() {
        $objectMap.put("computedDataColor", computedDataColor = null);
    }

    protected void createDecimalNumber() {
        $objectMap.put("decimalNumber", decimalNumber = null);
    }

    @Override
    protected void createHandler() {
        $objectMap.put("handler", handler = new TuttiComputedOrNotDataEditorHandler(this));
    }

    @Override
    protected void createProperty() {
        $objectMap.put("property", property = TuttiComputedOrNotData.PROPERTY_DATA);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NumberEditor0", $NumberEditor0);
        createComputedDataColor();
        createDecimalNumber();
        // inline creation of $NumberEditor0
        setName("$NumberEditor0");
        
        $completeSetup();
    }

}