package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: ViewGearCaracteristicsAction.java 926 2013-05-07 13:08:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/ViewGearCaracteristicsAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.1
 */
public class ViewGearCaracteristicsAction extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {

    protected final PersistenceService persistenceService;

    public ViewGearCaracteristicsAction(EditCruiseUIHandler handler) {
        super(handler, false);
        persistenceService = getContext().getPersistenceService();
    }

    @Override
    protected void doAction() throws Exception {
        GearCaracteristicsEditorUI editor = getUI().getGearCaracteristicsEditor();
        editor.getModel().setEditable(false);

        Gear gear = getUI().getContextValue(Gear.class);
        gear = persistenceService.getGearWithCaracteristics(gear, getDataContext().getCruise());
        editor.getModel().setGear(gear);

        getUI().getMainPanelLayout().setSelected(EditCruiseUIHandler.GEAR_CARACTERISTICS_CARD);
    }
}
