/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class UMLMetafacadeUtils {
    public static boolean isType(ClassifierFacade classifier, String typeName) {
        boolean isType = false;
        if (classifier != null && typeName != null) {
            final String type = StringUtils.trimToEmpty((String)typeName);
            String name = StringUtils.trimToEmpty((String)classifier.getFullyQualifiedName(true));
            isType = name.equals(type);
            if (!isType) {
                isType = CollectionUtils.find((Collection)classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        String name = StringUtils.trimToEmpty((String)((ModelElementFacade)object).getFullyQualifiedName(true));
                        return name.equals(type);
                    }
                }) != null;
            }
        }
        return isType;
    }

    public static String getGetterPrefix(ClassifierFacade type) {
        return type != null && type.isBooleanType() && type.isPrimitive() ? "is" : "get";
    }

    public static boolean isConstraintKind(String expression, String kind) {
        Pattern pattern = Pattern.compile(".*\\s*" + StringUtils.trimToEmpty((String)kind) + "\\s*\\w*\\s*:.*", 32);
        Matcher matcher = pattern.matcher(StringUtils.trimToEmpty((String)expression));
        return matcher.matches();
    }
}

