/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;

public class TuttiWeightComputingService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiWeightComputingService.class);
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    private int currentSpeciesRowIndex;
    private int currentBenthosRowIndex;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
    }

    public Map<String, String> checkCruise(String cruiseId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check cruise: " + cruiseId));
        }
        TreeMap result = Maps.newTreeMap();
        List<FishingOperation> allFishingOperation = this.persistenceService.getAllFishingOperation(cruiseId);
        for (FishingOperation fishingOperation : allFishingOperation) {
            BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
            BatchContainer<BenthosBatch> rootBenthosBatch;
            BatchContainer<SpeciesBatch> rootSpeciesBatch;
            String fishingOperationId = fishingOperation.getId();
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
            try {
                rootSpeciesBatch = this.getComputedSpeciesBatches(fishingOperation);
            }
            catch (TuttiBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
                rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId);
            }
            try {
                rootBenthosBatch = this.getComputedBenthosBatches(fishingOperation);
            }
            catch (TuttiBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
                rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId);
            }
            try {
                Float weight = catchBatch == null ? null : catchBatch.getMarineLitterTotalWeight();
                rootMarineLitterBatch = this.getComputedMarineLitterBatches(fishingOperation, weight);
            }
            catch (TuttiBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
                rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
            }
            try {
                if (catchBatch == null) continue;
                this.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
            }
            catch (TuttiBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
            }
        }
        return result;
    }

    public void computeCatchBatchWeights(CatchBatch catchBatch, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, BatchContainer<MarineLitterBatch> rootMarineLitterBatch) {
        Float inertWeight;
        Float speciesTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float speciesTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootSpeciesBatch != null) {
            for (int i = 0; i < rootSpeciesBatch.getChildren().size(); ++i) {
                SpeciesBatch row = (SpeciesBatch)rootSpeciesBatch.getChildren().get(i);
                Float weight = row.getSampleCategoryWeight();
                if (weight == null) {
                    weight = row.getSampleCategoryComputedWeight();
                }
                if (weight == null) {
                    return;
                }
                CaracteristicQualitativeValue value = (CaracteristicQualitativeValue)row.getSampleCategoryValue();
                if (SortedUnsortedEnum.SORTED.matchValue(value)) {
                    speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + weight.floatValue());
                    continue;
                }
                speciesTotalComputedUnsortedWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
            }
        }
        if ((inertWeight = catchBatch.getSpeciesTotalInertWeight()) != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = catchBatch.getSpeciesTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setSpeciesTotalSampleSortedComputedWeight(speciesTotalComputedSortedWeight);
        Float speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = speciesTotalComputedSortedWeight;
            catchBatch.setSpeciesTotalSortedComputedWeight(speciesTotalSortedWeight);
        } else if (speciesTotalSortedWeight.floatValue() < speciesTotalComputedSortedWeight.floatValue()) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.operations.computeWeights.error.species.incoherentTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setSpeciesTotalUnsortedComputedWeight(speciesTotalComputedUnsortedWeight);
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedComputedWeight();
        }
        Float speciesTotalWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
        catchBatch.setSpeciesTotalComputedWeight(speciesTotalWeight);
        Float benthosTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float benthosTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootBenthosBatch != null) {
            for (int i = 0; i < rootBenthosBatch.getChildren().size(); ++i) {
                BenthosBatch row = (BenthosBatch)rootBenthosBatch.getChildren().get(i);
                Float weight = row.getSampleCategoryWeight();
                if (weight == null) {
                    weight = row.getSampleCategoryComputedWeight();
                }
                if (weight == null) {
                    return;
                }
                CaracteristicQualitativeValue value = (CaracteristicQualitativeValue)row.getSampleCategoryValue();
                if (SortedUnsortedEnum.SORTED.matchValue(value)) {
                    benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + weight.floatValue());
                    continue;
                }
                benthosTotalComputedUnsortedWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
            }
        }
        if ((inertWeight = catchBatch.getBenthosTotalInertWeight()) != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        livingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setBenthosTotalSampleSortedComputedWeight(benthosTotalComputedSortedWeight);
        Float benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedWeight();
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = benthosTotalComputedSortedWeight;
            catchBatch.setBenthosTotalSortedComputedWeight(benthosTotalSortedWeight);
        } else if (benthosTotalSortedWeight.floatValue() < benthosTotalComputedSortedWeight.floatValue()) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.operations.computeWeights.error.benthos.incoherentTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setBenthosTotalUnsortedComputedWeight(benthosTotalComputedUnsortedWeight);
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedComputedWeight();
        }
        Float benthosTotalWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setBenthosTotalComputedWeight(benthosTotalWeight);
        Float marineLitterTotalComputedWeight = Float.valueOf(0.0f);
        if (rootMarineLitterBatch != null) {
            for (int i = 0; i < rootMarineLitterBatch.getChildren().size(); ++i) {
                MarineLitterBatch row = (MarineLitterBatch)rootMarineLitterBatch.getChildren().get(i);
                Float rowWeight = row.getWeight();
                if (rowWeight == null) {
                    marineLitterTotalComputedWeight = null;
                    break;
                }
                marineLitterTotalComputedWeight = Float.valueOf(marineLitterTotalComputedWeight.floatValue() + rowWeight.floatValue());
            }
        }
        catchBatch.setMarineLitterTotalComputedWeight(marineLitterTotalComputedWeight);
        Float marineLitterTotalWeight = catchBatch.getMarineLitterTotalWeight();
        if (marineLitterTotalWeight == null) {
            marineLitterTotalWeight = marineLitterTotalComputedWeight;
        } else if (marineLitterTotalComputedWeight != null && marineLitterTotalWeight.floatValue() < marineLitterTotalComputedWeight.floatValue()) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.operations.computeWeights.error.marineLitter.incoherentTotal", (Object[])new Object[0]));
        }
        Float totalUnsortedWeight = Float.valueOf(catchBatch.getSpeciesTotalUnsortedComputedWeight().floatValue() + catchBatch.getBenthosTotalUnsortedComputedWeight().floatValue());
        Float totalSortedWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setCatchTotalSortedComputedWeight(totalSortedWeight);
        catchBatch.setCatchTotalUnsortedComputedWeight(totalUnsortedWeight);
        Float totalWeight = catchBatch.getCatchTotalWeight();
        Float rejectedWeight = catchBatch.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue()))) {
                throw new TuttiBusinessException(I18n._((String)"tutti.service.operations.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
            }
            catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(totalWeight.floatValue() - totalUnsortedWeight.floatValue() - totalSortedWeight.floatValue()));
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            catchBatch.setCatchTotalComputedWeight(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()));
        } else if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.operations.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
        }
    }

    public BatchContainer<SpeciesBatch> getComputedSpeciesBatches(FishingOperation operation) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId());
        this.currentSpeciesRowIndex = 0;
        if (rootSpeciesBatch != null) {
            List roots = rootSpeciesBatch.getChildren();
            for (SpeciesBatch batch : roots) {
                this.computeSpeciesBatch(batch);
            }
        }
        return rootSpeciesBatch;
    }

    protected Float computeSpeciesBatch(SpeciesBatch batch) {
        Float result = null;
        int thisIndex = this.currentSpeciesRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        NuitonValidatorResult validation = this.validationService.validateSpeciesBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            throw new TuttiBusinessException(I18n._((String)((String)messages.get(0)), (Object[])new Object[0]));
        }
        List children = batch.getChildBatchs();
        if (batch.sizeChildBatchs() > 0) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatch child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(sum);
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.species.incoherentParentCategoryWeight", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.SPECIES, thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(frequencyWeight);
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                        if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                            throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.species.incoherentCategoryWeight", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.SPECIES, thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(frequencyWeight);
                        } else if (!rowWeight.equals(frequencyWeight)) {
                            throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.species.incoherentRowWeightFrequency", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.SPECIES, thisIndex);
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
            } else {
                result = categoryWeight;
            }
        }
        if (result == null && batch.getParentBatch() == null) {
            throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.species.noWeight", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.SPECIES, thisIndex);
        }
        return result;
    }

    public BatchContainer<BenthosBatch> getComputedBenthosBatches(FishingOperation operation) {
        BatchContainer<BenthosBatch> rootBenthosBatch = this.persistenceService.getRootBenthosBatch(operation.getId());
        this.currentBenthosRowIndex = 0;
        if (rootBenthosBatch != null) {
            List roots = rootBenthosBatch.getChildren();
            for (BenthosBatch batch : roots) {
                this.computeBenthosBatch(batch);
            }
        }
        return rootBenthosBatch;
    }

    protected Float computeBenthosBatch(BenthosBatch batch) {
        Float result = null;
        int thisIndex = this.currentBenthosRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        NuitonValidatorResult validation = this.validationService.validateBenthosBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            throw new TuttiBusinessException(I18n._((String)((String)messages.get(0)), (Object[])new Object[0]));
        }
        List children = batch.getChildBatchs();
        if (batch.sizeChildBatchs() > 0) {
            Float sum = Float.valueOf(0.0f);
            for (BenthosBatch child : children) {
                Float weight = this.computeBenthosBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(sum);
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.benthos.incoherentParentCategoryWeight", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.BENTHOS, thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<BenthosBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (BenthosBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(frequencyWeight);
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                        if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                            throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.benthos.incoherentCategoryWeight", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.BENTHOS, thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(frequencyWeight);
                        } else if (!rowWeight.equals(frequencyWeight)) {
                            throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.benthos.incoherentRowWeightFrequency", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.BENTHOS, thisIndex);
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
            } else {
                result = categoryWeight;
            }
        }
        if (result == null && batch.getParentBatch() == null) {
            throw new TuttiWeightComputingException(I18n._((String)"tutti.service.operations.computeWeights.error.benthos.noWeight", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.BENTHOS, thisIndex);
        }
        return result;
    }

    public BatchContainer<MarineLitterBatch> getComputedMarineLitterBatches(FishingOperation operation, Float marineLitterweight) {
        String fishingOperationId = operation.getId();
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        if (rootMarineLitterBatch != null) {
            boolean checkWeight = marineLitterweight == null;
            List children = rootMarineLitterBatch.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                MarineLitterBatch batch = (MarineLitterBatch)children.get(i);
                if (!checkWeight || batch.getWeight() != null) continue;
                throw new TuttiWeightComputingException(I18n._((String)"tutti.validator.warning.marineLitter.weight.required", (Object[])new Object[0]), TuttiWeightComputingException.CatchType.MARINE_LITTER, i);
            }
        }
        return rootMarineLitterBatch;
    }
}

