package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportOperationValidationMessagesAction.java 897 2013-04-30 14:28:59Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/ExportOperationValidationMessagesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.0.1
 */
public class ExportOperationValidationMessagesAction extends AbstractTuttiAction <ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {

    protected File file;

    /** Validation service. */
    protected ValidateCruiseOperationsService validationService = getContext().getValidateCruiseOperationsService();

    public ExportOperationValidationMessagesAction(ValidateCruiseUIHandler handler) {
        super(handler, false);
        setActionDescription(_("tutti.validateCruise.action.export.operation.tip"));
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();

        // choose file to export
        file = TuttiUIUtil.saveFile(
                _("tutti.validateCruise.action.export.operation.chooseFile.defaultFile",
                        decorate(getModel().getSelectedFishingOperation(), DecoratorService.FILE_NAME_COMPATIBLE)),
                getContext().getMainUI(),
                _("tutti.validateCruise.action.export.operation.chooseFile.title"),
                _("tutti.validateCruise.action.export.operation.chooseFile.label")
        );
        doAction = file != null;
        if (doAction) {
            // ask user to confirm overwrite.
            doAction = getHandler().askOverwriteFile(file);
        }
        return doAction;
    }

    @Override
    protected void doAction() throws Exception {
        ValidateCruiseUIModel uiModel = getModel();
        FishingOperation operation = getModel().getSelectedFishingOperation();
        validationService.exportValidationResult(file, operation, uiModel.getValidator().get(operation));
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        file = null;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.validateCruise.action.export.operation.success", file));
    }
}
