/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateBenthosBatchUIHandler
extends AbstractTuttiUIHandler<CreateBenthosBatchUIModel, CreateBenthosBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CreateBenthosBatchUIHandler.class);
    private final TuttiPersistence persistenceService;
    private final CaracteristicQualitativeValue sortedValue;

    public CreateBenthosBatchUIHandler(TuttiUI parentUi, CreateBenthosBatchUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.sortedValue = SortedUnsortedEnum.SORTED.getValue(caracteristic);
    }

    @Override
    public void beforeInitUI() {
        CreateBenthosBatchUIModel model = new CreateBenthosBatchUIModel();
        ((CreateBenthosBatchUI)this.ui).setContextValue(model);
        this.listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanFilterableComboBox(((CreateBenthosBatchUI)this.ui).getSpeciesComboBox(), Lists.newArrayList(), null, "fromProtocol");
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.initBeanFilterableComboBox(((CreateBenthosBatchUI)this.ui).getSortedUnsortedCategoryComboBox(), caracteristic.getQualitativeValue(), null);
        ((CreateBenthosBatchUIModel)((Object)this.getModel())).addPropertyChangeListener("species", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CreateBenthosBatchUIModel source = (CreateBenthosBatchUIModel)((Object)evt.getSource());
                Species newValue = (Species)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("New Selected species " + (newValue == null ? null : newValue.getRefTaxCode())));
                }
                if (newValue == null || source.getSpeciesUsed() == null) {
                    source.setSortedUnsortedCategory(null);
                } else {
                    CaracteristicQualitativeValue qualitativeValue;
                    List qualitativeValues = ((CreateBenthosBatchUI)CreateBenthosBatchUIHandler.this.ui).getSortedUnsortedCategoryComboBox().getData();
                    CaracteristicQualitativeValue newCategory = null;
                    Iterator i$ = qualitativeValues.iterator();
                    while (!(!i$.hasNext() || source.isSpeciesAndCategoryAvailable(newValue, qualitativeValue = (CaracteristicQualitativeValue)i$.next()) && (newCategory = qualitativeValue).equals(CreateBenthosBatchUIHandler.this.sortedValue))) {
                    }
                    source.setSortedUnsortedCategory(newCategory);
                }
            }
        });
        this.listenValidatorValid((SimpleBeanValidator)((CreateBenthosBatchUI)this.ui).getValidator(), (AbstractTuttiBeanUIModel)((Object)this.getModel()));
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((CreateBenthosBatchUI)this.getUI()).getSpeciesComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((CreateBenthosBatchUI)this.ui).getValidator().setBean(null);
        ((CreateBenthosBatchUIModel)((Object)this.getModel())).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setBenthosSelectedCard("main");
    }

    @Override
    public SwingValidator<CreateBenthosBatchUIModel> getValidator() {
        return ((CreateBenthosBatchUI)this.ui).getValidator();
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void openUI(BenthosBatchUIModel batchModel) {
        CreateBenthosBatchUIModel model = (CreateBenthosBatchUIModel)((Object)this.getModel());
        ((CreateBenthosBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSpecies(null);
        model.setSortedUnsortedCategory(null);
        model.setBatchWeight(null);
        ArrayList speciesToUse = Lists.newArrayList();
        Multimap<CaracteristicQualitativeValue, Species> speciesUsed = model.getSpeciesUsed();
        speciesUsed.clear();
        if (batchModel != null) {
            speciesUsed.putAll(batchModel.getSpeciesUsed());
            List allSpecies = this.getDataContext().getReferentBenthosWithSurveyCode();
            speciesToUse.addAll(allSpecies);
        }
        model.setAvailableSpecies(speciesToUse);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getBenthosTabContent().getHandler().addBatch((CreateBenthosBatchUIModel)((Object)this.getModel()));
        this.closeUI(this.ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        Species result = model.getSelectedSpecies();
        return result;
    }
}

