/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import fr.ifremer.adagio.core.dao.referential.taxon.VirtualComponent;
import fr.ifremer.adagio.core.dao.referential.taxon.VirtualComponentDao;
import fr.ifremer.adagio.core.dao.referential.taxon.VirtualComponentImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.VirtualComponentPK;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class VirtualComponentDaoBase
extends HibernateDaoSupport
implements VirtualComponentDao {
    @Override
    public Object load(int transform, TaxonName taxonName, ReferenceTaxon referenceTaxon) {
        VirtualComponentPK entityPk = new VirtualComponentPK();
        if (taxonName == null) {
            throw new IllegalArgumentException("VirtualComponent.load - 'taxonName' can not be null");
        }
        if (referenceTaxon == null) {
            throw new IllegalArgumentException("VirtualComponent.load - 'referenceTaxon' can not be null");
        }
        entityPk.setTaxonName(taxonName);
        entityPk.setReferenceTaxon(referenceTaxon);
        Object entity = this.getHibernateTemplate().get(VirtualComponentImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (VirtualComponent)entity);
    }

    @Override
    public VirtualComponent load(TaxonName taxonName, ReferenceTaxon referenceTaxon) {
        return (VirtualComponent)this.load(0, taxonName, referenceTaxon);
    }

    @Override
    public Collection<VirtualComponent> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(VirtualComponentImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public VirtualComponent create(VirtualComponent virtualComponent) {
        return (VirtualComponent)this.create(0, virtualComponent);
    }

    @Override
    public Object create(int transform, VirtualComponent virtualComponent) {
        if (virtualComponent == null) {
            throw new IllegalArgumentException("VirtualComponent.create - 'virtualComponent' can not be null");
        }
        this.getHibernateTemplate().save((Object)virtualComponent);
        return this.transformEntity(transform, virtualComponent);
    }

    @Override
    public Collection<VirtualComponent> create(Collection<VirtualComponent> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<VirtualComponent> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VirtualComponent.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VirtualComponentDaoBase.this.create(transform, (VirtualComponent)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public VirtualComponent create(Timestamp updateDate, TaxonName taxonName, ReferenceTaxon referenceTaxon) {
        return (VirtualComponent)this.create(0, updateDate, taxonName, referenceTaxon);
    }

    @Override
    public Object create(int transform, Timestamp updateDate, TaxonName taxonName, ReferenceTaxon referenceTaxon) {
        VirtualComponentImpl entity = new VirtualComponentImpl();
        VirtualComponentPK entityPk = new VirtualComponentPK();
        entity.setVirtualComponentPk(entityPk);
        entity.setUpdateDate(updateDate);
        entityPk.setTaxonName(taxonName);
        entityPk.setReferenceTaxon(referenceTaxon);
        return this.create(transform, entity);
    }

    @Override
    public VirtualComponent create(ReferenceTaxon referenceTaxon, TaxonName taxonName) {
        return (VirtualComponent)this.create(0, referenceTaxon, taxonName);
    }

    @Override
    public Object create(int transform, ReferenceTaxon referenceTaxon, TaxonName taxonName) {
        VirtualComponentImpl entity = new VirtualComponentImpl();
        VirtualComponentPK entityPk = new VirtualComponentPK();
        entity.setVirtualComponentPk(entityPk);
        entityPk.setReferenceTaxon(referenceTaxon);
        entityPk.setTaxonName(taxonName);
        return this.create(transform, entity);
    }

    @Override
    public void update(VirtualComponent virtualComponent) {
        if (virtualComponent == null) {
            throw new IllegalArgumentException("VirtualComponent.update - 'virtualComponent' can not be null");
        }
        this.getHibernateTemplate().update((Object)virtualComponent);
    }

    @Override
    public void update(final Collection<VirtualComponent> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VirtualComponent.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VirtualComponentDaoBase.this.update((VirtualComponent)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(VirtualComponent virtualComponent) {
        if (virtualComponent == null) {
            throw new IllegalArgumentException("VirtualComponent.remove - 'virtualComponent' can not be null");
        }
        this.getHibernateTemplate().delete((Object)virtualComponent);
    }

    @Override
    public void remove(TaxonName taxonName, ReferenceTaxon referenceTaxon) {
        VirtualComponentPK entityPk = new VirtualComponentPK();
        if (taxonName == null) {
            throw new IllegalArgumentException("VirtualComponent.remove - 'taxonName' can not be null");
        }
        entityPk.setTaxonName(taxonName);
        if (referenceTaxon == null) {
            throw new IllegalArgumentException("VirtualComponent.remove - 'referenceTaxon' can not be null");
        }
        entityPk.setReferenceTaxon(referenceTaxon);
        VirtualComponent entity = this.load(taxonName, referenceTaxon);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<VirtualComponent> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VirtualComponent.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, VirtualComponent entity) {
        VirtualComponent target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected VirtualComponent toEntity(Object[] row) {
        VirtualComponent target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof VirtualComponent)) continue;
                target = (VirtualComponent)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VirtualComponentImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VirtualComponentImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<VirtualComponent> search(Search search) {
        return this.search(0, search);
    }
}

