package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchTableModel.java 787 2013-04-15 23:10:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/SpeciesBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;

import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SpeciesBatchTableModel extends AbstractTuttiTableModel<SpeciesBatchRowModel> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(SpeciesBatchTableModel.class);

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editSpeciesBatch.table.header.species"),
            n_("tutti.editSpeciesBatch.table.header.species"));

    public static final SampleCategoryColumnIdentifier<SpeciesBatchRowModel> SORTED_UNSORTED_CATEGORY = SampleCategoryColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SORTED_UNSORTED_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_SORTED_UNSORTED_CATEGORY_WEIGHT,
            SampleCategoryEnum.sortedUnsorted,
            n_("tutti.editSpeciesBatch.table.header.sortedUnsortedCategory"),
            n_("tutti.editSpeciesBatch.table.header.sortedUnsortedCategory"));

    public static final SampleCategoryColumnIdentifier<SpeciesBatchRowModel> SIZE_CATEGORY = SampleCategoryColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SIZE_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_SIZE_CATEGORY_WEIGHT,
            SampleCategoryEnum.size,
            n_("tutti.editSpeciesBatch.table.header.sizeCategory"),
            n_("tutti.editSpeciesBatch.table.header.sizeCategory"));

    public static final SampleCategoryColumnIdentifier<SpeciesBatchRowModel> SEX_CATEGORY = SampleCategoryColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SEX_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_SEX_CATEGORY_WEIGHT,
            SampleCategoryEnum.sex,
            n_("tutti.editSpeciesBatch.table.header.sexCategory"),
            n_("tutti.editSpeciesBatch.table.header.sexCategory"));

    public static final SampleCategoryColumnIdentifier<SpeciesBatchRowModel> MATURITY_CATEGORY = SampleCategoryColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_MATURITY_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_MATURITY_CATEGORY_WEIGHT,
            SampleCategoryEnum.maturity,
            n_("tutti.editSpeciesBatch.table.header.maturityCategory"),
            n_("tutti.editSpeciesBatch.table.header.maturityCategory"));

    public static final SampleCategoryColumnIdentifier<SpeciesBatchRowModel> AGE_CATEGORY = SampleCategoryColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_AGE_CATEGORY,
            SpeciesBatchRowModel.PROPERTY_AGE_CATEGORY_WEIGHT,
            SampleCategoryEnum.age,
            n_("tutti.editSpeciesBatch.table.header.ageCategory"),
            n_("tutti.editSpeciesBatch.table.header.ageCategory"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMPUTED_WEIGHT,
            n_("tutti.editSpeciesBatch.table.header.weight"),
            n_("tutti.editSpeciesBatch.table.header.weight"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMPUTED_NUMBER,
            n_("tutti.editSpeciesBatch.table.header.computedNumber"),
            n_("tutti.editSpeciesBatch.table.header.computedNumber"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editSpeciesBatch.table.header.comment"),
            n_("tutti.editSpeciesBatch.table.header.comment"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId(
            SpeciesBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editSpeciesBatch.table.header.file"),
            n_("tutti.editSpeciesBatch.table.header.file"));

    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_SPECIES_TO_CONFIRM,
            n_("tutti.editSpeciesBatch.table.header.toConfirm"),
            n_("tutti.editSpeciesBatch.table.header.toConfirm"));

    /**
     * Columns for the frequency edition.
     *
     * @since 0.2
     */
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> frequencyCols;

    /**
     * Columns implies in the sample category definition.
     *
     * @since 0.2
     */
    protected final Set<SampleCategoryColumnIdentifier<SpeciesBatchRowModel>> sampleCols;

    public SpeciesBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        setNoneEditableCols(SPECIES);

        frequencyCols = Sets.newHashSet();
        frequencyCols.add(COMPUTED_NUMBER);
        frequencyCols.add(WEIGHT);

        sampleCols = Sets.newHashSet();
        sampleCols.add(SORTED_UNSORTED_CATEGORY);
        sampleCols.add(SIZE_CATEGORY);
        sampleCols.add(SEX_CATEGORY);
        sampleCols.add(MATURITY_CATEGORY);
        sampleCols.add(AGE_CATEGORY);
    }

    public SampleCategoryColumnIdentifier<SpeciesBatchRowModel> getCategoryIdentifierForWeightProperty(String weightPropertyName) {
        SampleCategoryColumnIdentifier<SpeciesBatchRowModel> result = null;
        for (SampleCategoryColumnIdentifier<SpeciesBatchRowModel> sampleCol : sampleCols) {
            if (weightPropertyName.equals(sampleCol.getWeightPropertyName())) {
                result = sampleCol;
                break;
            }
        }
        return result;
    }

    @Override
    public SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue,
                           int rowIndex,
                           int columnIndex,
                           ColumnIdentifier<SpeciesBatchRowModel> propertyName,
                           SpeciesBatchRowModel entry) {
        if (sampleCols.contains(propertyName)) {

            SampleCategoryColumnIdentifier<SpeciesBatchRowModel> sampleCategoryColumnIdentifier = (SampleCategoryColumnIdentifier<SpeciesBatchRowModel>) propertyName;
            sampleCategoryColumnIdentifier.setWeightValue(entry, aValue);

            // must find out first ancestor with this category
            SampleCategoryEnum sampleCategoryType = sampleCategoryColumnIdentifier.getSampleCategoryType();
            if (log.isDebugEnabled()) {
                log.debug("Sample category: " + sampleCategoryType + " modified at row: " + rowIndex);
            }
            SampleCategory<?> sampleCategory = entry.getSampleCategory(sampleCategoryType);
            SpeciesBatchRowModel firstAncestor = entry.getFirstAncestor(sampleCategory);

            int firstRowIndex = getRowIndex(firstAncestor);
            if (log.isDebugEnabled()) {
                log.debug("First ancestor row: " + firstRowIndex);
            }

            // must save this row now

            // get shell of the ancestor
            Set<SpeciesBatchRowModel> shell = Sets.newHashSet();
            firstAncestor.collectShell(shell);

            for (SpeciesBatchRowModel batchRowModel : shell) {
                int currentRowIndex = getRowIndex(batchRowModel);
                if (log.isDebugEnabled()) {
                    log.debug("Update shell row: " + currentRowIndex);
                }
                fireTableCellUpdated(currentRowIndex, columnIndex);
            }
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }
    }

//    @Override
//    public void setValueAt(Object aValue,
//                           int rowIndex,
//                           int columnIndex,
//                           ColumnIdentifier<SpeciesBatchRowModel> propertyName,
//                           SpeciesBatchRowModel entry) {
//        if (sampleCols.contains(propertyName)) {
//
//            ((SampleCategoryColumnIdentifier<SpeciesBatchRowModel>) propertyName).setWeightValue(entry, aValue);
//        } else {
//            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
//        }
//    }

    @Override
    protected boolean isCellEditable(int rowIndex,
                                     int columnIndex,
                                     ColumnIdentifier<SpeciesBatchRowModel> propertyName) {

        boolean result = super.isCellEditable(rowIndex,
                                              columnIndex,
                                              propertyName);
        if (result) {

            if (frequencyCols.contains(propertyName)) {

                // must have filled a species to edit this column
                SpeciesBatchRowModel entry = getEntry(rowIndex);
                result = entry.isValid() && entry.isBatchLeaf();

            } else if (sampleCols.contains(propertyName)) {

                SampleCategoryColumnIdentifier<SpeciesBatchRowModel> samplePropertyName = (SampleCategoryColumnIdentifier<SpeciesBatchRowModel>) propertyName;

                // can only edit if a category value is setted
                SpeciesBatchRowModel entry = getEntry(rowIndex);

                // check from protocol what is possible ?
                Species species = entry.getSpecies();

                if (species == null) {

                    // no species, can not edit
                    result = false;
                } else {

                    // protocol authorize it

                    // final test: can edit only if sample category is setted
                    SampleCategory<?> value =
                            (SampleCategory<?>) propertyName.getValue(entry);

                    result = value.getCategoryValue() != null;

                }
            }
        }
        return result;
    }
}
