package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class IndividualObservationBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<IndividualObservationBatchUIModel, IndividualObservationBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INDIVIDUAL_OBSERVATION_BATCH_ATTACHMENTS_BUTTON_ENABLED = "individualObservationBatchAttachmentsButton.enabled";
    public static final String BINDING_REMOVE_INDIVIDUAL_OBSERVATION_BATCH_MENU_ENABLED = "removeIndividualObservationBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1WTXMbNRhW3Nhpvgg0NITpx6QhlIQMMj3BNFASpwlxcD4mNkyGHIK8K9tK5NVWq03d8ZjhJwC/AO5cmOHGieHAmQMXhr/AMBy4MrzSrne9xK5NwrSHbfxK7/M+eiQ9r775HaU9ie6ckEYDS99RrE7x9trh4V75hFrqIfUsyVwlJAr+DaVQ6giN21HcU+iVo4JOz4bp2XVRd4VDnY7slQIa89QTTr0apUqhW8kMy/OyxWh4peH6so0akeqG+tWff6Q+tz/7OoVQwwV2U7CUuX5Z8UqGCyjFbIWuQaUzkuXEqQINyZwq8J3UsXVOPG+X1Okj9CkaKaCMSySAKTQ/+JINhslvuArdpTZTecdmZ8z2Cd8re1SeEcWEkyPKqpWEu08cyhWqVCRmFUnrVGLlK8Wwz7D3GMhhSzgKamHhUmlSsaVzqYdZBCxiYNy73Id51zXcMgqN1IhjcyoVqj+b0ltBvZhBui5svfTTZ1N/R1eLq4+eEc5sAlun0HLiEEUDIYmi/n7UDsYImbIUp1rApd4LKOmfW1A3Z+bGyQus96Eg5ZIQPEcA+kV9LBsh2HYY1hCjEdJyb6Q1pYhVq4OCXg6IgJjofm+uvmIckygFBykxhq43G5UdU6TM6b5wfTjmMwmaJrhDHb9juVBRnNHe+6OnK3Q9gaNjeUXrGuN2BDVcEbKu0Gxiz0K1NaWkOhOGphaurPW8liSq756euBDNv7oQRN/Uv5f057Vo7K4lKVFPWURb5OlElSCqMV6PoKYMraIlBee6nkIvJXLikeRy0iZPoRtCVvEJ+PKpEm6Q1MDbh5EAWRe88UZCInBdHLtubItDRygtfQiDpkfnjfoAhgKLnv2XRWtAM/r3zPQv3//23Wbbl8eg9vWuUzvaCvilK/W9VkyXngpMWZ/B7A5xV47QqEc59CTTc252IVYMh4Ec1HtBpwdHeIt4NYBIj/z6w48zn/x8BaU20RgXxN4ken4ejaqaBBUEtxvue6uG0cTjq/B9XnMDkY9rcGMVutecN1dE/8JPN3Ks58y3GiDTzS4yRVzLoz/9NV38drUt1RBQf7nn9Fiu9McowxzOHGqaWNifujatcdejvi3iPtStM6GBW5MbXuL75vvgnF5XwEoroG54MNMVwj34PyNc8sjvCEyWhbSp3CcMLN1uxxu+Rs0ZJfRfD9GA1tiPFmzjCHU0J6h1q2laDa5SFTx08vbi0tydd+ccn/NWNw7/xVQHoJLmpKxb3VuB5fY5S4opTnHZFLN02OtGscOA+zEYBvmD2wRgug8q9GqzwDxV7AxyXMzvvl/YOC5uFDbWS/m93Rb4oQcNMrm10xHUppC0KoXvgMaTzXXBoWfmCmvrH7Q6Z+WIddqelWn2lDywtn5LSUMDULShBtWSWMGzwTi3CYFyQTCvXxdowuj8RjABfrJ7bzs7DnQrh1kKrV6wCK5HEOMKTmyJuSXDeuWigAqemZEzrYbOdAGctlGd34AB21u/HRrpvHm3w5vHvAPzADA4G8Ho4lLrYpspY6jumwkVqdnMYwMbXCKFcPOgzytkLdRLO2Xrcoehg+T/cxg6AS9zGDpxeh+GgR5sAzhfhpMnAtih596B5zOZK2tjdaoPztUc0t+xvog6/IX+fNkdYfHSCMuA8A/Qirr8KA8AAA==";
    private static final Log log = LogFactory.getLog(IndividualObservationBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createIndividualObservationBatchButton;
    protected IndividualObservationBatchUI editIndividualObservationBatchTopPanel = this;
    protected Table form;
    protected IndividualObservationBatchUIHandler handler;
    protected ButtonAttachment individualObservationBatchAttachmentsButton;
    protected JToolBar individualObservationBatchTabToolBar;
    protected IndividualObservationBatchUIModel model;
    protected JMenuItem removeIndividualObservationBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<IndividualObservationBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IndividualObservationBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            IndividualObservationBatchUIHandler handler = new IndividualObservationBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public IndividualObservationBatchUI() {
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IndividualObservationBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IndividualObservationBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IndividualObservationBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createIndividualObservationBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateIndividualObservationBatchButton() {
        return createIndividualObservationBatchButton;
    }

    public Table getForm() {
        return form;
    }

    public IndividualObservationBatchUIHandler getHandler() {
        return handler;
    }

    public ButtonAttachment getIndividualObservationBatchAttachmentsButton() {
        return individualObservationBatchAttachmentsButton;
    }

    public JToolBar getIndividualObservationBatchTabToolBar() {
        return individualObservationBatchTabToolBar;
    }

    public IndividualObservationBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveIndividualObservationBatchMenu() {
        return removeIndividualObservationBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<IndividualObservationBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditIndividualObservationBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(individualObservationBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(tableToolbar, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToIndividualObservationBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationBatchTabToolBar.add(individualObservationBatchAttachmentsButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeIndividualObservationBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editIndividualObservationBatch.help"));
    }

    protected void createCreateIndividualObservationBatchButton() {
        $objectMap.put("createIndividualObservationBatchButton", createIndividualObservationBatchButton = new JButton());
        
        createIndividualObservationBatchButton.setName("createIndividualObservationBatchButton");
        createIndividualObservationBatchButton.setText(_("tutti.editIndividualObservationBatch.action.createBatch"));
        createIndividualObservationBatchButton.setToolTipText(_("tutti.editIndividualObservationBatch.action.createBatch.tip"));
        createIndividualObservationBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createIndividualObservationBatchButton"));
        createIndividualObservationBatchButton.putClientProperty("help", "tutti.editIndividualObservationBatch.action.createBatch.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(IndividualObservationBatchUIHandler.class));
    }

    protected void createIndividualObservationBatchAttachmentsButton() {
        $objectMap.put("individualObservationBatchAttachmentsButton", individualObservationBatchAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        individualObservationBatchAttachmentsButton.setName("individualObservationBatchAttachmentsButton");
    }

    protected void createIndividualObservationBatchTabToolBar() {
        $objectMap.put("individualObservationBatchTabToolBar", individualObservationBatchTabToolBar = new JToolBar());
        
        individualObservationBatchTabToolBar.setName("individualObservationBatchTabToolBar");
        individualObservationBatchTabToolBar.setFloatable(false);
        individualObservationBatchTabToolBar.setOpaque(false);
        individualObservationBatchTabToolBar.setBorderPainted(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(IndividualObservationBatchUIModel.class));
    }

    protected void createRemoveIndividualObservationBatchMenu() {
        $objectMap.put("removeIndividualObservationBatchMenu", removeIndividualObservationBatchMenu = new JMenuItem());
        
        removeIndividualObservationBatchMenu.setName("removeIndividualObservationBatchMenu");
        removeIndividualObservationBatchMenu.setText(_("tutti.editIndividualObservationBatch.action.removeBatch"));
        removeIndividualObservationBatchMenu.setToolTipText(_("tutti.editIndividualObservationBatch.action.removeBatch.tip"));
        removeIndividualObservationBatchMenu.putClientProperty("help", "tutti.editIndividualObservationBatch.action.removeBatch.help");
        removeIndividualObservationBatchMenu.putClientProperty("tuttiAction", RemoveIndividualObservationBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editIndividualObservationBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(IndividualObservationBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditIndividualObservationBatchTopPanel();
        addChildrenToValidator();
        addChildrenToIndividualObservationBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createIndividualObservationBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        removeIndividualObservationBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeIndividualObservationBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editIndividualObservationBatch.action.removeBatch.mnemonic"),'Z'));
        createIndividualObservationBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createIndividualObservationBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editIndividualObservationBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editIndividualObservationBatchTopPanel, "tuttihelp.editIndividualObservationBatch.help");
        registerHelpId(_broker, removeIndividualObservationBatchMenu, "tutti.editIndividualObservationBatch.action.removeBatch.help");
        registerHelpId(_broker, createIndividualObservationBatchButton, "tutti.editIndividualObservationBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editIndividualObservationBatchTopPanel", editIndividualObservationBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createIndividualObservationBatchTabToolBar();
        createIndividualObservationBatchAttachmentsButton();
        createTablePopup();
        createRemoveIndividualObservationBatchMenu();
        createForm();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateIndividualObservationBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editIndividualObservationBatchTopPanel
        setName("editIndividualObservationBatchTopPanel");
        setLayout(new BorderLayout());
        editIndividualObservationBatchTopPanel.putClientProperty("help", "tuttihelp.editIndividualObservationBatch.help");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_BATCH_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationBatchAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_INDIVIDUAL_OBSERVATION_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeIndividualObservationBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
    }

}