package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: SampleCategoryColumnIdentifier.java 787 2013-04-15 23:10:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/SampleCategoryColumnIdentifier.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public class SampleCategoryColumnIdentifier<R> extends ColumnIdentifier<R> {

    private static final long serialVersionUID = 1L;

    public static <R> SampleCategoryColumnIdentifier<R> newId(String propertyName,
                                                              String weightPropertyName,
                                                              SampleCategoryEnum sampleCategoryType,
                                                              String headerI18nKey,
                                                              String headerTipI18nKey) {
        return new SampleCategoryColumnIdentifier<R>(propertyName,
                                                     weightPropertyName,
                                                     sampleCategoryType,
                                                     headerI18nKey,
                                                     headerTipI18nKey);
    }

    private final SampleCategoryEnum sampleCategoryType;

    private final String weightPropertyName;

    SampleCategoryColumnIdentifier(String propertyName,
                                   String weightPropertyName,
                                   SampleCategoryEnum sampleCategoryType,
                                   String headerI18nKey,
                                   String headerTipI18nKey    ) {
        super(propertyName, headerI18nKey, headerTipI18nKey);
        this.weightPropertyName = weightPropertyName;
        this.sampleCategoryType = sampleCategoryType;
    }

    public void setWeightValue(R entry, Object value) {
        TuttiUIUtil.setProperty(entry, weightPropertyName, value);
    }

    public SampleCategoryEnum getSampleCategoryType() {
        return sampleCategoryType;
    }

    public String getWeightPropertyName() {
        return weightPropertyName;
    }
}
