/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.Set;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class BenthosBatchTableModel
extends AbstractTuttiTableModel<BenthosBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.editBenthosBatch.table.header.species", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.species.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> SORTED_UNSORTED_CATEGORY = SampleCategoryColumnIdentifier.newId("sortedUnsortedCategory", "sortedUnsortedCategoryWeight", SampleCategoryEnum.sortedUnsorted, I18n.n_((String)"tutti.editBenthosBatch.table.header.sortedUnsortedCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.sortedUnsortedCategory.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> SIZE_CATEGORY = SampleCategoryColumnIdentifier.newId("sizeCategory", "sizeCategoryWeight", SampleCategoryEnum.size, I18n.n_((String)"tutti.editBenthosBatch.table.header.sizeCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.sizeCategory.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> SEX_CATEGORY = SampleCategoryColumnIdentifier.newId("sexCategory", "sexCategoryWeight", SampleCategoryEnum.sex, I18n.n_((String)"tutti.editBenthosBatch.table.header.sexCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.sexCategory.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> MATURITY_CATEGORY = SampleCategoryColumnIdentifier.newId("maturityCategory", "maturityCategoryWeight", SampleCategoryEnum.maturity, I18n.n_((String)"tutti.editBenthosBatch.table.header.maturityCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.maturityCategory.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> AGE_CATEGORY = SampleCategoryColumnIdentifier.newId("ageCategory", "ageCategoryWeight", SampleCategoryEnum.age, I18n.n_((String)"tutti.editBenthosBatch.table.header.ageCategory", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.ageCategory.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId("computedOrNotWeight", I18n.n_((String)"tutti.editBenthosBatch.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.weight.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId("computedOrNotNumber", I18n.n_((String)"tutti.editBenthosBatch.table.header.computedNumber", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.computedNumber.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> COMMENT = ColumnIdentifier.newId("comment", I18n.n_((String)"tutti.editBenthosBatch.table.header.comment", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.comment.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId("attachment", I18n.n_((String)"tutti.editBenthosBatch.table.header.file", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.file.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId("speciesToConfirm", I18n.n_((String)"tutti.editBenthosBatch.table.header.toConfirm", (Object[])new Object[0]), I18n.n_((String)"tutti.editBenthosBatch.table.header.toConfirm.tip", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<BenthosBatchRowModel>> frequencyCols;
    protected final Set<ColumnIdentifier<BenthosBatchRowModel>> sampleCols;

    public BenthosBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.setNoneEditableCols(SPECIES);
        this.frequencyCols = Sets.newHashSet();
        this.frequencyCols.add(COMPUTED_NUMBER);
        this.frequencyCols.add(WEIGHT);
        this.sampleCols = Sets.newHashSet();
        this.sampleCols.add(SORTED_UNSORTED_CATEGORY);
        this.sampleCols.add(SIZE_CATEGORY);
        this.sampleCols.add(SEX_CATEGORY);
        this.sampleCols.add(MATURITY_CATEGORY);
        this.sampleCols.add(AGE_CATEGORY);
    }

    @Override
    public BenthosBatchRowModel createNewRow() {
        BenthosBatchRowModel result = new BenthosBatchRowModel();
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<BenthosBatchRowModel> propertyName, BenthosBatchRowModel entry) {
        if (this.sampleCols.contains(propertyName)) {
            ((SampleCategoryColumnIdentifier)propertyName).setWeightValue(entry, aValue);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }
    }

    public void updateSamplingRatio(Set<BenthosBatchRowModel> rows) {
    }

    @Override
    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<BenthosBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result) {
            if (this.frequencyCols.contains(propertyName)) {
                BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(rowIndex);
                result = entry.isValid() && entry.isBatchLeaf();
            } else if (this.sampleCols.contains(propertyName)) {
                SampleCategory value;
                SampleCategoryColumnIdentifier samplePropertyName = (SampleCategoryColumnIdentifier)propertyName;
                BenthosBatchRowModel entry = (BenthosBatchRowModel)this.getEntry(rowIndex);
                Species species = entry.getSpecies();
                result = species == null ? false : (value = (SampleCategory)propertyName.getValue(entry)).getCategoryValue() != null;
            }
        }
        return result;
    }
}

