/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SplitSpeciesBatchUIHandler
extends AbstractTuttiTableUIHandler<SplitSpeciesBatchRowModel, SplitSpeciesBatchUIModel, SplitSpeciesBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SplitSpeciesBatchUIHandler.class);
    private final SpeciesBatchUI parentUi;

    public SplitSpeciesBatchUIHandler(EditCatchesUI parentUi, SplitSpeciesBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui, "categoryValue", "weight");
        this.parentUi = parentUi.getSpeciesTabContent();
    }

    public SplitSpeciesBatchTableModel getTableModel() {
        return (SplitSpeciesBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SplitSpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SplitSpeciesBatchRowModel row) {
        return row.isValid();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SplitSpeciesBatchRowModel> rowMonitor, SplitSpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (row.isValid() && log.isInfoEnabled()) {
                log.info((Object)"Change row that was modified and valid");
            }
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onRowModified(int rowIndex, SplitSpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        if ("weight".equals(propertyName)) {
            this.computeSampleWeight(row);
        }
    }

    @Override
    public SwingValidator<SplitSpeciesBatchUIModel> getValidator() {
        return ((SplitSpeciesBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SplitSpeciesBatchUIModel model = new SplitSpeciesBatchUIModel();
        ((SplitSpeciesBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SplitSpeciesBatchUIModel model = (SplitSpeciesBatchUIModel)this.getModel();
        model.addPropertyChangeListener("category", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitSpeciesBatchUIModel source = (SplitSpeciesBatchUIModel)evt.getSource();
                source.setSelectedCategory(null);
                List data = (List)evt.getNewValue();
                ((SplitSpeciesBatchUI)SplitSpeciesBatchUIHandler.this.ui).getCategoryComboBox().setModel(new DefaultComboBoxModel<Object>(data.toArray()));
            }
        });
        model.addPropertyChangeListener("selectedCategory", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitSpeciesBatchUIModel source = (SplitSpeciesBatchUIModel)evt.getSource();
                source.setSampleWeight(null);
                SampleCategoryEnum newValue = (SampleCategoryEnum)evt.getNewValue();
                SplitSpeciesBatchUIHandler.this.generateTableModel(newValue);
            }
        });
        ((SplitSpeciesBatchUI)this.ui).getCategoryComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                ((SplitSpeciesBatchUIModel)SplitSpeciesBatchUIHandler.this.getModel()).setSelectedCategory((SampleCategoryEnum)comboBox.getSelectedItem());
            }
        });
        this.generateTableModel(null);
        this.initTable(this.getTable());
        this.listenValidatorValid((SimpleBeanValidator)((SplitSpeciesBatchUI)this.ui).getValidator(), model);
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((SplitSpeciesBatchUI)this.ui).getValidator().setBean(null);
        ((SplitSpeciesBatchUIModel)this.getModel()).setValid(false);
        ((SplitSpeciesBatchUIModel)this.getModel()).setSelectedCategory(null);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public String decorateSpecies(Species object) {
        String result = object == null ? "" : super.decorate(object);
        return result;
    }

    public void editBatch(SpeciesBatchRowModel batch) {
        ArrayList categories = Lists.newArrayList((Object[])SampleCategoryEnum.values());
        if (batch != null) {
            SampleCategory<?> lastCategory = batch.getSampleCategory();
            Preconditions.checkNotNull(lastCategory, (Object)"Can't split a species batch with no sample category.");
            if (batch.getSortedUnsortedCategory().isValid()) {
                categories.remove(SampleCategoryEnum.sortedUnsorted);
            }
            if (batch.getSizeCategory().isValid()) {
                categories.remove(SampleCategoryEnum.size);
            }
            if (batch.getSexCategory().isValid()) {
                categories.remove(SampleCategoryEnum.sex);
            }
            if (batch.getMaturityCategory().isValid()) {
                categories.remove(SampleCategoryEnum.maturity);
            }
            if (batch.getAgeCategory().isValid()) {
                categories.remove(SampleCategoryEnum.age);
            }
        }
        SplitSpeciesBatchUIModel model = (SplitSpeciesBatchUIModel)this.getModel();
        ((SplitSpeciesBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSampleWeight(null);
        model.setCategory(categories);
        model.setSelectedCategory((SampleCategoryEnum)categories.get(0));
        model.setBatch(batch);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        SplitSpeciesBatchUIModel model = (SplitSpeciesBatchUIModel)this.getModel();
        if (model.isValid()) {
            parent.getSpeciesTabContent().getHandler().splitBatch(model.getSelectedCategory(), model.getRows(), model.getSampleWeight());
        }
        this.closeUI(this.ui);
    }

    protected void computeSampleWeight(SplitSpeciesBatchRowModel row) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will recompute sample weight from row: " + row));
        }
        Float result = Float.valueOf(0.0f);
        List rows = this.getTableModel().getRows();
        for (SplitSpeciesBatchRowModel rowModel : rows) {
            Float weight = rowModel.getWeight();
            if (weight == null) continue;
            result = Float.valueOf(result.floatValue() + weight.floatValue());
        }
        ((SplitSpeciesBatchUIModel)this.getModel()).setSampleWeight(result);
    }

    protected void generateTableModel(SampleCategoryEnum category) {
        ((SplitSpeciesBatchUIModel)this.getModel()).setRows(null);
        Caracteristic data = null;
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.SELECTED, (JTable)this.getTable());
        boolean editableCategoryValue = false;
        if (category != null) {
            switch (category) {
                case sortedUnsorted: {
                    data = this.persistenceService.getSortedUnsortedCaracteristic();
                    break;
                }
                case size: {
                    data = this.persistenceService.getSizeCategoryCaracteristic();
                    break;
                }
                case sex: {
                    data = this.persistenceService.getSexCaracteristic();
                    break;
                }
                case maturity: {
                    data = this.persistenceService.getMaturityCaracteristic();
                    break;
                }
                case age: {
                    editableCategoryValue = true;
                    this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.EDITABLE_CATEGORY_VALUE, "\\d{0,6}|\\d{1,6}\\.\\d{0,1}");
                }
            }
            if (data != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got " + data.sizeQualitativeValue() + " qualitative data to add"));
                }
                this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class), SplitSpeciesBatchTableModel.READ_ONLY_CATEGORY_VALUE);
            }
            this.addFloatColumnToModel((TableColumnModel)columnModel, SplitSpeciesBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        }
        SplitSpeciesBatchTableModel tableModel = new SplitSpeciesBatchTableModel((TableColumnModelExt)columnModel, (SplitSpeciesBatchUIModel)this.getModel(), editableCategoryValue);
        JXTable table = this.getTable();
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.uninstallTableKeyListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Install new table model " + tableModel));
        }
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.installTableSaveOnRowChangedSelectionListener();
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        ArrayList rows = Lists.newArrayList();
        if (data != null) {
            for (CaracteristicQualitativeValue qualitativeValue : data.getQualitativeValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add QV: " + qualitativeValue));
                }
                SplitSpeciesBatchRowModel newRow = tableModel.createNewRow();
                newRow.setCategoryValue(qualitativeValue);
                rows.add(newRow);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will add " + rows.size() + " rows in table model " + "(can add a first empty row? " + editableCategoryValue + ")."));
        }
        ((SplitSpeciesBatchUIModel)this.getModel()).setRows(rows);
    }
}

