/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class MarineLitterBatchUIModel
extends AbstractTuttiBatchUIModel<MarineLitterBatchRowModel, MarineLitterBatchUIModel>
implements AttachmentModelAware,
TabContentModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_REMOVE_BATCH_ENABLED = "removeBatchEnabled";
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected boolean removeBatchEnabled;
    private String rootBatchId;

    public MarineLitterBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel, "marineLitterTotalWeight");
    }

    public Float getMarineLitterTotalWeight() {
        return this.catchesUIModel.getMarineLitterTotalWeight();
    }

    public void setMarineLitterTotalWeight(Float marineLitterTotalWeight) {
        this.catchesUIModel.setMarineLitterTotalWeight(marineLitterTotalWeight);
    }

    public boolean isRemoveBatchEnabled() {
        return this.removeBatchEnabled;
    }

    public void setRemoveBatchEnabled(boolean removeBatchEnabled) {
        Boolean oldValue = this.isRemoveBatchEnabled();
        this.removeBatchEnabled = removeBatchEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_BATCH_ENABLED, oldValue, removeBatchEnabled);
    }

    public void setRootBatchId(String rootBatchId) {
        String oldValue = this.getObjectId();
        this.rootBatchId = rootBatchId;
        this.firePropertyChange("objectId", oldValue, this.getObjectId());
    }

    public String getRootBatchId() {
        return this.rootBatchId;
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.CATCH_BATCH;
    }

    @Override
    public String getObjectId() {
        return this.rootBatchId;
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public boolean isEmpty() {
        boolean result;
        boolean bl = result = this.getMarineLitterTotalWeight() == null && CollectionUtils.isEmpty(this.getAttachment());
        if (result && CollectionUtils.isNotEmpty(this.getRows())) {
            for (MarineLitterBatchRowModel row : this.rows) {
                if (!row.isValid()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public String getTitle() {
        return "tutti.label.tab.marineLitter";
    }

    @Override
    public String getIcon() {
        return null;
    }
}

