/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataTableCell;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class BenthosBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<BenthosBatchRowModel, BenthosBatchUIModel, BenthosBatchUI> {
    private static final Log log = LogFactory.getLog(BenthosBatchUIHandler.class);
    public static final Set<String> SAMPLING_PROPERTIES = Sets.newHashSet((Object[])new String[]{"sampleCategory", "species", "sortedUnsortedCategory", "sizeCategory", "sexCategory", "maturityCategory", "ageCategory", "sortedUnsortedCategoryWeight", "sizeCategoryWeight", "sexCategoryWeight", "maturityCategoryWeight", "ageCategoryWeight"});
    private final EnumMap<TableViewMode, RowFilter<BenthosBatchTableModel, Integer>> tableFilters = new EnumMap(TableViewMode.class);

    public BenthosBatchUIHandler(TuttiUI<?, ?> parentUi, BenthosBatchUI ui) {
        super(parentUi, ui, "species", "sortedUnsortedCategory", "sortedUnsortedCategoryWeight", "sizeCategory", "sizeCategoryWeight", "sexCategory", "sexCategoryWeight", "maturityCategory", "maturityCategoryWeight", "ageCategory", "ageCategoryWeight", "weight", "number", "comment", "attachment", "frequency", "speciesToConfirm");
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<BenthosBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends BenthosBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<BenthosBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends BenthosBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    BenthosBatchTableModel model = entry.getModel();
                    BenthosBatchRowModel row = (BenthosBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<BenthosBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends BenthosBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    BenthosBatchTableModel model = entry.getModel();
                    BenthosBatchRowModel row = (BenthosBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            model.removeAllAttachment(model.getAttachment());
            if (!TuttiEntities.isNew(bean)) {
                BatchContainer rootBenthosBatch = this.persistenceService.getRootBenthosBatch(bean.getId());
                model.setRootBatchId(rootBenthosBatch.getId());
                List attachments = this.persistenceService.getAllAttachments(Integer.valueOf(model.getObjectId()));
                model.addAllAttachment(attachments);
                if (log.isInfoEnabled()) {
                    log.info((Object)("species root batch id: " + model.getRootBatchId()));
                }
                List catches = rootBenthosBatch.getChildren();
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((aBatch.getSampleCategoryType() == SampleCategoryEnum.sortedUnsorted ? 1 : 0) != 0, (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryType()));
                    BenthosBatchRowModel rootRow = this.loadBatch(aBatch, null, rows);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded root batch " + this.decorate(rootRow.getSpecies(), "fromProtocol") + " - " + this.decorate(rootRow.getSortedUnsortedCategoryValue())));
                }
            }
        }
        model.setRows(rows);
        this.recomputeBatchActionEnable();
    }

    public BenthosBatchTableModel getTableModel() {
        return (BenthosBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((BenthosBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(BenthosBatchRowModel row) {
        boolean result = row.getSpecies() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, BenthosBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        if (SAMPLING_PROPERTIES.contains(propertyName)) {
            this.recomputeRowValidState(row);
        }
        this.saveSelectedRowIfNeeded();
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<BenthosBatchRowModel> rowMonitor, BenthosBatchRowModel row) {
        if (row.isValid()) {
            if (rowMonitor.wasModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Row " + row + " was modified, will save it"));
                }
                this.showInformationMessage("[ Captures - Benthos ] Sauvegarde des modifications de " + row + '.');
                rowMonitor.setBean(null);
                this.saveRow(row);
                rowMonitor.setBean(row);
                rowMonitor.clearModified();
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Will not remove not valid speciesBatch: " + row.getId()));
        }
    }

    @Override
    protected void onModelRowsChanged(List<BenthosBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.setRootNumber(0);
        for (BenthosBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, BenthosBatchRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, BenthosBatchRowModel oldRow, int newRowIndex, BenthosBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter confirmHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BenthosBatchRowModel row = (BenthosBatchRowModel)BenthosBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.isSpeciesToConfirm();
            }
        }, toConfirmColor);
        table.addHighlighter(confirmHighlighter);
        Highlighter selectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.IS_SELECTED, new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{BenthosBatchTableModel.SPECIES})}), UIManager.getColor("Table[Enabled+Selected].textBackground"));
        table.addHighlighter(selectedHighlighter);
        Highlighter confirmNotEditableHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BenthosBatchRowModel row = (BenthosBatchRowModel)BenthosBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.isSpeciesToConfirm() && !adapter.isEditable();
            }
        }, toConfirmColor.darker());
        table.addHighlighter(confirmNotEditableHighlighter);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{BenthosBatchTableModel.COMMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{BenthosBatchTableModel.ATTACHMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }

    @Override
    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return ((BenthosBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((BenthosBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        BenthosBatchUIModel model = new BenthosBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        ((BenthosBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        Map<Integer, SampleCategoryEnum> categoryEnumMap = SampleCategoryEnum.toIdMapping();
        ArrayList samplingOrder = Lists.newArrayList();
        List<Integer> samplingOrderIds = this.getConfig().getSamplingOrderIds();
        for (Integer id : samplingOrderIds) {
            samplingOrder.add(categoryEnumMap.get(id));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use sampling order: " + samplingOrder));
        }
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class, "fromProtocol"), BenthosBatchTableModel.SPECIES);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SORTED_UNSORTED_CATEGORY, caracteristicDecorator, defaultRenderer);
        for (SampleCategoryEnum sampleCategoryType : samplingOrder) {
            switch (sampleCategoryType) {
                case size: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SIZE_CATEGORY, caracteristicDecorator, defaultRenderer);
                    break;
                }
                case sex: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SEX_CATEGORY, caracteristicDecorator, defaultRenderer);
                    break;
                }
                case maturity: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.MATURITY_CATEGORY, caracteristicDecorator, defaultRenderer);
                    break;
                }
                case age: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.AGE_CATEGORY, this.getDecorator(Float.class, null), defaultRenderer);
                }
            }
        }
        this.addColumnToModel((TableColumnModel)columnModel, TuttiComputedOrNotDataTableCell.newEditor(Float.class, false, true, 3, computedDataColor), TuttiComputedOrNotDataTableCell.newRender(defaultRenderer, true, 3, computedDataColor), BenthosBatchTableModel.WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, BenthosFrequencyCellComponent.newEditor((BenthosBatchUI)this.ui, computedDataColor), BenthosFrequencyCellComponent.newRender(computedDataColor), BenthosBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), BenthosBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), BenthosBatchTableModel.ATTACHMENT);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        BenthosBatchTableModel tableModel = new BenthosBatchTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
        ((BenthosBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableViewMode tableViewMode = (TableViewMode)((Object)evt.getNewValue());
                if (tableViewMode == null) {
                    tableViewMode = TableViewMode.ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
                }
                RowFilter filter = (RowFilter)BenthosBatchUIHandler.this.tableFilters.get((Object)tableViewMode);
                BenthosBatchUIHandler.this.getTable().setRowFilter(filter);
            }
        });
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
        ((BenthosBatchUI)this.ui).getBenthosBatchAttachmentsButton().onCloseUI();
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateBenthosBatchUI createBatchEditor = parent.getBenthosTabCreateBatch();
        createBatchEditor.getHandler().openUI((BenthosBatchUIModel)this.getModel());
        parent.getHandler().setBenthosSelectedCard("createBatch");
    }

    public void addBatch(CreateBenthosBatchUIModel speciesBatchRootRowModel) {
        if (speciesBatchRootRowModel.isValid()) {
            BenthosBatchTableModel tableModel = this.getTableModel();
            BenthosBatchRowModel newRow = tableModel.createNewRow();
            Species species = speciesBatchRootRowModel.getSpecies();
            newRow.setSpecies(species);
            CaracteristicQualitativeValue sortedUnsortedCategory = speciesBatchRootRowModel.getSortedUnsortedCategory();
            SampleCategory<CaracteristicQualitativeValue> category = newRow.getSortedUnsortedCategory();
            category.setCategoryValue(sortedUnsortedCategory);
            category.setCategoryWeight(speciesBatchRootRowModel.getBatchWeight());
            newRow.setSampleCategory(category);
            this.recomputeRowValidState(newRow);
            tableModel.addNewRow(newRow);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), tableModel.getRowCount() - 1, 0);
            this.saveRow(newRow);
            this.addToSpeciesUsed(newRow);
        }
        this.recomputeBatchActionEnable();
    }

    public void splitBatch() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        BenthosBatchTableModel tableModel = this.getTableModel();
        BenthosBatchRowModel parentBatch = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
        boolean split = true;
        if (parentBatch.getWeight() != null) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editBenthosBatch.split.weightNotNull.message", (Object[])new Object[0]), I18n._((String)"tutti.editBenthosBatch.split.weightNotNull.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.editBenthosBatch.split.weightNotNull.title", (Object[])new Object[0]), 2);
            if (i == 0) {
                parentBatch.setWeight(null);
            } else {
                split = false;
            }
        }
        if (split) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Open split batch ui for row [" + rowIndex + ']'));
            }
            EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
            SplitBenthosBatchUI splitBatchEditor = parent.getBenthosTabSplitBatch();
            splitBatchEditor.getHandler().editBatch(parentBatch);
            parent.getHandler().setBenthosSelectedCard("splitBatch");
        }
    }

    public void splitBatch(SplitBenthosBatchUIModel splitModel) {
        if (splitModel.isValid()) {
            JXTable table = this.getTable();
            int insertRow = table.getSelectedRow();
            BenthosBatchTableModel tableModel = this.getTableModel();
            BenthosBatchRowModel parentBatch = (BenthosBatchRowModel)tableModel.getEntry(insertRow);
            SampleCategoryEnum sampleCategoryEnum = splitModel.getSelectedCategory();
            ArrayList newBatches = Lists.newArrayList();
            for (SplitBenthosBatchRowModel row : splitModel.getRows()) {
                if (!row.isValid()) continue;
                BenthosBatchRowModel newBatch = tableModel.createNewRow();
                this.loadBatchRow(parentBatch, newBatch, sampleCategoryEnum, row.getCategoryValue(), row.getWeight());
                this.recomputeRowValidState(newBatch);
                newBatches.add(newBatch);
                tableModel.addNewRow(++insertRow, newBatch);
            }
            parentBatch.setChildBatch(newBatches);
            this.saveRows(newBatches);
            BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
            model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        }
        this.recomputeBatchActionEnable();
    }

    public void updateTotalFromFrequencies(BenthosBatchRowModel row) {
        List<BenthosFrequencyRowModel> frequency = row.getFrequency();
        Integer totalNumber = 0;
        boolean onlyOneFrequency = false;
        if (CollectionUtils.isNotEmpty(frequency)) {
            for (BenthosFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            onlyOneFrequency = frequency.size() == 1;
        }
        row.setComputedNumber(totalNumber);
        row.getFinestCategory().setOnlyOneFrequency(onlyOneFrequency);
    }

    public void saveRows(Iterable<BenthosBatchRowModel> rows) {
        for (BenthosBatchRowModel row : rows) {
            this.saveRow(row);
        }
    }

    protected void saveRow(BenthosBatchRowModel row) {
        FishingOperation fishingOperation = ((BenthosBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> sampleCategory = row.getSampleCategory();
        Preconditions.checkNotNull(sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryType());
        Preconditions.checkNotNull(sampleCategory.getCategoryValue());
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        catchBean.setFishingOperation(fishingOperation);
        BenthosBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            catchBean.setParentBatch((SpeciesBatch)parent.toBean());
        }
        catchBean.setSampleCategoryType(sampleCategory.getCategoryType());
        catchBean.setSampleCategoryValue((Serializable)sampleCategory.getCategoryValue());
        catchBean.setSampleCategoryWeight(sampleCategory.getCategoryWeight());
        if (TuttiEntities.isNew(catchBean)) {
            BenthosBatchRowModel batchParent = row.getParentBatch();
            String parentBatchId = null;
            if (batchParent != null) {
                parentBatchId = batchParent.getId();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.persistenceService.createBenthosBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist existing species batch: " + catchBean.getId() + " (parent : " + catchBean.getParentBatch() + ")"));
            }
            this.persistenceService.saveBenthosBatch(catchBean);
        }
        List<BenthosFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = BenthosFrequencyRowModel.toBeans(frequencyRows, catchBean);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.persistenceService.saveBenthosBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = BenthosFrequencyRowModel.fromBeans(frequency);
        row.setFrequency(frequencyRows);
    }

    public String getFilterBenthosBatchRootButtonText(int rootNumber) {
        return I18n._((String)"tutti.editBenthosBatch.filterBatch.mode.root", (Object[])new Object[]{rootNumber});
    }

    protected void recomputeBatchActionEnable() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableAdd = true;
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        if (rowIndex != -1) {
            BenthosBatchTableModel tableModel = this.getTableModel();
            BenthosBatchRowModel row = (BenthosBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            if (row.isValid()) {
                enableSplit = true;
                enableRemove = true;
                enableRemoveSub = true;
                enableRename = true;
                enableCreateMelag = true;
            }
            if (enableSplit) {
                boolean bl = enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && row.getNumber() == null && (row.getComputedNumber() == null || row.getComputedNumber() == 0);
            }
            if (enableRename) {
                boolean bl = enableRename = row.isBatchRoot() && selectedRowCount == 1;
            }
            if (enableRemove) {
                boolean bl = enableRemove = selectedRowCount == 1;
            }
            if (enableRemoveSub) {
                boolean bl = enableRemoveSub = !row.isBatchLeaf() && selectedRowCount == 1;
            }
            if (enableCreateMelag) {
                JXTable table = this.getTable();
                if (selectedRowCount < 2) {
                    enableCreateMelag = false;
                } else {
                    int[] selectedRows;
                    for (int selectedRowIndex : selectedRows = table.getSelectedRows()) {
                        BenthosBatchRowModel selectedRow = (BenthosBatchRowModel)tableModel.getEntry(selectedRowIndex);
                        if (selectedRow.isBatchRoot()) continue;
                        enableCreateMelag = false;
                        break;
                    }
                }
            }
        }
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.setCreateBatchEnabled(enableAdd);
        model.setSplitBatchEnabled(enableSplit);
        model.setRemoveBatchEnabled(enableRemove);
        model.setRemoveSubBatchEnabled(enableRemoveSub);
        model.setRenameBatchEnabled(enableRename);
        model.setCreateMelagEnabled(enableCreateMelag);
    }

    public void collectChildren(BenthosBatchRowModel row, Set<BenthosBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (BenthosBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChildren(batchChild, collectedRows);
            }
        }
    }

    public BenthosBatchRowModel loadBatch(SpeciesBatch aBatch, BenthosBatchRowModel parentRow, List<BenthosBatchRowModel> rows) {
        List speciesList;
        int i;
        String id = aBatch.getId();
        List frequencies = this.persistenceService.getAllBenthosBatchFrequency(id);
        List attachments = this.persistenceService.getAllAttachments(Integer.valueOf(id));
        BenthosBatchRowModel newRow = new BenthosBatchRowModel(aBatch, frequencies, attachments);
        if (parentRow == null && this.context.isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentBenthosWithSurveyCode()).indexOf(newRow.getSpecies())) > -1) {
            newRow.setSpecies((Species)speciesList.get(i));
        }
        SampleCategoryEnum sampleCategoryEnum = aBatch.getSampleCategoryType();
        Preconditions.checkNotNull((Object)sampleCategoryEnum, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryEnum, aBatch.getSampleCategoryValue(), aBatch.getSampleCategoryWeight());
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                BenthosBatchRowModel childRow = this.loadBatch(childBatch, newRow, rows);
                batchChilds.add(childRow);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    protected void loadBatchRow(BenthosBatchRowModel parentRow, BenthosBatchRowModel newRow, SampleCategoryEnum sampleCategoryEnum, Serializable categoryValue, Float categoryWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategory(sampleCategoryEnum);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            newRow.setSpeciesToConfirm(parentRow.isSpeciesToConfirm());
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            if (sampleCategoryEnum != SampleCategoryEnum.sortedUnsorted) {
                newRow.setSortedUnsortedCategory(parentRow.getSortedUnsortedCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.size) {
                newRow.setSizeCategory(parentRow.getSizeCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.sex) {
                newRow.setSexCategory(parentRow.getSexCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.maturity) {
                newRow.setMaturityCategory(parentRow.getMaturityCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.age) {
                newRow.setAgeCategory(parentRow.getAgeCategory());
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<BenthosBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights()), columnIdentifier);
    }

    public void removeFromSpeciesUsed(BenthosBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getSortedUnsortedCategoryValue());
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from speciesUsed: " + this.decorate(row.getSortedUnsortedCategoryValue()) + " - " + this.decorate(row.getSpecies())));
        }
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)row.getSortedUnsortedCategoryValue(), (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
        }
    }

    protected void addToSpeciesUsed(BenthosBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getSortedUnsortedCategoryValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate(row.getSortedUnsortedCategoryValue()) + " - " + this.decorate(row.getSpecies())));
        }
        BenthosBatchUIModel model = (BenthosBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)row.getSortedUnsortedCategoryValue(), (Object)row.getSpecies());
        model.setRootNumber(model.getRootNumber() + 1);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }
}

