package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: AddBenthosProtocolAction.java 678 2013-03-25 17:44:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/AddBenthosProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;

import java.util.Collection;

import static org.nuiton.i18n.I18n._;

/**
 * To add a new benthos protocol.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class AddBenthosProtocolAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    public AddBenthosProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    protected Species species;

    @Override
    protected void doAction() throws Exception {

        species = null;

        EditProtocolUI ui = getUI();

        EditProtocolSpeciesTableModel tableModel = handler.getBenthosTableModel();
        BeanFilterableComboBox<Species> benthosComboBox = ui.getBenthosComboBox();

        species = (Species) benthosComboBox.getSelectedItem();
        Preconditions.checkNotNull(
                species, "Can't add a benthosProtocol with a null species");
        Preconditions.checkArgument(species.isReferenceTaxon(),
                                    "Can't add a benthosProtocol with a not referent species");

        Integer taxonId = species.getReferenceTaxonId();
        String taxonIdStr = String.valueOf(taxonId);

        // remove all synonyms of this taxon
        Collection<Species> allSynonyms = getModel().getAllSynonyms(taxonIdStr);
        getModel().getAllSynonyms().removeAll(allSynonyms);

        benthosComboBox.removeItem(species);
        ui.getSpeciesComboBox().removeItem(species);

        // add new row to model (do it after combo stuff for ui best display)
        EditProtocolSpeciesRowModel protocol = tableModel.createNewRow();
        protocol.setSpecies(species);
        tableModel.addNewRow(protocol);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        String speciesStr = decorate(species);
        sendMessage(_("tutti.flash.info.benthos.add.to.protocol",
                      speciesStr));
    }
}
