/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportTemporarySpeciesExampleAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ExportTemporarySpeciesExampleAction.class);
    private File file;

    public ExportTemporarySpeciesExampleAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.manageTemporaryReferential.title.choose.exportTemporarySpeciesExampleFile", (Object[])new Object[0]), I18n._((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile", (Object[])new Object[0]), "^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing((File)this.file, (String)".csv");
                doAction = ((ManageTemporaryReferentialUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export example species temporary referential to file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getContext().getTuttiReferentialImportExportService();
        service.exportTemporarySpeciesExample(this.file);
        this.sendMessage("Exemple de r\u00e9f\u00e9rentiel temporaire d'esp\u00e8ces export\u00e9 dans le fichier " + this.file + ".");
    }
}

