/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea2RegulationLocation;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea2RegulationLocationPK;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.GearUseMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.VesselUseMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociation;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociationDao;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociationPK;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruiseDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeaturesExtendDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.isActive;
import fr.ifremer.adagio.core.dao.data.vessel.position.VesselPosition;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselImpl;
import fr.ifremer.adagio.core.service.referential.location.LocationService;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.type.IntegerType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="fishingOperationPersistenceService")
public class FishingOperationPersistenceServiceImpl
extends AbstractPersistenceService
implements FishingOperationPersistenceService {
    private static final Log log = LogFactory.getLog(FishingOperationPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Resource(name="scientificCruiseDao")
    protected ScientificCruiseDao scientificCruiseDao;
    @Resource(name="gearPhysicalFeaturesDao")
    protected GearPhysicalFeaturesExtendDao gearPhysicalFeaturesDao;
    @Resource(name="fishingOperationDao")
    protected FishingOperationDao fishingOperationDao;
    @Resource(name="operationVesselAssociationDao")
    protected OperationVesselAssociationDao operationVesselAssociationDao;
    @Resource(name="locationService")
    protected LocationService locationService;
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;
    protected static Float DEFAULT_EMPTY_LATITUDE = Float.valueOf(1.0E-4f);
    protected static Float DEFAULT_EMPTY_LONGITUDE = Float.valueOf(1.0E-4f);
    protected static String MISC_DATA_RECORDER_PERSONS_TAG = "#REC_PERSONS=";

    @Override
    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId);
        Iterator<Object[]> list = this.queryList("allFishingOperations", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(cruiseId), "pmfmIdStationNumber", IntegerType.INSTANCE, this.enumeration.PMFM_ID_STATION_NUMBER, "pmfmIdMultirigAggregation", IntegerType.INSTANCE, this.enumeration.PMFM_ID_MULTIRIG_AGGREGATION);
        ArrayList<FishingOperation> result = new ArrayList<FishingOperation>();
        int fishingOperationRankOrder = 0;
        while (list.hasNext()) {
            String multirigAggregation;
            String fishingOperationNumberStr;
            Object[] source = list.next();
            ++fishingOperationRankOrder;
            FishingOperation fishingOperation = new FishingOperation();
            int colIndex = 0;
            fishingOperation.setId(source[colIndex++].toString());
            String name = (String)source[colIndex++];
            String gearLabel = (String)source[colIndex++];
            if (name != null && !name.isEmpty() && (fishingOperationNumberStr = gearLabel != null && !gearLabel.isEmpty() && name.startsWith(gearLabel) ? name.substring(gearLabel.length()) : name).matches("\\d+")) {
                fishingOperation.setFishingOperationNumber(Integer.valueOf(fishingOperationNumberStr));
            }
            if (fishingOperation.getFishingOperationNumber() == null) {
                fishingOperation.setFishingOperationNumber(fishingOperationRankOrder);
            }
            Timestamp startDateTime = (Timestamp)source[colIndex++];
            fishingOperation.setGearShootingStartDate(this.convertDatabase2UI(startDateTime));
            String stationNumber = (String)source[colIndex++];
            if (stationNumber != null) {
                fishingOperation.setStationNumber(stationNumber);
            }
            if ((multirigAggregation = (String)source[colIndex]) != null) {
                fishingOperation.setMultirigAggregation(multirigAggregation);
            } else {
                log.warn((Object)MessageFormat.format("FishingOperation with id={0} has been load with a default multirigAggregation={1}, because no multirigAggregation were found in database.", fishingOperation.getId(), fishingOperation.getMultirigAggregation()));
                fishingOperation.setMultirigAggregation("1");
            }
            result.add(fishingOperation);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public FishingOperation getFishingOperation(String id) {
        String vesselCode;
        Integer localiteId;
        Integer subStrataId;
        VesselPosition startVesselPosition;
        Integer gearId;
        int recorderPersonsIndex;
        String fishingOperationNumberStr;
        Preconditions.checkNotNull((Object)id);
        Object[] source = this.queryUnique("fishingOperation", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(id), "locationLevelIdStrata", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_STRATA, "locationLevelIdSubStrata", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_SUB_STRATA, "locationLevelIdLocalite", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_LOCALITE);
        if (source == null) {
            throw new DataRetrievalFailureException("Could not retrieve fishingOperation with id=" + id);
        }
        FishingOperation result = new FishingOperation();
        result.setId(id);
        int colIndex = 0;
        String name = (String)source[colIndex++];
        String gearLabel = (String)source[colIndex++];
        if (name != null && !name.isEmpty() && (fishingOperationNumberStr = gearLabel != null && !gearLabel.isEmpty() && name.startsWith(gearLabel) ? name.substring(gearLabel.length()) : name).matches("\\d+")) {
            result.setFishingOperationNumber(Integer.valueOf(fishingOperationNumberStr));
        }
        if (result.getFishingOperationNumber() == null) {
            Integer fishingOperationRankOrder = (Integer)this.queryUniqueTyped("fishingOperationRankOrder", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(id));
            result.setFishingOperationNumber(fishingOperationRankOrder);
        }
        result.setGearShootingStartDate(this.convertDatabase2UI((Timestamp)source[colIndex++]));
        result.setGearShootingEndDate(this.convertDatabase2UI((Timestamp)source[colIndex++]));
        String miscData = (String)source[colIndex++];
        if (miscData != null && !miscData.isEmpty() && (recorderPersonsIndex = miscData.indexOf(MISC_DATA_RECORDER_PERSONS_TAG)) != -1) {
            String recorderPersonsStr = miscData.substring(recorderPersonsIndex + MISC_DATA_RECORDER_PERSONS_TAG.length()).trim();
            miscData = miscData.substring(0, recorderPersonsIndex);
            if (!recorderPersonsStr.isEmpty()) {
                String[] recorderPersonsArray = recorderPersonsStr.split(",");
                ArrayList persons = Lists.newArrayList();
                for (String personId : recorderPersonsArray) {
                    Person person = this.referentialService.getPerson(Integer.valueOf(personId));
                    persons.add(person);
                }
                result.setRecorderPerson(persons);
            }
        }
        if (miscData != null && !miscData.isEmpty()) {
            result.setComment(miscData);
        }
        if ((gearId = (Integer)source[colIndex++]) != null) {
            fr.ifremer.tutti.persistence.entities.referential.Gear gear = this.referentialService.getGear(gearId);
            result.setGear(gear);
        }
        if ((startVesselPosition = (VesselPosition)source[colIndex++]) == null) {
            result.setGearShootingStartLatitude(null);
            result.setGearShootingStartLongitude(null);
        } else {
            result.setGearShootingStartLatitude(this.convertLatitude2UI(startVesselPosition.getLatitude()));
            result.setGearShootingStartLongitude(this.convertLongitude2UI(startVesselPosition.getLongitude()));
        }
        VesselPosition endVesselPosition = (VesselPosition)source[colIndex++];
        if (endVesselPosition == null) {
            result.setGearShootingEndLatitude(null);
            result.setGearShootingEndLongitude(null);
        } else {
            result.setGearShootingEndLatitude(DEFAULT_EMPTY_LATITUDE.equals(endVesselPosition.getLatitude()) ? null : endVesselPosition.getLatitude());
            result.setGearShootingEndLongitude(DEFAULT_EMPTY_LONGITUDE.equals(endVesselPosition.getLongitude()) ? null : endVesselPosition.getLongitude());
        }
        Integer strataId = (Integer)source[colIndex++];
        if (strataId != null) {
            TuttiLocation strata = this.referentialService.getLocation(strataId.toString());
            result.setStrata(strata);
        }
        if ((subStrataId = (Integer)source[colIndex++]) != null) {
            TuttiLocation subStrata = this.referentialService.getLocation(subStrataId.toString());
            result.setSubStrata(subStrata);
        }
        if ((localiteId = (Integer)source[colIndex++]) != null) {
            TuttiLocation localite = this.referentialService.getLocation(localiteId.toString());
            result.setLocation(localite);
        }
        if ((vesselCode = (String)source[colIndex]) != null) {
            Vessel vessel = this.referentialService.getVessel(vesselCode);
            result.setVessel(vessel);
        }
        this.getGearUseCaracteristics(id, result);
        this.getVesselUseCaracteristics(id, result);
        return result;
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getCruise());
        Preconditions.checkNotNull((Object)bean.getCruise().getId());
        if (bean.getGearShootingStartDate() != null && bean.getGearShootingEndDate() != null) {
            Preconditions.checkArgument((!bean.getGearShootingStartDate().equals(bean.getGearShootingEndDate()) ? 1 : 0) != 0);
        }
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation = FishingOperation.Factory.newInstance();
        this.beanToEntity(bean, fishingOperation);
        this.fishingOperationDao.create(fishingOperation);
        bean.setId(String.valueOf(fishingOperation.getId()));
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Preconditions.checkNotNull((Object)bean.getCruise());
        Preconditions.checkNotNull((Object)bean.getCruise().getId());
        if (bean.getGearShootingStartDate() != null && bean.getGearShootingEndDate() != null) {
            Preconditions.checkArgument((!bean.getGearShootingStartDate().equals(bean.getGearShootingEndDate()) ? 1 : 0) != 0);
        }
        this.getCurrentSession().clear();
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation = this.fishingOperationDao.load(Integer.valueOf(bean.getId()));
        if (fishingOperation == null) {
            throw new DataRetrievalFailureException("Could not retrieve fishing operation with id=" + bean.getId());
        }
        this.beanToEntity(bean, fishingOperation);
        this.fishingOperationDao.update(fishingOperation);
        this.getCurrentSession().flush();
        return bean;
    }

    protected void getVesselUseCaracteristics(String fishingOperationId, FishingOperation result) {
        Iterator<Object[]> list = this.queryList("fishingOperationVesselUseFeatures", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(fishingOperationId));
        CaracteristicMap vesselUseCaracteristics = new CaracteristicMap();
        while (list.hasNext()) {
            int colIndex = 0;
            Object[] source = list.next();
            Integer pmfmId = (Integer)source[colIndex++];
            Float numericalValue = (Float)source[colIndex++];
            String alphanumericalValue = (String)source[colIndex++];
            Integer qualitativeValueId = (Integer)source[colIndex++];
            if (this.enumeration.PMFM_ID_TRAWL_DISTANCE.equals(pmfmId)) {
                result.setTrawlDistance(numericalValue);
                continue;
            }
            if (this.enumeration.PMFM_ID_RECTILINEAR_OPERATION.equals(pmfmId)) {
                result.setFishingOperationRectiligne(this.enumeration.QUALITATIVE_RECTILINEAR_OPERATION_YES.equals(qualitativeValueId));
                continue;
            }
            if (this.enumeration.PMFM_ID_HAUL_VALID.equals(pmfmId)) {
                if (qualitativeValueId != null) {
                    result.setFishingOperationValid(this.enumeration.QUALITATIVE_HAUL_VALID_YES.equals(qualitativeValueId));
                    continue;
                }
                result.setFishingOperationValid(null);
                continue;
            }
            if (this.enumeration.PMFM_ID_STATION_NUMBER.equals(pmfmId)) {
                result.setStationNumber(alphanumericalValue);
                continue;
            }
            Caracteristic environmentCaracteristic = this.referentialService.getCaracteristic(pmfmId);
            Object value = null;
            if (environmentCaracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
                value = numericalValue;
            } else if (environmentCaracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
                value = alphanumericalValue;
            } else if (environmentCaracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
                for (CaracteristicQualitativeValue qv : environmentCaracteristic.getQualitativeValue()) {
                    if (qualitativeValueId != Integer.parseInt(qv.getId())) continue;
                    value = qv;
                    break;
                }
            }
            vesselUseCaracteristics.put(environmentCaracteristic, value);
        }
        if (vesselUseCaracteristics.size() > 0) {
            result.setVesselUseFeatures(vesselUseCaracteristics);
        }
    }

    protected void getGearUseCaracteristics(String fishingOperationId, FishingOperation result) {
        Iterator<Object[]> list = this.queryList("fishingOperationGearUseFeatures", "fishingOperationId", IntegerType.INSTANCE, Integer.valueOf(fishingOperationId));
        CaracteristicMap gearShootingCaracteristics = new CaracteristicMap();
        while (list.hasNext()) {
            int colIndex = 0;
            Object[] source = list.next();
            Integer pmfmId = (Integer)source[colIndex++];
            Float numericalValue = (Float)source[colIndex++];
            String alphanumericalValue = (String)source[colIndex++];
            Integer qualitativeValueId = (Integer)source[colIndex++];
            if (this.enumeration.PMFM_ID_MULTIRIG_AGGREGATION.equals(pmfmId) && alphanumericalValue != null && alphanumericalValue.matches("\\d+")) {
                result.setMultirigAggregation(alphanumericalValue);
                continue;
            }
            Caracteristic gearShootingCaracteristic = this.referentialService.getCaracteristic(pmfmId);
            Object value = null;
            if (gearShootingCaracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
                value = numericalValue;
            } else if (gearShootingCaracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
                value = alphanumericalValue;
            } else if (gearShootingCaracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
                for (CaracteristicQualitativeValue qv : gearShootingCaracteristic.getQualitativeValue()) {
                    if (qualitativeValueId != Integer.parseInt(qv.getId())) continue;
                    value = qv;
                    break;
                }
            }
            gearShootingCaracteristics.put(gearShootingCaracteristic, value);
        }
        if (gearShootingCaracteristics.size() > 0) {
            result.setGearUseFeatures(gearShootingCaracteristics);
        }
    }

    protected void beanToEntity(FishingOperation source, fr.ifremer.adagio.core.dao.data.operation.FishingOperation target) {
        FishingArea2RegulationLocationPK fa2rlPK;
        FishingArea2RegulationLocation fa2rl;
        Date d;
        VesselUseMeasurement vum;
        GearPhysicalMeasurement gpmMultirigCount;
        ArrayList notChangedRegulationLocation;
        FishingArea fishingArea;
        GearPhysicalFeatures gearPhysicalFeatures;
        VesselUseFeatures vesselUseFeatures;
        GearUseFeatures gearUseFeatures;
        ScientificCruise scientificCruise;
        StringBuilder nameBuffer = new StringBuilder();
        FishingTrip fishingTrip = target.getFishingTrip();
        if (fishingTrip == null) {
            scientificCruise = this.scientificCruiseDao.load(Integer.valueOf(source.getCruise().getId()));
            fishingTrip = (FishingTrip)scientificCruise.getFishingTrips().iterator().next();
            fishingTrip.getOperations().add(target);
        } else {
            scientificCruise = fishingTrip.getScientificCruise();
        }
        target.setFishingTrip(fishingTrip);
        VesselPosition startPosition = null;
        VesselPosition endPosition = null;
        if (target.getVesselPositions() != null) {
            for (VesselPosition position : target.getVesselPositions()) {
                if (position.getDateTime() != null && position.getDateTime().getTime() == target.getStartDateTime().getTime()) {
                    startPosition = position;
                    continue;
                }
                if (position.getDateTime() != null && (target.getEndDateTime() == null || position.getDateTime().getTime() != target.getEndDateTime().getTime())) continue;
                endPosition = position;
            }
        }
        if (CollectionUtils.isEmpty((Collection)target.getGearUseFeatures())) {
            gearUseFeatures = GearUseFeatures.Factory.newInstance();
            gearUseFeatures.setOperation((Operation)target);
            if (target.getGearUseFeatures() == null) {
                target.setGearUseFeatures((Collection)Sets.newHashSet((Object[])new GearUseFeatures[]{gearUseFeatures}));
            } else {
                target.getGearUseFeatures().add(gearUseFeatures);
            }
        } else {
            gearUseFeatures = (GearUseFeatures)target.getGearUseFeatures().iterator().next();
        }
        HashSet notChangedGearUseMeasurements = new HashSet();
        if (gearUseFeatures.getGearUseMeasurements() != null) {
            notChangedGearUseMeasurements.addAll(gearUseFeatures.getGearUseMeasurements());
        }
        if (CollectionUtils.isEmpty((Collection)target.getVesselUseFeatures())) {
            vesselUseFeatures = VesselUseFeatures.Factory.newInstance();
            if (target.getVesselUseFeatures() == null) {
                target.setVesselUseFeatures((Collection)Sets.newHashSet((Object[])new VesselUseFeatures[]{vesselUseFeatures}));
                vesselUseFeatures.setOperation((Operation)target);
            } else {
                target.getVesselUseFeatures().add(vesselUseFeatures);
                vesselUseFeatures.setOperation((Operation)target);
            }
        } else {
            vesselUseFeatures = (VesselUseFeatures)target.getVesselUseFeatures().iterator().next();
        }
        HashSet notChangedVesselUseMeasurements = new HashSet();
        if (vesselUseFeatures.getVesselUseMeasurements() != null) {
            notChangedVesselUseMeasurements.addAll(vesselUseFeatures.getVesselUseMeasurements());
        }
        if ((gearPhysicalFeatures = target.getGearPhysicalFeatures()) == null && source.getGear() != null && source.getGear().getId() != null) {
            gearPhysicalFeatures = this.gearPhysicalFeaturesDao.getGearPhysicalfeatures(fishingTrip, Integer.valueOf(source.getGear().getId()));
            if (gearPhysicalFeatures == null) {
                throw new DataIntegrityViolationException("An operation could not use a gear that is not declared in the cruise.");
            }
            target.setGearPhysicalFeatures(gearPhysicalFeatures);
            if (gearPhysicalFeatures.getOperations() == null) {
                gearPhysicalFeatures.setOperations((Collection)Sets.newHashSet((Object[])new Operation[]{target}));
            } else {
                gearPhysicalFeatures.getOperations().add(target);
            }
        }
        if (source.getGear() != null && source.getGear().getLabel() != null) {
            nameBuffer.append(source.getGear().getLabel());
        }
        if (CollectionUtils.isEmpty((Collection)gearUseFeatures.getFishingAreas())) {
            fishingArea = FishingArea.Factory.newInstance();
            if (gearUseFeatures.getFishingAreas() == null) {
                gearUseFeatures.setFishingAreas((Collection)Sets.newHashSet((Object[])new FishingArea[]{fishingArea}));
                fishingArea.setGearUseFeatures(gearUseFeatures);
            } else {
                gearUseFeatures.getFishingAreas().add(fishingArea);
                fishingArea.setGearUseFeatures(gearUseFeatures);
            }
            notChangedRegulationLocation = Lists.newArrayList();
        } else {
            fishingArea = (FishingArea)gearUseFeatures.getFishingAreas().iterator().next();
            notChangedRegulationLocation = Lists.newArrayList((Iterable)fishingArea.getRegulationLocation());
        }
        int cruiseMultirigCount = 1;
        if (gearPhysicalFeatures != null && (gpmMultirigCount = this.gearPhysicalFeaturesDao.getGearPhysicalMeasurement(gearPhysicalFeatures, this.enumeration.PMFM_ID_MULTIRIG_NUMBER)) != null && gpmMultirigCount.getNumericalValue() != null) {
            cruiseMultirigCount = gpmMultirigCount.getNumericalValue().intValue();
        }
        if (source.getStationNumber() != null && source.getStationNumber() != null) {
            vum = this.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, this.enumeration.PMFM_ID_STATION_NUMBER, null, source.getStationNumber(), null);
            notChangedVesselUseMeasurements.remove(vum);
        }
        if (source.getFishingOperationNumber() != null && source.getFishingOperationNumber() != null) {
            nameBuffer.append(source.getFishingOperationNumber());
        }
        target.setName(nameBuffer.toString());
        if (source.getMultirigAggregation() != null && source.getMultirigAggregation() != null) {
            int mutlirigNumber;
            if (source.getMultirigAggregation().matches("\\d+") && (mutlirigNumber = Integer.valueOf(source.getMultirigAggregation()).intValue()) > cruiseMultirigCount) {
                throw new DataIntegrityViolationException("An operation could not have a 'multirig number' greater than 'multirig count' defined in the cruise.");
            }
            GearUseMeasurement gum = this.setGearUseMeasurement(scientificCruise, gearUseFeatures, this.enumeration.PMFM_ID_MULTIRIG_AGGREGATION, null, source.getMultirigAggregation(), null);
            notChangedGearUseMeasurements.remove(gum);
        }
        if (source.getGearShootingStartDate() == null) {
            target.setStartDateTime(null);
            target.setFishingStartDateTime(null);
        } else if (source.getGearShootingStartDate() != null) {
            d = this.dateWithNoMiliSecond(source.getGearShootingStartDate());
            target.setStartDateTime(d);
            target.setFishingStartDateTime(d);
        }
        if (source.getGearShootingEndDate() == null) {
            target.setEndDateTime(null);
            target.setFishingEndDateTime(null);
        } else if (source.getGearShootingEndDate() != null) {
            d = this.dateWithNoMiliSecond(source.getGearShootingEndDate());
            target.setEndDateTime(d);
            target.setFishingEndDateTime(d);
        }
        if (source.getTrawlDistance() != null && source.getTrawlDistance() != null) {
            vum = this.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, this.enumeration.PMFM_ID_TRAWL_DISTANCE, source.getTrawlDistance(), null, null);
            notChangedVesselUseMeasurements.remove(vum);
        }
        vum = this.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, this.enumeration.PMFM_ID_RECTILINEAR_OPERATION, null, null, source.isFishingOperationRectiligne() ? this.enumeration.QUALITATIVE_RECTILINEAR_OPERATION_YES : this.enumeration.QUALITATIVE_RECTILINEAR_OPERATION_NO);
        notChangedVesselUseMeasurements.remove(vum);
        if (source.getFishingOperationValid() != null && source.getFishingOperationValid() != null) {
            vum = this.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, this.enumeration.PMFM_ID_HAUL_VALID, null, null, source.getFishingOperationValid() != false ? this.enumeration.QUALITATIVE_HAUL_VALID_YES : this.enumeration.QUALITATIVE_HAUL_VALID_NO);
            notChangedVesselUseMeasurements.remove(vum);
        }
        target.setVessel(fishingTrip.getVessel());
        if (source.getVessel() == null && target.getOperationVesselAssociations() != null) {
            target.getOperationVesselAssociations().clear();
        } else if (source.getVessel() != null && source.getVessel().getId() != null) {
            this.setOperationVesselAssociation((Operation)target, source.getVessel().getId());
        }
        if (target.getQualityFlag() == null) {
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        }
        if (target.getStartDateTime() == null) {
            d = this.dateWithNoSecondAndOneMiliSecond(scientificCruise.getDepartureDateTime());
            target.setStartDateTime(d);
            target.setFishingStartDateTime(d);
        }
        vesselUseFeatures.setStartDate(target.getStartDateTime());
        if (vesselUseFeatures.getStartDate() == null) {
            vesselUseFeatures.setStartDate(scientificCruise.getDepartureDateTime());
        }
        vesselUseFeatures.setEndDate(target.getEndDateTime());
        vesselUseFeatures.setVessel(target.getVessel());
        vesselUseFeatures.setProgram(scientificCruise.getProgram());
        vesselUseFeatures.setIsActive(isActive.ACTIVE.getValue());
        if (vesselUseFeatures.getCreationDate() == null) {
            d = this.newCreateDate();
            vesselUseFeatures.setCreationDate(d);
        }
        if (vesselUseFeatures.getQualityFlag() == null) {
            vesselUseFeatures.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        }
        gearUseFeatures.setStartDate(target.getStartDateTime());
        if (gearUseFeatures.getStartDate() == null) {
            gearUseFeatures.setStartDate(scientificCruise.getDepartureDateTime());
        }
        gearUseFeatures.setEndDate(target.getEndDateTime());
        gearUseFeatures.setVessel(target.getVessel());
        gearUseFeatures.setProgram(scientificCruise.getProgram());
        if (gearUseFeatures.getCreationDate() == null) {
            d = this.newCreateDate();
            gearUseFeatures.setCreationDate(d);
        }
        if (gearUseFeatures.getQualityFlag() == null) {
            gearUseFeatures.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        }
        if (source.getGear() == null) {
            gearUseFeatures.setGear(null);
        } else if (source.getGear() != null && source.getGear().getId() != null) {
            gearUseFeatures.setGear((Gear)this.load(GearImpl.class, Integer.valueOf(source.getGear().getId())));
        }
        if (source.getGearShootingEndLatitude() != null || source.getGearShootingEndDate() != null || source.getGearShootingEndLongitude() != null) {
            if (startPosition == null) {
                startPosition = VesselPosition.Factory.newInstance();
                startPosition.setOperation((Operation)target);
                if (target.getVesselPositions() == null) {
                    target.setVesselPositions((Collection)Sets.newHashSet((Object[])new VesselPosition[]{startPosition}));
                }
                target.getVesselPositions().add(startPosition);
            }
            startPosition.setDateTime(target.getStartDateTime());
            startPosition.setLatitude(source.getGearShootingStartLatitude() == null ? DEFAULT_EMPTY_LATITUDE : source.getGearShootingStartLatitude());
            startPosition.setLongitude(source.getGearShootingStartLongitude() == null ? DEFAULT_EMPTY_LONGITUDE : source.getGearShootingStartLongitude());
            startPosition.setVessel(target.getVessel());
            startPosition.setProgram(scientificCruise.getProgram());
            startPosition.setRecorderDepartment(scientificCruise.getRecorderDepartment());
            startPosition.setQualityFlag(target.getQualityFlag());
        } else if (startPosition != null && target.getVesselPositions() != null) {
            target.getVesselPositions().remove(startPosition);
        }
        if (source.getGearShootingEndLatitude() != null || source.getGearShootingEndDate() != null || source.getGearShootingEndLongitude() != null) {
            if (endPosition == null) {
                endPosition = VesselPosition.Factory.newInstance();
                endPosition.setOperation((Operation)target);
                target.getVesselPositions().add(endPosition);
            }
            Date endDateTime = this.convertUI2DatabaseMandatoryDate(target.getEndDateTime(), startPosition.getDateTime(), true);
            endPosition.setDateTime(endDateTime);
            if (!endDateTime.equals(target.getEndDateTime())) {
                target.setEndDateTime(endDateTime);
                target.setFishingEndDateTime(endDateTime);
            }
            endPosition.setLatitude(this.convertUI2DatabaseMandatoryLatitude(source.getGearShootingEndLatitude()));
            endPosition.setLongitude(this.convertUI2DatabaseMandatoryLatitude(source.getGearShootingEndLongitude()));
            endPosition.setVessel(target.getVessel());
            endPosition.setProgram(scientificCruise.getProgram());
            endPosition.setRecorderDepartment(scientificCruise.getRecorderDepartment());
            endPosition.setQualityFlag(target.getQualityFlag());
        } else if (endPosition != null && target.getVesselPositions() != null) {
            target.getVesselPositions().remove(endPosition);
        }
        CaracteristicMap vesselUseCaracteristics = source.getVesselUseFeatures();
        if (vesselUseCaracteristics != null && vesselUseCaracteristics.size() != 0 && vesselUseCaracteristics != null && vesselUseCaracteristics.size() > 0) {
            for (Caracteristic caracteristic : vesselUseCaracteristics.keySet()) {
                VesselUseMeasurement vum2 = this.setVesselUseMeasurement(scientificCruise, vesselUseFeatures, caracteristic, (Serializable)vesselUseCaracteristics.get(caracteristic));
                notChangedVesselUseMeasurements.remove(vum2);
            }
        }
        StringBuilder miscDataBuffer = new StringBuilder();
        if (source.getRecorderPerson() == null || source.getRecorderPerson().size() == 0) {
            miscDataBuffer.append(MISC_DATA_RECORDER_PERSONS_TAG);
        } else if (source.getRecorderPerson() != null && source.getRecorderPerson().size() > 0) {
            List<Person> persons = source.getRecorderPerson();
            miscDataBuffer.append(MISC_DATA_RECORDER_PERSONS_TAG);
            for (int i = 0; i < persons.size(); ++i) {
                if (i > 0) {
                    miscDataBuffer.append(',');
                }
                miscDataBuffer.append(persons.get(i).getId());
            }
        }
        if (source.getComment() == null) {
            target.setComments(miscDataBuffer.toString());
        } else if (source.getComment() != null) {
            target.setComments(source.getComment() + miscDataBuffer);
        }
        CaracteristicMap gearUseCaracteristics = source.getGearUseFeatures();
        if (gearUseCaracteristics != null && gearUseCaracteristics.size() != 0 && gearUseCaracteristics != null && gearUseCaracteristics.size() > 0) {
            for (Caracteristic caracteristic : gearUseCaracteristics.keySet()) {
                GearUseMeasurement gum = this.setGearUseMeasurement(scientificCruise, gearUseFeatures, caracteristic, (Serializable)gearUseCaracteristics.get(caracteristic));
                notChangedGearUseMeasurements.remove(gum);
            }
        }
        if (vesselUseFeatures.getVesselUseMeasurements() != null && notChangedVesselUseMeasurements.size() > 0) {
            for (VesselUseMeasurement vum3 : notChangedVesselUseMeasurements) {
                vesselUseFeatures.getVesselUseMeasurements().remove(vum3);
            }
        }
        if (gearUseFeatures.getGearUseMeasurements() != null && notChangedGearUseMeasurements.size() > 0) {
            for (GearUseMeasurement gum : notChangedGearUseMeasurements) {
                gearUseFeatures.getGearUseMeasurements().remove(gum);
            }
        }
        Integer statisticalLocationId = null;
        if (source.getGearShootingStartLatitude() != null && source.getGearShootingStartLongitude() != null) {
            statisticalLocationId = this.locationService.getLocationIdByLatLong(source.getGearShootingStartLatitude(), source.getGearShootingStartLongitude());
        }
        if (statisticalLocationId == null && source.getGearShootingEndLatitude() != null && source.getGearShootingEndLongitude() != null) {
            statisticalLocationId = this.locationService.getLocationIdByLatLong(source.getGearShootingEndLatitude(), source.getGearShootingEndLongitude());
        }
        if (source.getStrata() != null && source.getStrata().getId() != null && source.getStrata() != null && source.getStrata().getId() != null) {
            fa2rl = FishingArea2RegulationLocation.Factory.newInstance();
            fa2rlPK = new FishingArea2RegulationLocationPK();
            fa2rl.setFishingArea2RegulationLocationPk(fa2rlPK);
            fa2rlPK.setFishingArea(fishingArea);
            fa2rlPK.setLocation((Location)this.load(LocationImpl.class, Integer.valueOf(source.getStrata().getId())));
            notChangedRegulationLocation.remove(fa2rl);
            if (fishingArea.getRegulationLocation() == null) {
                fishingArea.setRegulationLocation((Collection)Sets.newHashSet((Object[])new FishingArea2RegulationLocation[]{fa2rl}));
            } else {
                fishingArea.getRegulationLocation().add(fa2rl);
            }
            if (statisticalLocationId == null) {
                statisticalLocationId = Integer.valueOf(source.getStrata().getId());
            }
        }
        if (source.getSubStrata() != null && source.getSubStrata().getId() != null && source.getSubStrata() != null && source.getSubStrata().getId() != null) {
            fa2rl = FishingArea2RegulationLocation.Factory.newInstance();
            fa2rlPK = new FishingArea2RegulationLocationPK();
            fa2rl.setFishingArea2RegulationLocationPk(fa2rlPK);
            fa2rlPK.setFishingArea(fishingArea);
            fa2rlPK.setLocation((Location)this.load(LocationImpl.class, Integer.valueOf(source.getSubStrata().getId())));
            notChangedRegulationLocation.remove(fa2rl);
            if (fishingArea.getRegulationLocation() == null) {
                fishingArea.setRegulationLocation((Collection)Sets.newHashSet((Object[])new FishingArea2RegulationLocation[]{fa2rl}));
            } else {
                fishingArea.getRegulationLocation().add(fa2rl);
            }
            if (statisticalLocationId == null) {
                statisticalLocationId = Integer.valueOf(source.getSubStrata().getId());
            }
        }
        if (source.getLocation() != null && source.getLocation().getId() != null && source.getLocation() != null && source.getLocation().getId() != null) {
            fa2rl = FishingArea2RegulationLocation.Factory.newInstance();
            fa2rlPK = new FishingArea2RegulationLocationPK();
            fa2rl.setFishingArea2RegulationLocationPk(fa2rlPK);
            fa2rlPK.setFishingArea(fishingArea);
            fa2rlPK.setLocation((Location)this.load(LocationImpl.class, Integer.valueOf(source.getLocation().getId())));
            notChangedRegulationLocation.remove(fa2rl);
            if (fishingArea.getRegulationLocation() == null) {
                fishingArea.setRegulationLocation((Collection)Sets.newHashSet((Object[])new FishingArea2RegulationLocation[]{fa2rl}));
            } else {
                fishingArea.getRegulationLocation().add(fa2rl);
            }
            if (statisticalLocationId == null) {
                statisticalLocationId = Integer.valueOf(source.getLocation().getId());
            }
        }
        fishingArea.getRegulationLocation().removeAll(notChangedRegulationLocation);
        if (statisticalLocationId == null) {
            gearUseFeatures.getFishingAreas().remove(fishingArea);
            if (fishingArea.getRegulationLocation() != null) {
                fishingArea.getRegulationLocation().clear();
            }
        } else if (statisticalLocationId != null) {
            fishingArea.setLocation((Location)this.load(LocationImpl.class, statisticalLocationId));
        }
    }

    protected Float convertUI2DatabaseMandatoryLatitude(Float databaseValue) {
        return databaseValue != null ? databaseValue : DEFAULT_EMPTY_LATITUDE;
    }

    protected Float convertLatitude2UI(Float databaseValue) {
        return DEFAULT_EMPTY_LATITUDE.equals(databaseValue) ? null : databaseValue;
    }

    protected Float convertUI2DatabaseMandatoryLongitude(Float databaseValue) {
        return databaseValue != null ? databaseValue : DEFAULT_EMPTY_LONGITUDE;
    }

    protected Float convertLongitude2UI(Float databaseValue) {
        return DEFAULT_EMPTY_LONGITUDE.equals(databaseValue) ? null : databaseValue;
    }

    protected VesselUseMeasurement getVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Integer pmfmId, boolean createIfNotExists) {
        VesselUseMeasurement vesselUseMeasurement = null;
        if (vesselUseFeatures.getVesselUseMeasurements() != null) {
            for (VesselUseMeasurement vum : vesselUseFeatures.getVesselUseMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                vesselUseMeasurement = vum;
                break;
            }
        }
        if (vesselUseMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            vesselUseMeasurement = VesselUseMeasurement.Factory.newInstance();
            vesselUseMeasurement.setVesselUseFeatures(vesselUseFeatures);
            if (vesselUseFeatures.getVesselUseMeasurements() == null) {
                vesselUseFeatures.setVesselUseMeasurements((Collection)Sets.newHashSet((Object[])new VesselUseMeasurement[]{vesselUseMeasurement}));
            } else {
                vesselUseFeatures.getVesselUseMeasurements().add(vesselUseMeasurement);
            }
            vesselUseMeasurement.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            vesselUseMeasurement.setDepartment(scientificCruise.getRecorderDepartment());
            vesselUseMeasurement.setPmfm((Pmfm)this.load(PmfmImpl.class, pmfmId));
        }
        return vesselUseMeasurement;
    }

    protected VesselUseMeasurement setVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        VesselUseMeasurement vesselUseMeasurement = this.getVesselUseMeasurement(scientificCruise, vesselUseFeatures, pmfmId, true);
        if (alphanumericalValue != null) {
            vesselUseMeasurement.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            vesselUseMeasurement.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            vesselUseMeasurement.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId));
        }
        return vesselUseMeasurement;
    }

    protected VesselUseMeasurement setVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Integer pmfmId, Serializable value) {
        VesselUseMeasurement vesselUseMeasurement = this.getVesselUseMeasurement(scientificCruise, vesselUseFeatures, pmfmId, true);
        if (value instanceof String) {
            vesselUseMeasurement.setAlphanumericalValue((String)((Object)value));
        } else if (value instanceof Float) {
            vesselUseMeasurement.setNumericalValue((Float)value);
        } else if (value instanceof Integer) {
            vesselUseMeasurement.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, (Integer)value));
        }
        return vesselUseMeasurement;
    }

    protected VesselUseMeasurement setVesselUseMeasurement(ScientificCruise scientificCruise, VesselUseFeatures vesselUseFeatures, Caracteristic caracteristic, Serializable value) {
        VesselUseMeasurement vesselUseMeasurement = this.getVesselUseMeasurement(scientificCruise, vesselUseFeatures, Integer.valueOf(caracteristic.getId()), true);
        this.setMeasurement((Measurement)vesselUseMeasurement, caracteristic, value);
        return vesselUseMeasurement;
    }

    protected void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (value == null) {
            return;
        }
        if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
            measurement.setAlphanumericalValue((String)((Object)value));
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
            measurement.setNumericalValue((Float)value);
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            Integer qvId = null;
            if (value instanceof CaracteristicQualitativeValue) {
                qvId = Integer.valueOf(((CaracteristicQualitativeValue)value).getId());
            } else if (value instanceof Integer) {
                qvId = (Integer)value;
            }
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
            measurement.setQualitativeValue(qv);
        }
    }

    protected GearUseMeasurement setGearUseMeasurement(ScientificCruise scientificCruise, GearUseFeatures gearUseFeatures, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        GearUseMeasurement gearUseMeasurement = this.getGearUseMeasurement(scientificCruise, gearUseFeatures, pmfmId, true);
        if (alphanumericalValue != null) {
            gearUseMeasurement.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            gearUseMeasurement.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId);
            gearUseMeasurement.setQualitativeValue(qv);
        }
        return gearUseMeasurement;
    }

    protected GearUseMeasurement setGearUseMeasurement(ScientificCruise scientificCruise, GearUseFeatures gearUseFeatures, Caracteristic caracteristic, Serializable value) {
        GearUseMeasurement gearUseMeasurement = this.getGearUseMeasurement(scientificCruise, gearUseFeatures, Integer.valueOf(caracteristic.getId()), true);
        this.setMeasurement((Measurement)gearUseMeasurement, caracteristic, value);
        return gearUseMeasurement;
    }

    protected GearUseMeasurement getGearUseMeasurement(ScientificCruise scientificCruise, GearUseFeatures gearUseFeatures, Integer pmfmId, boolean createIfNotExists) {
        GearUseMeasurement gearUseMeasurement = null;
        if (gearUseFeatures.getGearUseMeasurements() != null) {
            for (GearUseMeasurement vum : gearUseFeatures.getGearUseMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                gearUseMeasurement = vum;
                break;
            }
        }
        if (gearUseMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            gearUseMeasurement = GearUseMeasurement.Factory.newInstance();
            gearUseMeasurement.setGearUseFeatures(gearUseFeatures);
            if (gearUseFeatures.getGearUseMeasurements() == null) {
                gearUseFeatures.setGearUseMeasurements((Collection)Sets.newHashSet((Object[])new GearUseMeasurement[]{gearUseMeasurement}));
            } else {
                gearUseFeatures.getGearUseMeasurements().add(gearUseMeasurement);
            }
            gearUseMeasurement.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            gearUseMeasurement.setDepartment(scientificCruise.getRecorderDepartment());
            Pmfm pmfm = (Pmfm)this.getCurrentSession().load(PmfmImpl.class, (Serializable)pmfmId);
            gearUseMeasurement.setPmfm(pmfm);
        }
        return gearUseMeasurement;
    }

    protected void setOperationVesselAssociation(Operation target, String vesselCode) {
        OperationVesselAssociation ova = null;
        OperationVesselAssociationPK ovaPK = new OperationVesselAssociationPK();
        ovaPK.setVessel((fr.ifremer.adagio.core.dao.referential.vessel.Vessel)this.load(VesselImpl.class, (Serializable)((Object)vesselCode)));
        ovaPK.setOperation(target);
        if (vesselCode.equals(target.getVessel().getCode())) {
            this.removeAllOperationVesselAssociation(target);
            return;
        }
        for (OperationVesselAssociation asso : target.getOperationVesselAssociations()) {
            if (!asso.getOperationVesselAssociationPk().equals((Object)ovaPK)) continue;
            ova = asso;
            break;
        }
        if (ova == null) {
            ova = OperationVesselAssociation.Factory.newInstance();
            ova.setOperationVesselAssociationPk(ovaPK);
            if (target.getOperationVesselAssociations() == null) {
                target.setOperationVesselAssociations((Collection)Lists.newArrayList((Object[])new OperationVesselAssociation[]{ova}));
            } else {
                this.removeAllOperationVesselAssociation(target);
                target.getOperationVesselAssociations().add(ova);
            }
        }
        ova.setIsCatchOnOperationVessel(Boolean.FALSE);
    }

    protected void removeAllOperationVesselAssociation(Operation target) {
        if (target.getOperationVesselAssociations() != null) {
            for (OperationVesselAssociation asso : target.getOperationVesselAssociations()) {
                this.operationVesselAssociationDao.remove(asso);
            }
            target.getOperationVesselAssociations().clear();
        }
    }
}

