/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities;

import fr.ifremer.tutti.persistence.entities.IdAware;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.util.CollectionUtil;

public abstract class AbstractTuttiEntity
implements Serializable,
IdAware {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ID = "id";
    protected String id;
    protected Integer intId;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.intId = null;
    }

    public void setId(Integer id) {
        this.intId = id;
        this.id = id == null ? null : String.valueOf(id);
    }

    public Integer getIdAsInt() {
        if (this.intId == null && this.id != null) {
            this.intId = Integer.valueOf(this.id);
        }
        return this.intId;
    }

    protected <B> B getChild(Collection<B> child, int index) {
        return (B)CollectionUtil.getOrNull(child, (int)index);
    }

    protected <B> B getChild(List<B> child, int index) {
        return (B)CollectionUtil.getOrNull(child, (int)index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (ObjectUtils.notEqual(o.getClass(), this.getClass())) {
            return false;
        }
        if (!(o instanceof AbstractTuttiEntity)) {
            return false;
        }
        AbstractTuttiEntity that = (AbstractTuttiEntity)o;
        return ObjectUtils.equals((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        return super.toString() + ": " + this.id;
    }
}

