/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.CancelEditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.AbstractCaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditFishingOperationUIHandler
extends AbstractTuttiTabContainerUIHandler<EditFishingOperationUIModel, EditFishingOperationUI>
implements TabHandler {
    private static final Log log = LogFactory.getLog(EditFishingOperationUIHandler.class);
    private final FishingOperationsUI parentUi;
    private final PersistenceService persistenceService;
    private final PropertyChangeListener startDateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Date oldDate = (Date)evt.getOldValue();
            Date newDate = (Date)evt.getNewValue();
            if (!(((EditFishingOperationUIModel)EditFishingOperationUIHandler.this.getModel()).getGearShootingEndDate() != null || oldDate != null && DateUtils.isSameDay((Date)oldDate, (Date)newDate))) {
                ((EditFishingOperationUIModel)EditFishingOperationUIHandler.this.getModel()).setGearShootingEndDate(newDate);
            }
        }
    };
    private final PropertyChangeListener coordinatePropertiesListener = new PropertyChangeListener(){
        private List<String> properties = Lists.newArrayList((Object[])new String[]{"fishingOperationRectiligne", "gearShootingEndLatitude", "gearShootingEndLatitudeDecimalMinute", "gearShootingEndLatitudeDegree", "gearShootingEndLatitudeMinute", "gearShootingEndLatitudeSecond", "gearShootingEndLongitude", "gearShootingEndLongitudeDecimalMinute", "gearShootingEndLongitudeDegree", "gearShootingEndLongitudeMinute", "gearShootingEndLongitudeSecond", "gearShootingStartLatitude", "gearShootingStartLatitudeDecimalMinute", "gearShootingStartLatitudeDegree", "gearShootingStartLatitudeMinute", "gearShootingStartLatitudeSecond", "gearShootingStartLongitude", "gearShootingStartLongitudeDecimalMinute", "gearShootingStartLongitudeDegree", "gearShootingStartLongitudeMinute", "gearShootingStartLongitudeSecond"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel source;
            if (this.properties.contains(evt.getPropertyName()) && (source = (EditFishingOperationUIModel)evt.getSource()).isFishingOperationRectiligne()) {
                source.computeDistance();
            }
        }
    };
    private final TuttiBeanMonitor<EditFishingOperationUIModel> fishingOperationMonitor;

    public EditFishingOperationUIHandler(FishingOperationsUI parentUi, EditFishingOperationUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.persistenceService = this.context.getPersistenceService();
        this.fishingOperationMonitor = new TuttiBeanMonitor("stationNumber", "fishingOperationNumber", "strata", "subStrata", "gearShootingStartLatitude", "gearShootingStartLongitude", "gearShootingStartDate", "gearShootingEndLatitude", "gearShootingEndLongitude", "gearShootingEndDate", "fishingOperationRectiligne", "trawlDistance", "fishingOperationValid", "location", "recorderPerson", "vessel", "gear", "multirigAggregation", "comment");
    }

    @Override
    public void beforeInitUI() {
        EditFishingOperationUIModel model = new EditFishingOperationUIModel();
        model.setCoordinateEditorType(this.getConfig().getCoordinateEditorType());
        model.setValidationContext(this.getContext().getValidationContext());
        model.addPropertyChangeListener("strata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)evt.getSource();
                TuttiLocation newStrata = (TuttiLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedStrata(source, newStrata);
            }
        });
        model.addPropertyChangeListener("subStrata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)evt.getSource();
                TuttiLocation newStrata = (TuttiLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedSubStrata(source, newStrata);
            }
        });
        this.getContext().addPropertyChangeListener("validationContext", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((EditFishingOperationUIModel)EditFishingOperationUIHandler.this.getModel()).setValidationContext((String)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("fishingOperationValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean valid = (Boolean)evt.getNewValue();
                Color color = null;
                Color fontColor = Color.BLACK;
                if (valid == Boolean.TRUE) {
                    color = Color.GREEN;
                } else if (valid == Boolean.FALSE) {
                    color = Color.RED;
                    fontColor = Color.WHITE;
                }
                Component tab = EditFishingOperationUIHandler.this.getTabPanel().getTabComponentAt(0);
                tab.setForeground(fontColor);
                tab.setBackground(color);
            }
        });
        ((EditFishingOperationUI)this.ui).setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        ((EditFishingOperationUI)this.ui).getFishingOperationValidPanel().remove(((EditFishingOperationUI)this.ui).getFishingOperationResetRadio());
        EditFishingOperationUIModel model = (EditFishingOperationUIModel)this.getModel();
        this.initUI(this.ui);
        List<Person> people = this.getDataContext().getPersons();
        this.initBeanList(((EditFishingOperationUI)this.ui).getRecorderPersonList(), people, model.getRecorderPerson());
        this.initBeanFilterableComboBox(((EditFishingOperationUI)this.ui).getGearComboBox(), Lists.newArrayList(), null);
        Cruise cruise = this.getDataContext().getCruise();
        Preconditions.checkNotNull((Object)cruise, (Object)"Could not find cruise in ui context");
        ((EditFishingOperationUI)this.ui).getMultirigAggregationField().setEnabled(cruise.getMultirigNumber() != 1);
        Program program = this.getDataContext().getProgram();
        Preconditions.checkNotNull((Object)program, (Object)"Could not find program in ui context");
        TuttiLocation zone = program.getZone();
        TuttiLocation strata = model.getStrata();
        String strataId = strata == null ? null : strata.getId();
        TuttiLocation subStrata = model.getSubStrata();
        String substrataId = subStrata == null ? null : subStrata.getId();
        TuttiLocation location = model.getLocation();
        String zoneId = zone.getId();
        List stratas = this.persistenceService.getAllFishingOperationStrata(zoneId);
        List subStratas = this.persistenceService.getAllFishingOperationSubStrata(zoneId, strataId);
        List locations = this.persistenceService.getAllFishingOperationLocation(zoneId, strataId, substrataId);
        this.initBeanFilterableComboBox(((EditFishingOperationUI)this.ui).getStrataComboBox(), stratas, strata);
        this.initBeanFilterableComboBox(((EditFishingOperationUI)this.ui).getSubStrataComboBox(), subStratas, subStrata);
        this.initBeanFilterableComboBox(((EditFishingOperationUI)this.ui).getLocationComboBox(), locations, location);
        this.changeValidatorContext(model.getValidationContext(), ((EditFishingOperationUI)this.ui).getValidator());
        this.listenValidatorValid((SimpleBeanValidator)((EditFishingOperationUI)this.ui).getValidator(), model);
        this.setCustomTab(0, model);
        this.listModelIsModify(model);
        GearUseFeatureTabUIModel gearUseFeatureModel = ((EditFishingOperationUI)this.ui).getGearUseFeatureTabContent().getModel();
        gearUseFeatureModel.setAvailableCaracteristics(this.getDataContext().getCaracteristics());
        this.setCustomTab(1, gearUseFeatureModel);
        VesselUseFeatureTabUIModel vesselUseFeatureModel = ((EditFishingOperationUI)this.ui).getVesselUseFeatureTabContent().getModel();
        vesselUseFeatureModel.setAvailableCaracteristics(this.getDataContext().getCaracteristics());
        this.setCustomTab(2, vesselUseFeatureModel);
        if ("validate".equals(model.getValidationContext())) {
            PropertyChangeListener pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean allModelsValid = EditFishingOperationUIHandler.this.areAllModelsValid();
                    ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSaveButton().setEnabled(allModelsValid);
                }
            };
            gearUseFeatureModel.addPropertyChangeListener("valid", pcl);
            vesselUseFeatureModel.addPropertyChangeListener("valid", pcl);
            model.addPropertyChangeListener("valid", pcl);
        } else {
            model.addPropertyChangeListener("valid", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Boolean valid = (Boolean)evt.getNewValue();
                    if (valid != null) {
                        ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getSaveButton().setEnabled(valid);
                    }
                }
            });
        }
        ((EditFishingOperationUIModel)this.getModel()).addPropertyChangeListener("id", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JButton button = ((EditFishingOperationUI)EditFishingOperationUIHandler.this.ui).getCancelButton();
                CancelEditFishingOperationAction action = (CancelEditFishingOperationAction)((Object)TuttiActionHelper.getLogicAction(button));
                if (evt.getNewValue() == null) {
                    button.setText(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation", (Object[])new Object[0]));
                    button.setToolTipText(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation.tip", (Object[])new Object[0]));
                    action.setActionDescription(I18n._((String)"tutti.editFishingOperation.action.cancelEditFishingOperation.tip", (Object[])new Object[0]));
                } else {
                    button.setText(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation", (Object[])new Object[0]));
                    button.setToolTipText(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation.tip", (Object[])new Object[0]));
                    action.setActionDescription(I18n._((String)"tutti.editFishingOperation.action.resetEditFishingOperation.tip", (Object[])new Object[0]));
                }
            }
        });
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditFishingOperationUI)this.ui).getFishingOperationAttachmentsButton().onCloseUI();
        this.closeUI(((EditFishingOperationUI)this.ui).getGearUseFeatureTabContent());
        this.closeUI(((EditFishingOperationUI)this.ui).getVesselUseFeatureTabContent());
    }

    @Override
    protected boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditFishingOperationUI)this.ui).getFishingOperationAttachmentsButton().onCloseUI();
        return super.onTabChanged(currentIndex, newIndex);
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        ((EditFishingOperationUI)this.ui).getFishingOperationAttachmentsButton().onCloseUI();
        if (this.isAModelModified()) {
            EditFishingOperationUIModel model = (EditFishingOperationUIModel)this.getModel();
            if (model.isValid()) {
                String message = TuttiEntities.isNew(model.getFishingOperation()) ? I18n._((String)"tutti.editFishingOperation.askSaveBeforeLeaving.createFishingOperation", (Object[])new Object[0]) : I18n._((String)"tutti.editFishingOperation.askSaveBeforeLeaving.saveFishingOperation", (Object[])new Object[0]);
                int answer = this.askSaveBeforeLeaving(message);
                ActionEvent event = new ActionEvent(this, newIndex, null);
                switch (answer) {
                    case 0: {
                        TuttiActionHelper.runAction(((EditFishingOperationUI)this.ui).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        TuttiActionHelper.runAction(((EditFishingOperationUI)this.ui).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n._((String)"tutti.editFishingOperation.askCancelEditBeforeLeaving.cancelEditFishingOperation", (Object[])new Object[0]));
                if (result) {
                    TuttiActionHelper.runAction(((EditFishingOperationUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators(((EditFishingOperationUI)this.ui).getValidator());
    }

    public void registerValidator() {
        this.registerValidators(((EditFishingOperationUI)this.ui).getValidator());
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ((EditFishingOperationUI)this.ui).getFishingOperationTabPane();
    }

    @Override
    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return ((EditFishingOperationUI)this.ui).getValidator();
    }

    public AbstractCaracteristicTabUIModel[] getSubModels() {
        return new AbstractCaracteristicTabUIModel[]{((EditFishingOperationUI)this.ui).getGearUseFeatureTabContent().getModel(), ((EditFishingOperationUI)this.ui).getVesselUseFeatureTabContent().getModel()};
    }

    public void uninstallStartDateListener() {
        ((EditFishingOperationUIModel)this.getModel()).removePropertyChangeListener("gearShootingStartDate", this.startDateListener);
    }

    public void installStartDateListener() {
        ((EditFishingOperationUIModel)this.getModel()).addPropertyChangeListener("gearShootingStartDate", this.startDateListener);
    }

    public void uninstallCoordinatesListener() {
        ((EditFishingOperationUIModel)this.getModel()).removePropertyChangeListener(this.coordinatePropertiesListener);
    }

    public void installCoordinatesListener() {
        ((EditFishingOperationUIModel)this.getModel()).addPropertyChangeListener(this.coordinatePropertiesListener);
    }

    public FishingOperationsUI getParentUi() {
        return this.parentUi;
    }

    public TuttiBeanMonitor<EditFishingOperationUIModel> getFishingOperationMonitor() {
        return this.fishingOperationMonitor;
    }

    public String getGearLatitudeLabelText(CoordinateEditorType coordinateEditorType) {
        String result = I18n._((String)"tutti.editFishingOperation.field.gearLatitude", (Object[])new Object[]{coordinateEditorType.toString()});
        return result;
    }

    public String getGearLongitudeLabelText(CoordinateEditorType coordinateEditorType) {
        String result = I18n._((String)"tutti.editFishingOperation.field.gearLongitude", (Object[])new Object[]{coordinateEditorType.toString()});
        return result;
    }

    public String getTrawlDistanceTooltipText(Float trawlDistance) {
        String result = trawlDistance == null ? null : I18n._((String)"tutti.editFishingOperation.field.trawlDistance.inMilles.tip", (Object[])new Object[]{TuttiUIUtil.getDistanceInMilles(trawlDistance)});
        return result;
    }

    @Override
    public void setDate(ActionEvent event, String property) {
        JXDatePicker field = (JXDatePicker)event.getSource();
        Date value = field.getDate();
        Date date = (Date)TuttiUIUtil.getProperty(this.getModel(), property);
        if (value != null && date != null) {
            Calendar cal = DateUtils.toCalendar((Date)date);
            value = DateUtils.setHours((Date)value, (int)cal.get(11));
            value = DateUtils.setMinutes((Date)value, (int)cal.get(12));
        }
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    public String getDuration(Date startDate, Date endDate) {
        String duration = "";
        if (startDate != null && endDate != null && !startDate.after(endDate)) {
            duration = DurationFormatUtils.formatPeriod((long)startDate.getTime(), (long)endDate.getTime(), (String)I18n._((String)"tutti.editFishingOperation.duration.format", (Object[])new Object[0]));
        }
        return duration;
    }

    protected void onSelectedStrata(EditFishingOperationUIModel model, TuttiLocation newStrata) {
        model.setSubStrata(null);
        ((EditFishingOperationUI)this.ui).getSubStrataComboBox().setData(null);
        TuttiLocation zone = this.getDataContext().getProgram().getZone();
        String zoneId = zone.getId();
        String strataId = newStrata == null ? null : newStrata.getId();
        List subStrata = this.persistenceService.getAllFishingOperationSubStrata(zoneId, strataId);
        List location = this.persistenceService.getAllFishingOperationLocation(zoneId, strataId, null);
        ((EditFishingOperationUI)this.ui).getSubStrataComboBox().setData(subStrata);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(location);
        if (newStrata == null) {
            ((EditFishingOperationUI)this.ui).getStrataComboBox().grabFocus();
        } else if (CollectionUtils.isEmpty((Collection)subStrata)) {
            ((EditFishingOperationUI)this.ui).getLocationComboBox().grabFocus();
        }
    }

    protected void onSelectedSubStrata(EditFishingOperationUIModel model, TuttiLocation newSubStrata) {
        model.setLocation(null);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(null);
        TuttiLocation zone = this.getDataContext().getProgram().getZone();
        String zoneId = zone.getId();
        TuttiLocation strata = model.getStrata();
        String subStrataId = newSubStrata == null ? null : newSubStrata.getId();
        String strataId = strata == null ? null : strata.getId();
        List location = this.persistenceService.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
        ((EditFishingOperationUI)this.ui).getLocationComboBox().setData(location);
        if (newSubStrata == null) {
            ((EditFishingOperationUI)this.ui).getSubStrataComboBox().grabFocus();
        }
    }

    protected boolean areAllModelsValid() {
        AbstractCaracteristicTabUIModel[] subModels;
        boolean result = ((EditFishingOperationUIModel)this.getModel()).isValid();
        for (AbstractCaracteristicTabUIModel subModel : subModels = this.getSubModels()) {
            result &= subModel.isValid();
        }
        return result;
    }

    protected boolean isAModelModified() {
        AbstractCaracteristicTabUIModel[] subModels;
        boolean result = ((EditFishingOperationUIModel)this.getModel()).isModify();
        for (AbstractCaracteristicTabUIModel subModel : subModels = this.getSubModels()) {
            result |= subModel.isModify();
        }
        return result;
    }

    protected void resetAllModels() {
        for (AbstractCaracteristicTabUIModel subModel : this.getSubModels()) {
            subModel.setModify(false);
        }
        ((EditFishingOperationUIModel)this.getModel()).setModify(false);
    }

    public void reset(FishingOperation bean) {
        Integer objectId = Integer.valueOf(bean.getId());
        List attachments = this.getContext().getPersistenceService().getAllAttachments(objectId);
        ((EditFishingOperationUIModel)this.getModel()).removeAllAttachment(((EditFishingOperationUIModel)this.getModel()).getAttachment());
        ((EditFishingOperationUIModel)this.getModel()).addAllAttachment(attachments);
    }

    public String decorateVessel(Vessel vessel) {
        String result = vessel == null ? "" : "<html><strong>" + this.decorate(vessel) + "</strong></html>";
        return result;
    }
}

