package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class ImportPupitriPopupUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWTW8bRRgeu3G+nDQhVr+goJKkarmMU8QBNVHpp5VEbhuRVKrwoR3vTuJpZ2eHmdl2owjET+APgODOBYkbJ8SBMwcuiL+AEAeuiHd27V1vPMaO1EbKypp5nuf9mved+e5PVNEKvfuMxDFWkTAsoHj71uPHD9vPqGfuUu0pJk2oUPpXKqNyC1X9bF0btNJqWnq9S6/fCQMZCir62OtNNKvNIae6Q6kx6O0iw9O6vpttr8cyUj3VzCmX6jd//1X+0v/i2zJCsQTv5iGUS6NYeSQTTVRmvkFLYOkFqXMiDsANxcQB+Dtv1+5wovUDEtBP0edoqokmJVEgZtDy+CEnGgk/lgbVGCCV2YkkA0t3GeHhgUGb+wqzfUUDqrCJjGE4Yli/BE+wFwoDwjiUVBHDQoE9YrwO1XirX2knlJF8tCVlYmrSoGnqM0PanBr0hg0F2/Dw7TDklIgcNtUhwudUGfTwVfmwmSrmNmYCwsQOEZQbdL5QnlR+z7ppsTMZ5bQByPMG47RJ2pa3ZGOIu4TtZNFCl3IjGcOgVYcRm45QYQu4l/ws0pc8olQYacozo3bnXBE1X0DZxTeLgEUtqceo/j+Rah/GITG9up3kau140MlqETvnEeFRfhvKBSVCtQI+XbXIlTyvLwhnPjE037zaRSj0ViFt0JQ4b8q8a0otVFERLEMxW4N9/DFspR18/lgHW8Fk99+ztd9+/OOHRq9tq2D7jBPaN3WgnaSyB9Awa3oh7dnIMF6/T+R6C81AVWBkJSPposOx3e42OAf20p6wdLxJdAckKlO///Tz2ae/nkLlBprlIfEbxOK34Gh1FGQh5H4sP7qZeDT3chq+i/BfNqhimLHH7kLaNoUOx929ShD6BM7xBBxTGkN2Ljqyk7nYnvnln9ru9zd7GSqBxxeGwvMsVT5Bk0xwJmgy2rpTyznKqlLTyA/z6eSaV8g9sGS3t9eS7weunExze/obwETVo6w1P7MJoDEM0BVXrvYZ5T7O0HFk5a8n8dtfG2hgMIzyZAIMgj04EvjoydVlZ4F6ghiAVGgYb8vvgaMLlteb58y21/UTSGA/ZyZy54jnUWlu8WR0wL+h6pGmcP1U9gnXcEQWfaaSeh7eE3YiZluuPOTj7mTFWDgqjLC8IFeGF6TAcDnjGJ7jF+b9YVktiI4szo0TyrzuAhWvildUpMvDi9R3qbjcGbiYxi/Q2rDM9kmOLM/GiURed3H6r+BxEpFmv5b674VBkDyB7NVr0CzcEuDmln0kocne6hy79qG4LyggmQcXkoOKg2y7auBdtsfk3lA7rigKt//4YZwpyPceBMcCOUV8fyCKd5zMoXG4DTmnevFZMiqWEiSak8MQwOj0BvDIpTYTPrx6bgyol+x3dqSiXf7Kfr52K6yCwn9Qm9HrLQ0AAA==";
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected FileEditor carrouselFile;
    protected JLabel carrouselFileLabel;
    protected Boolean editable;
    protected ImportPupitriPopupUIHandler handler;
    protected ImportPupitriPopupUI importPupitriDialog = this;
    protected Table mainPanel;
    protected FileEditor speciesFile;
    protected JLabel speciesFileLabel;
    protected FileEditor trunkFile;
    protected JLabel trunkFileLabel;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        getHandler().afterInitUI();
    }
    
    public void open() {
        handler.open();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriPopupUI(TuttiUIContext context) {
        super(context.getMainUI());
            setContextValue(context);
            ImportPupitriPopupUIHandler handler = new ImportPupitriPopupUIHandler(context, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI() {
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public FileEditor getCarrouselFile() {
        return carrouselFile;
    }

    public JLabel getCarrouselFileLabel() {
        return carrouselFileLabel;
    }

    public Boolean getEditable() {
        return editable;
    }

    public ImportPupitriPopupUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public FileEditor getSpeciesFile() {
        return speciesFile;
    }

    public JLabel getSpeciesFileLabel() {
        return speciesFileLabel;
    }

    public FileEditor getTrunkFile() {
        return trunkFile;
    }

    public JLabel getTrunkFileLabel() {
        return trunkFileLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportPupitriDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(trunkFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(trunkFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(speciesFileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(speciesFile, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.common.cancel"));
        cancelButton.setToolTipText(_("tutti.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCarrouselFile() {
        $objectMap.put("carrouselFile", carrouselFile = new FileEditor());
        
        carrouselFile.setName("carrouselFile");
        carrouselFile.setAcceptAllFileFilterUsed(false);
        carrouselFile.setDirectoryEnabled(false);
    }

    protected void createCarrouselFileLabel() {
        $objectMap.put("carrouselFileLabel", carrouselFileLabel = new JLabel());
        
        carrouselFileLabel.setName("carrouselFileLabel");
        carrouselFileLabel.setText(_("tutti.importPupitri.field.carrouselFile"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ImportPupitriPopupUIHandler.class));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createSpeciesFile() {
        $objectMap.put("speciesFile", speciesFile = new FileEditor());
        
        speciesFile.setName("speciesFile");
        speciesFile.setAcceptAllFileFilterUsed(false);
        speciesFile.setDirectoryEnabled(false);
    }

    protected void createSpeciesFileLabel() {
        $objectMap.put("speciesFileLabel", speciesFileLabel = new JLabel());
        
        speciesFileLabel.setName("speciesFileLabel");
        speciesFileLabel.setText(_("tutti.importPupitri.field.speciesFile"));
    }

    protected void createTrunkFile() {
        $objectMap.put("trunkFile", trunkFile = new FileEditor());
        
        trunkFile.setName("trunkFile");
        trunkFile.setAcceptAllFileFilterUsed(false);
        trunkFile.setDirectoryEnabled(false);
    }

    protected void createTrunkFileLabel() {
        $objectMap.put("trunkFileLabel", trunkFileLabel = new JLabel());
        
        trunkFileLabel.setName("trunkFileLabel");
        trunkFileLabel.setText(_("tutti.importPupitri.field.trunkFile"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(_("tutti.common.validate"));
        validateButton.setToolTipText(_("tutti.common.validate"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportPupitriDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 15 property setters
        trunkFileLabel.setLabelFor(trunkFile);
        trunkFile.setExts(_("tutti.importPupitri.trunkFile.extension"));
        trunkFile.setExtsDescription(_("tutti.importPupitri.trunkFile.extension.description"));
        carrouselFileLabel.setLabelFor(carrouselFile);
        carrouselFile.setExts(_("tutti.importPupitri.carrouselFile.extension"));
        carrouselFile.setExtsDescription(_("tutti.importPupitri.carrouselFile.extension.description"));
        speciesFileLabel.setLabelFor(carrouselFile);
        speciesFile.setExts(_("tutti.importPupitri.speciesFile.extension"));
        speciesFile.setExtsDescription(_("tutti.importPupitri.speciesFile.extension.description"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.common.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("add"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.common.validate.mnemonic"),'Z'));
        // late initializer
        importPupitriDialog.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("importPupitriDialog", importPupitriDialog);
        createEditable();
        createHandler();
        createMainPanel();
        createTrunkFileLabel();
        createTrunkFile();
        createCarrouselFileLabel();
        createCarrouselFile();
        createSpeciesFileLabel();
        createSpeciesFile();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of importPupitriDialog
        setName("importPupitriDialog");
        importPupitriDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(_("tutti.importPupitri.title"));
        setModal(true);
        
        $completeSetup();
    }

}