/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.home.CloneProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.ImportProtocolAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProtocolUIHandler
extends AbstractTuttiTableUIHandler<EditProtocolSpeciesRowModel, EditProtocolUIModel, EditProtocolUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditProtocolUIHandler.class);
    protected SelectSpeciesUI dialog;

    public static String getTitle(boolean exist) {
        String result = exist ? I18n._((String)"tutti.editProtocol.title.edit.protocol", (Object[])new Object[0]) : I18n._((String)"tutti.editProtocol.title.create.protocol", (Object[])new Object[0]);
        return result;
    }

    public EditProtocolUIHandler(TuttiUI parentUi, EditProtocolUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui, new String[0]);
    }

    public EditProtocolSpeciesTableModel getTableModel() {
        return (EditProtocolSpeciesTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((EditProtocolUI)this.ui).getSpeciesTable();
    }

    @Override
    protected boolean isRowValid(EditProtocolSpeciesRowModel row) {
        return true;
    }

    @Override
    protected void onRowModified(int rowIndex, EditProtocolSpeciesRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, EditProtocolSpeciesRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        if (row != null && row.isModify() && newValue != null && newValue.booleanValue()) {
            ((EditProtocolUIModel)((Object)this.getModel())).setModify(true);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<EditProtocolSpeciesRowModel> rowMonitor, EditProtocolSpeciesRowModel row) {
    }

    @Override
    public SwingValidator<EditProtocolUIModel> getValidator() {
        return ((EditProtocolUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        EditProtocolUIModel model = new EditProtocolUIModel();
        ArrayList allSpecies = Lists.newArrayList(this.getDataContext().getSpecies());
        model.setAllSpecies(allSpecies);
        Multimap allSpeciesByTaxonId = TuttiEntities.splitByReferenceTaxonId((Iterable)allSpecies);
        model.setAllSpeciesByTaxonId((Multimap<String, Species>)allSpeciesByTaxonId);
        Map allReferentSpeciesByTaxonId = TuttiEntities.splitByTaxonId(this.getDataContext().getReferentSpecies());
        model.setAllReferentSpeciesByTaxonId(allReferentSpeciesByTaxonId);
        ArrayList protocols = Lists.newArrayList((Iterable)this.persistenceService.getAllProtocol());
        model.setExistingProtocols(protocols);
        ArrayList caracteristics = Lists.newArrayList(this.getDataContext().getCaracteristics());
        model.setCaracteristics(caracteristics);
        Map allCaracteristic = TuttiEntities.splitById((Iterable)caracteristics);
        model.setAllCaracteristic(allCaracteristic);
        this.listModelIsModify(model);
        ((EditProtocolUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        List<Object> rows;
        TuttiProtocol protocol;
        this.initUI(this.ui);
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        if (this.context.isProtocolFilled()) {
            protocol = this.persistenceService.getProtocol(this.context.getProtocolId());
            model.fromBean(protocol);
            log.debug(model.getExistingProtocols());
            model.getExistingProtocols().remove(protocol);
        } else {
            protocol = (TuttiProtocol)ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
            if (protocol != null) {
                ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                model.fromBean(protocol);
                model.setImported(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n._((String)"tutti.editProtocol.warn.import", (Object[])new Object[0]));
            } else {
                protocol = (TuttiProtocol)CloneProtocolAction.CLONE_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                if (protocol != null) {
                    CloneProtocolAction.CLONE_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                    model.fromBean(protocol);
                    model.setCloned(true);
                    ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n._((String)"tutti.editProtocol.warn.clone", (Object[])new Object[0]));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Will create a new protocol");
                }
            }
        }
        SwingValidator<EditProtocolUIModel> validator = ((EditProtocolUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.COUNT_IF_NO_FREQUENCY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SIZE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SEX_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.MATURITY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.AGE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFY_SAMPLE_ENABLED, (JTable)table);
        EditProtocolSpeciesTableModel tableModel = new EditProtocolSpeciesTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        Collection<Species> referents = model.getAllReferentSpeciesByTaxonId().values();
        ArrayList speciesList = Lists.newArrayList(referents);
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getSpeciesComboBox(), speciesList, null);
        if (protocol == null) {
            rows = Lists.newArrayList();
        } else {
            rows = this.toRows(protocol.getSpecies());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit protocol with " + rows.size() + " species declared."));
            }
        }
        model.setRows(rows);
        ((EditProtocolUI)this.ui).getSpeciesComboBox().getHandler().reset();
        this.initDoubleList("lengthClassesPmfmId", ((EditProtocolUI)this.ui).getLengthClassesList(), Lists.newArrayList(model.getCaracteristics()), model.getLengthClassesPmfmId(), new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic input) {
                boolean result = !((EditProtocolUI)EditProtocolUIHandler.this.ui).getGearUseFeatureList().getModel().getSelected().contains(input);
                return result &= !((EditProtocolUI)EditProtocolUIHandler.this.ui).getVesselUseFeatureList().getModel().getSelected().contains(input);
            }
        });
        this.initDoubleList("gearUseFeaturePmfmId", ((EditProtocolUI)this.ui).getGearUseFeatureList(), Lists.newArrayList(model.getCaracteristics()), model.getGearUseFeaturePmfmId(), new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic input) {
                boolean result = !((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList().getModel().getSelected().contains(input);
                return result &= !((EditProtocolUI)EditProtocolUIHandler.this.ui).getVesselUseFeatureList().getModel().getSelected().contains(input);
            }
        });
        this.initDoubleList("vesselUseFeaturePmfmId", ((EditProtocolUI)this.ui).getVesselUseFeatureList(), Lists.newArrayList(model.getCaracteristics()), model.getVesselUseFeaturePmfmId(), new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic input) {
                boolean result = !((EditProtocolUI)EditProtocolUIHandler.this.ui).getGearUseFeatureList().getModel().getSelected().contains(input);
                return result &= !((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList().getModel().getSelected().contains(input);
            }
        });
        model.setModify(model.isCreate());
        ((EditProtocolUI)this.ui).getCaracteristicPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BeanDoubleList<Caracteristic> selectedDoubleList;
                JTabbedPane tabPanel = (JTabbedPane)e.getSource();
                int selectedIndex = tabPanel.getSelectedIndex();
                log.debug((Object)("selected " + selectedIndex));
                switch (selectedIndex) {
                    case 0: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList();
                        break;
                    }
                    case 1: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getGearUseFeatureList();
                        break;
                    }
                    case 2: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getVesselUseFeatureList();
                        break;
                    }
                    default: {
                        selectedDoubleList = null;
                    }
                }
                if (selectedDoubleList != null) {
                    selectedDoubleList.getHandler().refreshFilteredElements();
                }
            }
        });
        this.dialog = new SelectSpeciesUI(this.ui);
    }

    public List<EditProtocolSpeciesRowModel> toRows(List<SpeciesProtocol> speciesProtocols) {
        BeanFilterableComboBox<Species> speciesComboBox = ((EditProtocolUI)this.ui).getSpeciesComboBox();
        Preconditions.checkNotNull((Object)speciesComboBox.getData());
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        Map<String, Species> allReferentSpeciesByTaxonId = model.getAllReferentSpeciesByTaxonId();
        Map<String, Caracteristic> allCaracteristic = model.getAllCaracteristic();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(speciesProtocols)) {
            for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                String taxonIdStr = String.valueOf(taxonId);
                Collection<Species> allSynonyms = model.getAllSynonyms(taxonIdStr);
                model.getAllSynonyms().removeAll(allSynonyms);
                Species species = allReferentSpeciesByTaxonId.get(taxonIdStr);
                speciesComboBox.getHandler().removeItem((Object)species);
                EditProtocolSpeciesRowModel row = this.getTableModel().createNewRow();
                row.setSpecies(species);
                row.setLengthStepPmfm(allCaracteristic.get(speciesProtocol.getLengthStepPmfmId()));
                row.fromBean(speciesProtocol);
                result.add(row);
            }
        }
        return result;
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean quitUI() {
        boolean result = this.quitScreen(((EditProtocolUIModel)((Object)this.getModel())).isValid(), ((EditProtocolUIModel)((Object)this.getModel())).isModify(), I18n._((String)"tutti.editProtocol.askCancelEditBeforeLeaving.cancelSaveProtocol", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.askSaveBeforeLeaving.saveProtocol", (Object[])new Object[0]), ((EditProtocolUI)this.ui).getSaveButton().getAction());
        return result;
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, EditProtocolSpeciesRowModel oldRow, int newRowIndex, EditProtocolSpeciesRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        ((EditProtocolUIModel)((Object)this.getModel())).setRemoveSpeciesEnabled(newRow != null);
    }

    public void addDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        String id = (String)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListenerId");
        UpdateSelectedList updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
    }

    public void removeDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        String id = (String)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListenerId");
        UpdateSelectedList updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
    }

    public Species openSelectOtherSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUIModel model = this.dialog.getModel();
        model.setSpecies(species);
        model.setSelectedSpecies(null);
        this.openDialog(this.dialog, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }

    protected void initDoubleList(String propertyId, BeanDoubleList<Caracteristic> widget, List<Caracteristic> availableCaracteristics, List<String> selectedCaracteristics, Predicate<Caracteristic> filter) {
        this.initBeanList(widget, availableCaracteristics, Lists.newArrayList());
        UpdateSelectedList listener = new UpdateSelectedList(widget, ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic());
        widget.putClientProperty((Object)"_updateListener", (Object)listener);
        widget.putClientProperty((Object)"_updateListenerId", (Object)propertyId);
        listener.select(selectedCaracteristics);
        widget.getHandler().addFilter(filter);
    }

    protected void selectLengthClasses(List<String> ids, JComboBox comboBox) {
        ArrayList dataToList;
        Map<String, Caracteristic> allCaracteristic = ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic();
        ArrayList selection = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                selection.add(allCaracteristic.get(id));
            }
        }
        if (!(dataToList = Lists.newArrayList((Iterable)selection)).isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox((JComboBox)comboBox, (Collection)dataToList, null);
    }

    protected void addLengthClassesColumnToModel(TableColumnModel model, List<String> selectedIds) {
        Decorator<Caracteristic> decorator = this.getDecorator(Caracteristic.class, null);
        final JComboBox comboBox = new JComboBox();
        ((EditProtocolUIModel)((Object)this.getModel())).addPropertyChangeListener("lengthClassesPmfmId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List ids = (List)evt.getNewValue();
                EditProtocolUIHandler.this.selectLengthClasses(ids, comboBox);
            }
        });
        comboBox.setRenderer(this.newListCellRender(decorator));
        this.selectLengthClasses(selectedIds, comboBox);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), EditProtocolSpeciesTableModel.LENGTH_STEP_PMFM_ID);
    }

    protected static class UpdateSelectedList
    implements PropertyChangeListener {
        private final BeanDoubleListModel<Caracteristic> model;
        private final Map<String, Caracteristic> caracteristicMap;
        private boolean valueIsAdjusting;

        public UpdateSelectedList(BeanDoubleList<Caracteristic> doubleList, Map<String, Caracteristic> caracteristicMap) {
            this.model = doubleList.getModel();
            this.caracteristicMap = caracteristicMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.valueIsAdjusting) {
                this.valueIsAdjusting = true;
                try {
                    List selectedIds = (List)evt.getNewValue();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("[" + evt.getPropertyName() + "] selected ids: " + selectedIds));
                    }
                    this.select(selectedIds);
                }
                finally {
                    this.valueIsAdjusting = false;
                }
            }
        }

        public void select(List<String> selectedIds) {
            ArrayList selection = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(selectedIds)) {
                for (String selectedId : selectedIds) {
                    selection.add(this.caracteristicMap.get(selectedId));
                }
            }
            this.model.setSelected((List)selection);
        }
    }
}

