/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.seller;

import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.seller.SellerImpl;
import fr.ifremer.adagio.core.dao.referential.seller.SellerType;
import java.io.Serializable;

public abstract class Seller
implements Serializable {
    private static final long serialVersionUID = -4564333943127067713L;
    private Integer id;
    private String registrationCode;
    private String name;
    private SellerType sellerType;
    private Location baseSaleLocation;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public void setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SellerType getSellerType() {
        return this.sellerType;
    }

    public void setSellerType(SellerType sellerType) {
        this.sellerType = sellerType;
    }

    public Location getBaseSaleLocation() {
        return this.baseSaleLocation;
    }

    public void setBaseSaleLocation(Location baseSaleLocation) {
        this.baseSaleLocation = baseSaleLocation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Seller)) {
            return false;
        }
        Seller that = (Seller)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Seller newInstance() {
            SellerImpl entity = new SellerImpl();
            return entity;
        }

        public static Seller newInstance(SellerType sellerType) {
            Seller entity = Factory.newInstance();
            entity.setSellerType(sellerType);
            return entity;
        }

        public static Seller newInstance(String registrationCode, String name, SellerType sellerType, Location baseSaleLocation) {
            Seller entity = Factory.newInstance();
            entity.setRegistrationCode(registrationCode);
            entity.setName(name);
            entity.setSellerType(sellerType);
            entity.setBaseSaleLocation(baseSaleLocation);
            return entity;
        }
    }
}

