/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.batch;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchDaoBase;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchImpl;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchImpl;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchQuickFix;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.type.IntegerType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

@Repository(value="catchBatchDao")
@Lazy
public class CatchBatchDaoImpl
extends CatchBatchDaoBase
implements CatchBatchExtendDao {
    @Value(value="${adagio.cache.use_tree_cache}")
    protected final Boolean USE_TREE_CACHE = false;
    protected List<CatchBatchValidator> validators = Lists.newArrayList();
    @Resource(name="sortingBatchDao")
    protected SortingBatchDao sortingBatchDao;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;

    @Autowired
    public CatchBatchDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public CatchBatch loadFullTree(Integer catchBatchId) {
        return this.catchBatchDao.loadFullTreeWithCache(catchBatchId, this.USE_TREE_CACHE, false);
    }

    @Override
    public CatchBatch loadFullTree(Integer catchBatchId, boolean validate, boolean quickFix) throws CatchBatchValidationException {
        CatchBatch catchBatch = this.catchBatchDao.loadFullTreeWithCache(catchBatchId, this.USE_TREE_CACHE, false);
        if (validate) {
            boolean retryValidation = true;
            int quickFixCounter = 0;
            while (retryValidation) {
                List<CatchBatchValidationError> errors = this.validate(catchBatch);
                retryValidation = false;
                if (errors == null || errors.size() <= 0) continue;
                ArrayList quickFixes = Lists.newArrayList();
                boolean hasGravityError = false;
                for (CatchBatchValidationError error : errors) {
                    if (error.getGravity() != 2) continue;
                    hasGravityError = true;
                    if (!quickFix || error.getQuickFixes() == null) continue;
                    quickFixes.addAll(error.getQuickFixes());
                }
                if (hasGravityError && quickFix && quickFixes.size() == 1 && quickFixCounter < 2) {
                    catchBatch = ((CatchBatchQuickFix)quickFixes.get(0)).repair(catchBatch);
                    retryValidation = true;
                    ++quickFixCounter;
                    continue;
                }
                if (!hasGravityError) continue;
                throw new CatchBatchValidationException(errors);
            }
        }
        return catchBatch;
    }

    @Override
    public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
        ArrayList errors = Lists.newArrayList();
        for (CatchBatchValidator validator : this.validators) {
            List<CatchBatchValidationError> result;
            if (!validator.isEnable(catchBatch) || (result = validator.validate(catchBatch)) == null || result.size() <= 0) continue;
            errors.addAll(result);
        }
        if (errors.size() == 0) {
            return null;
        }
        return errors;
    }

    @Override
    public SortingBatch getSortingBatch(Collection<Batch> batchs, Object ... params) {
        if (batchs == null || batchs.size() == 0 || params == null || params.length == 0) {
            return null;
        }
        String propertyName = (String)params[0];
        Integer expectedPmfmId = null;
        Integer qualitativeValueId = null;
        Integer referenceTaxonId = null;
        Object[] newParams = null;
        if ("pmfmId".equals(propertyName)) {
            Preconditions.checkArgument((params.length >= 3 ? 1 : 0) != 0, (Object)"Params must be tuple (propertyName, [pmfmId,] value)");
            expectedPmfmId = (Integer)params[1];
            qualitativeValueId = (Integer)params[2];
            newParams = Arrays.copyOfRange(params, 3, params.length);
        } else if ("referenceTaxonId".equals(propertyName)) {
            Preconditions.checkArgument((params.length >= 2 ? 1 : 0) != 0, (Object)"Params must be tuple (propertyName, [pmfmId,] value)");
            referenceTaxonId = (Integer)params[1];
            newParams = Arrays.copyOfRange(params, 2, params.length);
        } else {
            Preconditions.checkArgument((boolean)false, (Object)"Params must be tuple (propertyName, [pmfmId,] value), and propertyName must be 'pmfmId' or 'referenceTaxonId'.");
        }
        for (SortingBatch sortingBatch : batchs) {
            boolean found = false;
            if (expectedPmfmId != null) {
                for (SortingMeasurement sm : sortingBatch.getSortingMeasurements()) {
                    Integer pmfmId = sm.getPmfm().getId();
                    if (!expectedPmfmId.equals(pmfmId) || sm.getQualitativeValue() == null || !qualitativeValueId.equals(sm.getQualitativeValue().getId())) continue;
                    found = true;
                    break;
                }
            } else if (referenceTaxonId != null && sortingBatch.getReferenceTaxon() != null && referenceTaxonId.equals(sortingBatch.getReferenceTaxon().getId())) {
                found = true;
            }
            if (!found) continue;
            if (newParams != null && newParams.length > 0) {
                return this.getSortingBatch(sortingBatch.getChildBatchs(), newParams);
            }
            return sortingBatch;
        }
        return null;
    }

    @Override
    public void registerCatchBatchValidator(CatchBatchValidator validator) {
        if (!this.validators.contains(validator)) {
            this.validators.add(validator);
        }
    }

    @Override
    public void unregisterCatchBatchValidator(CatchBatchValidator validator) {
        this.validators.remove(validator);
    }

    @Override
    public void update(CatchBatch catchBatch) {
        super.update(catchBatch);
    }

    @Override
    public void removeWithChildren(Integer batchId) {
        this.removeWithChildren(batchId, null);
    }

    @Override
    public void removeWithChildren(Integer batchId, CatchBatch parentCatchBatch) {
        Iterator childRows = this.queryIteratorTyped("childBatchIds", "parentBatchId", IntegerType.INSTANCE, batchId);
        boolean isCatchBatch = false;
        while (childRows.hasNext()) {
            Object[] childRow = (Object[])childRows.next();
            Integer childBatchId = (Integer)childRow[0];
            Integer rootBatchId = (Integer)childRow[1];
            if (rootBatchId == batchId) {
                isCatchBatch = true;
            }
            this.removeWithChildren(childBatchId, parentCatchBatch);
        }
        if (isCatchBatch) {
            CatchBatch catchBatch = this.load(CatchBatchImpl.class, (Serializable)batchId);
            catchBatch.getQuantificationMeasurements().clear();
            this.getHibernateTemplate().delete((Object)catchBatch);
        } else {
            SortingBatch existingSortingBatch;
            SortingBatch sortingBatch = this.load(SortingBatchImpl.class, (Serializable)batchId);
            sortingBatch.getSortingMeasurements().clear();
            sortingBatch.getQuantificationMeasurements().clear();
            this.getHibernateTemplate().delete((Object)sortingBatch);
            if (parentCatchBatch != null && (existingSortingBatch = parentCatchBatch.getSortingBatchById().get(batchId)) != null) {
                Batch parentBatch = existingSortingBatch.getParentBatch();
                parentCatchBatch.getSortingBatchById().remove(sortingBatch);
                if (parentBatch != null) {
                    parentBatch.getChildBatchs().remove(existingSortingBatch);
                }
            }
        }
    }

    @Override
    public CatchBatch loadFullTreeWithCache(Integer catchBatchId, boolean useCache, boolean forceReload) {
        long time1 = 0L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"call loadFullTreeWithCache()");
            time1 = System.currentTimeMillis();
        }
        Session session = this.getSession(false);
        CatchBatch catchBatch = (CatchBatch)this.queryUniqueTyped("catchBatchOnly", "catchBatchId", IntegerType.INSTANCE, catchBatchId);
        if (catchBatch == null) {
            return null;
        }
        Map<Integer, SortingBatch> sortingBatchById = catchBatch.getSortingBatchById();
        session.evict((Object)catchBatch);
        catchBatch.setChildBatchs(new HashSet<Batch>());
        this.computeTechnicalWeights(catchBatch);
        HashMap<Integer, Integer> parentBatchMapById = new HashMap<Integer, Integer>();
        List list = this.queryListTyped("allBatch", "rootBatchId", IntegerType.INSTANCE, catchBatch.getId());
        Comparator<Batch> batchComparator = new Comparator<Batch>(){

            @Override
            public int compare(Batch b1, Batch b2) {
                return b1.getRankOrder() == null ? 0 : b1.getRankOrder().compareTo(b2.getRankOrder());
            }
        };
        for (SortingBatch source : list) {
            session.evict((Object)source);
            this.computeTechnicalWeights(source);
            source.setChildBatchs(new TreeSet<Batch>(batchComparator));
            Integer parentBatchId = source.getParentBatch().getId();
            sortingBatchById.put(source.getId(), source);
            if (parentBatchId == null) continue;
            parentBatchMapById.put(source.getId(), parentBatchId);
        }
        for (SortingBatch batch : sortingBatchById.values()) {
            Integer parentbatchId = (Integer)parentBatchMapById.get(batch.getId());
            if (parentbatchId == null) continue;
            SortingBatch parentBatch = sortingBatchById.get(parentbatchId);
            if (parentBatch != null) {
                batch.setParentBatch(parentBatch);
                parentBatch.getChildBatchs().add(batch);
                continue;
            }
            if (!parentbatchId.equals(catchBatch.getId())) continue;
            catchBatch.getChildBatchs().add(batch);
        }
        this.applyInheritance(catchBatch.getChildBatchs(), null, null, null, false, 1);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("end of loadFullTreeWithCache() - loading in " + (System.currentTimeMillis() - time1) + " ms."));
        }
        return catchBatch;
    }

    protected void applyInheritance(Collection<Batch> batchs, List<SortingMeasurement> inheritedSortingMeasurements, Integer inheritedTaxonGroupId, Integer inheritedReferenceTaxonId, boolean inheritedExhaustiveInventory, int treeLevel) {
        if (batchs == null || batchs.size() == 0) {
            return;
        }
        for (Batch notCastedBatch : batchs) {
            SortingBatch batch = (SortingBatch)notCastedBatch;
            if (inheritedSortingMeasurements != null && inheritedSortingMeasurements.size() > 0) {
                batch.getInheritedSortingMeasurements().clear();
                batch.getInheritedSortingMeasurements().addAll(inheritedSortingMeasurements);
            }
            if (batch.getReferenceTaxon() == null && inheritedReferenceTaxonId != null) {
                batch.setInheritedReferenceTaxonId(inheritedReferenceTaxonId);
            }
            if (batch.getTaxonGroup() == null && inheritedTaxonGroupId != null) {
                batch.setInheritedTaxonGroupId(inheritedTaxonGroupId);
            }
            if (inheritedExhaustiveInventory) {
                batch.setExhaustiveInventory(inheritedExhaustiveInventory);
            } else {
                batch.setExhaustiveInventory(false);
            }
            batch.setTreeLevel((short)treeLevel);
            if (batch.getChildBatchs() == null || batch.getChildBatchs().size() <= 0) continue;
            ArrayList newInheritedSortingMeasurement = Lists.newArrayList();
            if (inheritedSortingMeasurements != null) {
                newInheritedSortingMeasurement.addAll(inheritedSortingMeasurements);
            }
            newInheritedSortingMeasurement.addAll(batch.getSortingMeasurements());
            this.applyInheritance(batch.getChildBatchs(), newInheritedSortingMeasurement, batch.getTaxonGroup() == null ? null : batch.getTaxonGroup().getId(), batch.getReferenceTaxon() == null ? null : batch.getReferenceTaxon().getId(), batch.getExhaustiveInventory(), treeLevel + 1);
        }
    }

    protected void applyInheritanceOnOneChild(SortingBatch parentBatch, SortingBatch batchToUpdate) {
        short treeLevel = parentBatch.getTreeLevel();
        if (parentBatch.getChildBatchs() != null && parentBatch.getChildBatchs().size() > 0) {
            ArrayList newInheritedSortingMeasurement = Lists.newArrayList();
            if (parentBatch.getInheritedSortingMeasurements() != null) {
                newInheritedSortingMeasurement.addAll(parentBatch.getInheritedSortingMeasurements());
            }
            newInheritedSortingMeasurement.addAll(parentBatch.getSortingMeasurements());
            this.applyInheritance(Lists.newArrayList((Object[])new Batch[]{batchToUpdate}), newInheritedSortingMeasurement, parentBatch.getTaxonGroup() == null ? null : parentBatch.getTaxonGroup().getId(), parentBatch.getReferenceTaxon() == null ? null : parentBatch.getReferenceTaxon().getId(), parentBatch.getExhaustiveInventory(), treeLevel + 1);
        }
    }

    protected void computeTechnicalWeights(Batch batch) {
        Float weight = null;
        for (QuantificationMeasurement qm : batch.getQuantificationMeasurements()) {
            if (!qm.getIsReferenceQuantification().booleanValue()) continue;
            weight = qm.getNumericalValue();
            batch.setWeightMethodId(qm.getPmfm().getMethod().getId());
        }
        if (weight == null) {
            return;
        }
        if (batch instanceof SortingBatch) {
            SortingBatch sortingBatch = (SortingBatch)batch;
            String samplingRatioText = sortingBatch.getSamplingRatioText();
            Float samplingRatio = sortingBatch.getSamplingRatio();
            String startStr = weight.toString().replace(',', '.') + "/";
            if (samplingRatioText != null && samplingRatioText.startsWith(startStr)) {
                String weightStr = samplingRatioText.substring(startStr.length());
                if (weightStr != null && !weightStr.isEmpty()) {
                    batch.setWeightBeforeSampling(Float.valueOf(Float.parseFloat(weightStr)));
                }
            } else if (samplingRatio != null) {
                batch.setWeightBeforeSampling(Float.valueOf(weight.floatValue() / samplingRatio.floatValue()));
            }
            batch.setWeight(weight);
        } else if (batch instanceof CatchBatch) {
            CatchBatch catchBatch = (CatchBatch)batch;
            catchBatch.setWeight(weight);
        }
    }

    protected Integer getCatchBatchIdByBatchId(String batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer catchBatchId = (Integer)this.queryUniqueTyped("rootBatchId", "batchId", IntegerType.INSTANCE, Integer.valueOf(batchId));
        if (catchBatchId == null) {
            throw new DataRetrievalFailureException("Unable to retrieve root catch batch for batch id=" + batchId);
        }
        return catchBatchId;
    }

    @Override
    public Integer getIdByFishingOperationId(Integer fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = (Integer)this.queryUniqueTyped("fishingOperationCatchBatchId", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
        if (catchBatchId == null) {
            throw new DataRetrievalFailureException("Unable to retrieve catch batch for fishing operation id=" + fishingOperationId);
        }
        return catchBatchId;
    }

    @Override
    public Integer getIdBySortingBatchId(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer catchBatchId = (Integer)this.queryUniqueTyped("rootBatchId", "sortingBatchId", IntegerType.INSTANCE, batchId);
        if (catchBatchId == null) {
            throw new DataRetrievalFailureException("Unable to retrieve root catch batch for batch id=" + batchId);
        }
        return catchBatchId;
    }

    @Override
    public SortingBatch getSortingBatchById(CatchBatch catchBatch, Integer sortingBatchId) {
        Preconditions.checkNotNull((Object)catchBatch);
        Preconditions.checkNotNull((Object)sortingBatchId);
        Preconditions.checkNotNull(catchBatch.getSortingBatchById());
        SortingBatch sortingBatch = catchBatch.getSortingBatchById().get(sortingBatchId);
        if (sortingBatch == null) {
            throw new DataRetrievalFailureException("Could not found batch with id=" + sortingBatchId + " in the batch tree elements. Make sure the cache has been cleaned, since the last update of the tree.");
        }
        return sortingBatch;
    }

    @Override
    public QuantificationMeasurement setQuantificationMeasurement(Batch batch, Integer pmfmId, Integer recorderDepartmentId, Float weightValue, boolean isReferenceQuantitification) {
        QuantificationMeasurement quantificationMeasurement = this.getQuantificationMeasurement(batch, pmfmId, recorderDepartmentId, true);
        quantificationMeasurement.setNumericalValue(weightValue);
        quantificationMeasurement.setIsReferenceQuantification(isReferenceQuantitification);
        return quantificationMeasurement;
    }

    @Override
    public QuantificationMeasurement getQuantificationMeasurement(Batch batch, Integer pmfmId, Integer recorderDepartmentId, boolean createIfNotExists) {
        QuantificationMeasurement quantificationMeasurement = null;
        if (batch.getQuantificationMeasurements() != null) {
            for (QuantificationMeasurement qm : batch.getQuantificationMeasurements()) {
                if (!pmfmId.equals(qm.getPmfm().getId())) continue;
                quantificationMeasurement = qm;
                break;
            }
        }
        if (quantificationMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            quantificationMeasurement = QuantificationMeasurement.Factory.newInstance();
            quantificationMeasurement.setBatch(batch);
            if (batch.getQuantificationMeasurements() == null) {
                batch.setQuantificationMeasurements(Sets.newHashSet((Object[])new QuantificationMeasurement[]{quantificationMeasurement}));
            } else {
                batch.getQuantificationMeasurements().add(quantificationMeasurement);
            }
            quantificationMeasurement.setQualityFlag(this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            quantificationMeasurement.setDepartment(this.load(DepartmentImpl.class, (Serializable)recorderDepartmentId));
            quantificationMeasurement.setPmfm(this.load(PmfmImpl.class, (Serializable)pmfmId));
        }
        return quantificationMeasurement;
    }

    @Override
    public SortingMeasurement getSortingMeasurement(SortingBatch sortingBatch, Integer pmfmId, Integer recorderDepartmentId, boolean createIfNotExists) {
        SortingMeasurement sortingMeasurement = null;
        if (sortingBatch.getSortingMeasurements() != null) {
            for (SortingMeasurement qm : sortingBatch.getSortingMeasurements()) {
                if (!pmfmId.equals(qm.getPmfm().getId())) continue;
                sortingMeasurement = qm;
                break;
            }
        }
        if (sortingMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            sortingMeasurement = SortingMeasurement.Factory.newInstance();
            sortingMeasurement.setSortingBatch(sortingBatch);
            if (sortingBatch.getSortingMeasurements() == null) {
                sortingBatch.setSortingMeasurements(Sets.newHashSet((Object[])new SortingMeasurement[]{sortingMeasurement}));
                sortingMeasurement.setRankOrder(1);
            } else {
                sortingBatch.getSortingMeasurements().add(sortingMeasurement);
                sortingMeasurement.setRankOrder(sortingBatch.getSortingMeasurements().size());
            }
            sortingMeasurement.setQualityFlag(this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            sortingMeasurement.setDepartment(this.load(DepartmentImpl.class, (Serializable)recorderDepartmentId));
            sortingMeasurement.setPmfm(this.load(PmfmImpl.class, (Serializable)pmfmId));
        }
        return sortingMeasurement;
    }

    @Override
    public SortingMeasurement getInheritedSortingMeasurement(SortingBatch sortingBatch, Integer pmfmId) {
        if (sortingBatch.getInheritedSortingMeasurements() != null) {
            for (SortingMeasurement qm : sortingBatch.getInheritedSortingMeasurements()) {
                if (!pmfmId.equals(qm.getPmfm().getId())) continue;
                return qm;
            }
        }
        return null;
    }

    @Override
    public SortingBatch createSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
        SortingBatch result = this.sortingBatchDao.create(sortingBatch);
        return result;
    }

    @Override
    public SortingBatch loadSortingBatch(Integer sortingBatchId, CatchBatch parentCatchBatch) {
        SortingBatch result = parentCatchBatch.getSortingBatchById().get(sortingBatchId);
        if (result == null) {
            result = this.sortingBatchDao.load(sortingBatchId);
        }
        return result;
    }

    @Override
    public void updateSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
        this.sortingBatchDao.update(sortingBatch);
    }

    @Override
    public void updateSortingBatch(List<SortingBatch> sortingBatchs, CatchBatch parentCatchBatch) {
        this.sortingBatchDao.update(sortingBatchs);
    }

    protected void refreshSortingBatchInBatchTree(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
        SortingBatch existingSortingbatch;
        Preconditions.checkNotNull((Object)sortingBatch);
        Preconditions.checkNotNull((Object)sortingBatch.getId());
        Preconditions.checkNotNull((Object)sortingBatch.getParentBatch());
        Preconditions.checkNotNull((Object)sortingBatch.getParentBatch().getId());
        Preconditions.checkNotNull((Object)parentCatchBatch);
        Preconditions.checkNotNull((Object)parentCatchBatch.getId());
        Integer parentBatchId = sortingBatch.getParentBatch().getId();
        Batch parentBatch = null;
        parentBatch = parentBatchId.equals(parentCatchBatch.getId()) ? parentCatchBatch : (Batch)parentCatchBatch.getSortingBatchById().get(parentBatchId);
        if (parentBatch == null) {
            this.refreshSortingBatchInBatchTree((SortingBatch)sortingBatch.getParentBatch(), parentCatchBatch);
            parentBatch = sortingBatch.getParentBatch();
        } else if (sortingBatch.getParentBatch() != parentBatch) {
            sortingBatch.setParentBatch(parentBatch);
        }
        if (!parentBatch.getChildBatchs().contains(sortingBatch)) {
            parentBatch.getChildBatchs().add(sortingBatch);
        }
        if (parentBatch instanceof SortingBatch) {
            this.applyInheritanceOnOneChild((SortingBatch)parentBatch, sortingBatch);
        }
        if ((existingSortingbatch = parentCatchBatch.getSortingBatchById().get(sortingBatch.getId())) == null || existingSortingbatch != sortingBatch) {
            parentCatchBatch.getSortingBatchById().put(sortingBatch.getId(), existingSortingbatch);
        }
        this.computeTechnicalWeights(sortingBatch);
    }

    @Override
    public void setSortingBatchReferenceTaxon(String batchId, Integer referenceTaxonId) {
        int rowUpdated;
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)referenceTaxonId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Changing reference taxon for batch id=" + batchId));
        }
        Preconditions.checkArgument(((rowUpdated = this.queryUpdate("updateSortingBatchReferenceTaxon", "sortingBatchId", IntegerType.INSTANCE, Integer.valueOf(batchId), "referenceTaxonId", IntegerType.INSTANCE, referenceTaxonId)) == 1 ? 1 : 0) != 0, (Object)"Unable to update batc reference taxon.");
    }
}

