package fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class MacroWasteBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<MacroWasteBatchUIModel, MacroWasteBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_MODEL = "macroWasteTotalWeightField.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vz28bRRQeG9uJ04ZAo4ZAg9SmAjUCjXPiQCpo7NqNg+NasUsifDBj79ieZLyzzMw2G1lB/An8CXDngsSNE+LAmQMXxL+AEAeuiDezttduNnUlGikr78x73/v1vW+/+xOllUR3TkgQYOm7mg0o3t89Pn7cPqEd/ZCqjmSeFhKFf4kkSjbRNWdyrjS626wY99zIPVcQA0+41J3y3qmgJaXPOVV9SrVGb896dJTK1SfXO4HnyzHqJKk41G/+/iv5tfPVt0mEAg+yW4JSbs/ziipJVVCSORrdgEhPSY4TtwdpSOb2IN9lc1bgRKkqGdAv0JdooYIyHpEAptHmi5dsMax/4Gl0izpMH5COFEdEaZonutNvCK9GXMo1qnUlZl1JB1Ri7WvNsM+wOoOMcEe4GgJg4VFJNBMu7hhfqvDAoJ0ZNPwM8JOy59nQGY0W+sR1OJUaHb3sIHshchQrPRCOKefJy450YHCjONmnhDOHQLc1em9m7pOLUbi6eX46PowQMm0pTk1Ttq5OtWFe9yBu3tpGzqmukAON1mcij3xIm1vSZCfWbw0m1TSEJvyIsl5fV0jbdOqGYVswct63h8ZtfY53iVEOBH43JgPDMyi/6g/aVBbtyyziijY51gGVc0M/jd6YSSK6ma0jbf2AyUL28AkowakWXugU4P3jSeV3PNjGWzOZwZ7jaM+jRUw0UVr6cAzNbF6WhkO4CkVh/RlRMID29t+11d9+/OOH0lgJMhD7ZqzplJDBhnrSEFAzE3ollAFfM547IN5OE2UV5aCCVuU2YhKrj64hOYj3unHHxh3vEdUHiPTC7z/9vPb5r6+gZAktcUGcEjH2ZZTVfQldENwJvI8f2Iyuny3C8zX4TwG12pS4sLRDu0kXQHXia1ETng8akhuOdhn3qC4It8t697YwU7tjk+mh39sy3hDq7JAqo70pLX1o/oo5stZ54DdsI9q+ArYOhtOIoT3gBjCRjZiJTNrSzv7yz2r9+wfjqSSgS29eaR5NJv0ZyjCXM5dahR6Jb6wiX/MU9R0RiWyc7CJo2vXpEkY7/L59bl8aQAJY3urDxsNqDTetHJg3HKPd2FxsQisM0oe2RvPrPnq+1HtzMkhqtMiNCpSMtm0Mr97+CzNRGsBgt0PdMlELJlaYX9cY4Vj/uKSfo1Lzck5Fwr8Z8tYQ6SAOz5Jy2bUTqRGtqQT+rQ3L1Ubrg9bD8qNyo96q7TYaxcMqGC76ipZge6DGdJdwYDFaHC3uuUY3/2dttosvUNtyKAbwqTJfIY3eGVaY0vXpQ47r5eqjSrFVL1aKhUb5sc1ewQhDyRxnvzqBgvHSnhS+Cyq+PCwIDpKdr+wWPrmYtsqTzunYKjN0fc5jCRcq87xSgNwZTs4FkAW9eh++h+R2m7kOyPdHl0AT5rkEiP8ByOlsOygKAAA=";
    private static final Log log = LogFactory.getLog(MacroWasteBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected MacroWasteBatchUI editMacroWasteBatchTopPanel = this;
    protected Table form;
    protected MacroWasteBatchUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "macroWasteTotalWeight",  editorName = "macroWasteTotalWeightField")
    protected NumberEditor macroWasteTotalWeightField;
    protected JLabel macroWasteTotalWeightLabel;
    protected MacroWasteBatchUIModel model;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<MacroWasteBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MacroWasteBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            MacroWasteBatchUIHandler handler = new MacroWasteBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public MacroWasteBatchUI() {
        $initialize();
    }

    public MacroWasteBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MacroWasteBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MacroWasteBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MacroWasteBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MacroWasteBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MacroWasteBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MacroWasteBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public Table getForm() {
        return form;
    }

    public MacroWasteBatchUIHandler getHandler() {
        return handler;
    }

    public NumberEditor getMacroWasteTotalWeightField() {
        return macroWasteTotalWeightField;
    }

    public JLabel getMacroWasteTotalWeightLabel() {
        return macroWasteTotalWeightLabel;
    }

    public MacroWasteBatchUIModel getModel() {
        return model;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<MacroWasteBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditMacroWasteBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(macroWasteTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(macroWasteTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editMacroWasteBatch.help"));
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MacroWasteBatchUIHandler.class));
    }

    protected void createMacroWasteTotalWeightField() {
        $objectMap.put("macroWasteTotalWeightField", macroWasteTotalWeightField = new NumberEditor(this));
        
        macroWasteTotalWeightField.setName("macroWasteTotalWeightField");
        macroWasteTotalWeightField.setProperty("macroWasteTotalWeight");
        macroWasteTotalWeightField.setUseFloat(false);
        macroWasteTotalWeightField.setShowReset(true);
    }

    protected void createMacroWasteTotalWeightLabel() {
        $objectMap.put("macroWasteTotalWeightLabel", macroWasteTotalWeightLabel = new JLabel());
        
        macroWasteTotalWeightLabel.setName("macroWasteTotalWeightLabel");
        macroWasteTotalWeightLabel.setText(_("tutti.editCatchBatch.field.macroWasteTotalWeight"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(MacroWasteBatchUIModel.class));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MacroWasteBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditMacroWasteBatchTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToTableScrollPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        macroWasteTotalWeightLabel.setLabelFor(macroWasteTotalWeightField);
        macroWasteTotalWeightField.setBean(model);
        macroWasteTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        macroWasteTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
        macroWasteTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editMacroWasteBatchTopPanel, "tuttihelp.editMacroWasteBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editMacroWasteBatchTopPanel", editMacroWasteBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createForm();
        createMacroWasteTotalWeightLabel();
        createMacroWasteTotalWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of editMacroWasteBatchTopPanel
        setName("editMacroWasteBatchTopPanel");
        setLayout(new BorderLayout());
        editMacroWasteBatchTopPanel.putClientProperty("help", "tuttihelp.editMacroWasteBatch.help");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("macroWasteTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    macroWasteTotalWeightField.setModel(model.getMacroWasteTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("macroWasteTotalWeight", this);
                }
            }
        });
    }

}