package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProgramUIHandler.java 631 2013-03-15 10:59:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/program/EditProgramUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * Handler of UI {@link EditProgramUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditProgramUIHandler extends AbstractTuttiUIHandler<EditProgramUIModel, EditProgramUI> implements CloseableUI {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditProgramUIHandler.class);

    public static String getTitle(boolean exist) {

        String result;
        if (exist) {
            result = _("tutti.editProgram.title.edit.program");
        } else {
            result = _("tutti.editProgram.title.create.program");
        }
        return result;
    }

    /**
     * Persistence service.
     *
     * @since 0.1
     */
    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUI parentUi, EditProgramUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.persistenceService = context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {

        EditProgramUIModel model = new EditProgramUIModel();

        List<Program> programs =
                Lists.newArrayList(persistenceService.getAllProgram());

        model.setExistingPrograms(programs);

        String programId = context.getProgramId();
        if (programId == null) {

            if (log.isInfoEnabled()) {
                log.info("Edit new program");
            }
        } else {

            if (log.isInfoEnabled()) {
                log.info("Edit existing program " + programId);
            }
            // load existing program
            Program program = persistenceService.getProgram(programId);

            model.fromBean(program);

            model.getExistingPrograms().remove(program);
        }

        listModelIsModify(model);

        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        EditProgramUIModel model = getModel();
        initBeanFilterableComboBox(ui.getZoneComboBox(),
                                   persistenceService.getAllProgramZone(),
                                   model.getZone());

        SwingValidator validator = ui.getValidator();
        listenValidatorValid(validator, model);

        registerValidators(validator);

        // if new program can already cancel his creation
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
        clearValidators();
    }

    @Override
    public boolean quitUI() {
        boolean result = quitScreen(
                getModel().isValid(),
                getModel().isModify(),
                _("tutti.editProgram.askCancelEditBeforeLeaving.cancelSaveProgram"),
                _("tutti.editProgram.askSaveBeforeLeaving.saveProgram"),
                ui.getSaveButton().getAction()
        );
        return result;
    }

    @Override
    public SwingValidator<EditProgramUIModel> getValidator() {
        return ui.getValidator();
    }

}
