package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveCruiseAction.java 629 2013-03-15 09:48:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/SaveCruiseAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

import static org.nuiton.i18n.I18n._;

/**
 * Saves a cruise
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SaveCruiseAction extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {

    public SaveCruiseAction(EditCruiseUIHandler handler) {
        super(handler, true);
    }

    /**
     * If the event source is a TuttiScreen, then the screen changes to the source.
     * Otherwise, the screen changes to the home.
     */
    @Override
    protected void doAction() throws Exception {
        TuttiUIContext context = getContext();
        EditCruiseUIModel model = getModel();
        PersistenceService persistenceService =
                getContext().getPersistenceService();

        Cruise bean = model.toBean();

        Cruise saved;
        if (TuttiEntities.isNew(bean)) {

            saved = persistenceService.createCruise(bean);
            model.setId(saved.getId());
            sendMessage(_("tutti.flash.info.cruiseCreated", bean.getName()));
        } else {
            saved = persistenceService.saveCruise(bean);
            sendMessage(_("tutti.flash.info.cruiseSaved", bean.getName()));
        }

        context.setProgramId(saved.getProgram().getId());
        context.setCruiseId(saved.getId());

        model.setModify(false);
    }

    @Override
    public void postSuccessAction() {

        getContext().getMainUI().getHandler().setBodyTitle(
                EditCruiseUIHandler.getTitle(true));

    }
}
