package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCruiseUIModel.java 534 2013-03-05 10:45:23Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/EditCruiseUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Model of UI {@link EditCruiseUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditCruiseUIModel extends AbstractTuttiBeanUIModel<Cruise, EditCruiseUIModel> implements AttachmentModelAware {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_PROGRAM = "program";

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_COUNTRY = "country";

    public static final String PROPERTY_SURVEY_PART = "surveyPart";

    public static final String PROPERTY_VESSEL = "vessel";

    public static final String PROPERTY_GEAR = "gear";

    public static final String PROPERTY_HEAD_OF_MISSION = "headOfMission";

    public static final String PROPERTY_HEAD_OF_SORT_ROOM = "headOfSortRoom";

    public static final String PROPERTY_YEAR = "year";

    public static final String PROPERTY_MULTIRIG_NUMBER = "multirigNumber";

    public static final String PROPERTY_BEGIN_DATE = "beginDate";

    public static final String PROPERTY_END_DATE = "endDate";

    public static final String PROPERTY_CAN_GENERATE_NAME = "canGenerateName";

    public static final String PROPERTY_VESSEL_TYPE = "vesselType";

    public static final String PROPERTY_VESSEL_TYPE_ALL = "vesselTypeAll";

    public static final String PROPERTY_VESSEL_TYPE_SCIENTIFIC = "vesselTypeScientific";

    public static final String PROPERTY_VESSEL_TYPE_FISHING = "vesselTypeFishing";

    protected Program program;

    protected Country country;

    protected String name;

    protected String surveyPart;

    protected List<Vessel> vessel;

    protected List<Gear> gear;

    protected List<Person> headOfMission;

    protected List<Person> headOfSortRoom;

    protected String comment;

    protected Integer year;

    protected Integer multirigNumber;

    protected Date beginDate;

    protected Date endDate;

    protected VesselTypeEnum vesselType;

    protected final List<Attachment> attachment = Lists.newArrayList();

    protected static Binder<EditCruiseUIModel, Cruise> toBeanBinder =
            BinderFactory.newBinder(EditCruiseUIModel.class,
                                    Cruise.class);

    protected static Binder<Cruise, EditCruiseUIModel> fromBeanBinder =
            BinderFactory.newBinder(Cruise.class, EditCruiseUIModel.class);

    public EditCruiseUIModel() {
        super(Cruise.class, fromBeanBinder, toBeanBinder);
    }

    public Program getProgram() {
        return program;
    }

    public void setProgram(Program program) {
        Object oldValue = getProgram();
        this.program = program;
        firePropertyChange(PROPERTY_PROGRAM, oldValue, program);
        firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, isCanGenerateName());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        Object oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public Country getCountry() {
        return country;
    }

    public void setCountry(Country country) {
        Object oldValue = getCountry();
        this.country = country;
        firePropertyChange(PROPERTY_COUNTRY, oldValue, country);
    }

    public String getSurveyPart() {
        return surveyPart;
    }

    public void setSurveyPart(String surveyPart) {
        Object oldValue = getSurveyPart();
        this.surveyPart = surveyPart;
        firePropertyChange(PROPERTY_SURVEY_PART, oldValue, surveyPart);
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        Object oldValue = getYear();
        this.year = year;
        firePropertyChange(PROPERTY_YEAR, oldValue, year);
        firePropertyChange(PROPERTY_CAN_GENERATE_NAME, null, isCanGenerateName());
    }

    public Integer getMultirigNumber() {
        return multirigNumber;
    }

    public void setMultirigNumber(Integer multirigNumber) {
        Object oldValue = getMultirigNumber();
        this.multirigNumber = multirigNumber;
        firePropertyChange(PROPERTY_MULTIRIG_NUMBER, oldValue, multirigNumber);
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        Object oldValue = getBeginDate();
        this.beginDate = beginDate;
        firePropertyChange(PROPERTY_BEGIN_DATE, oldValue, beginDate);
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        Object oldValue = getEndDate();
        this.endDate = endDate;
        firePropertyChange(PROPERTY_END_DATE, oldValue, endDate);
    }

    public List<Vessel> getVessel() {
        return vessel;
    }

    public void setVessel(List<Vessel> vessel) {
        this.vessel = vessel;
        firePropertyChange(PROPERTY_VESSEL, null, vessel);
    }

    public List<Gear> getGear() {
        return gear;
    }

    public void setGear(List<Gear> gear) {
        this.gear = gear;
        firePropertyChange(PROPERTY_GEAR, null, gear);
    }

    public List<Person> getHeadOfMission() {
        return headOfMission;
    }

    public void setHeadOfMission(List<Person> headOfMission) {
        this.headOfMission = headOfMission;
        firePropertyChange(PROPERTY_HEAD_OF_MISSION, null, headOfMission);
    }

    public List<Person> getHeadOfSortRoom() {
        return headOfSortRoom;
    }

    public void setHeadOfSortRoom(List<Person> headOfSortRoom) {
        this.headOfSortRoom = headOfSortRoom;
        firePropertyChange(PROPERTY_HEAD_OF_SORT_ROOM, null, headOfSortRoom);
    }

    public VesselTypeEnum getVesselType() {
        return vesselType;
    }

    public void setVesselType(VesselTypeEnum vesselType) {
        boolean oldAll = isVesselTypeAll();
        boolean oldScientific = isVesselTypeScientific();
        boolean oldFishing = isVesselTypeFishing();
        Object oldValue = getVesselType();
        this.vesselType = vesselType;
        firePropertyChange(PROPERTY_VESSEL_TYPE, oldValue, vesselType);
        firePropertyChange(PROPERTY_VESSEL_TYPE_ALL, oldAll, isVesselTypeAll());
        firePropertyChange(PROPERTY_VESSEL_TYPE_SCIENTIFIC, oldScientific, isVesselTypeScientific());
        firePropertyChange(PROPERTY_VESSEL_TYPE_FISHING, oldFishing, isVesselTypeFishing());

    }

    public boolean isVesselTypeAll() {
        return VesselTypeEnum.ALL.equals(vesselType);
    }

    public boolean isVesselTypeScientific() {
        return VesselTypeEnum.SCIENTIFIC.equals(vesselType);
    }

    public boolean isVesselTypeFishing() {
        return VesselTypeEnum.FISHING.equals(vesselType);
    }

    public boolean isCanGenerateName() {
        return program != null && year != null;
    }

    public static final String CRUISE_NAME_FORMAT = "%1$s_%2$s";

    public String getGeneratedCampaignName() {
        String result = String.format(CRUISE_NAME_FORMAT, program.getName(), year);
        if (StringUtils.isNotEmpty(surveyPart)) {
            result += "_" + surveyPart;
        }
        return result;
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SCIENTIFIC_CRUISE;
    }

    @Override
    public String getObjectId() {
        return getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }
}