/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;

    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, "removeSpeciesProtocol", "batch-delete", I18n._((String)"tutti.action.removeSpeciesProtocol", (Object[])new Object[0]), I18n._((String)"tutti.action.removeSpeciesProtocol.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected void doAction(ActionEvent event) {
        EditProtocolUIHandler handler = (EditProtocolUIHandler)this.getHandler();
        int rowIndex = handler.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove species if no species selected");
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.getHandler()).getTableModel();
        EditProtocolSpeciesRowModel selectedRow = (EditProtocolSpeciesRowModel)((Object)tableModel.getEntry(rowIndex));
        Integer taxonId = selectedRow.getSpecies().getReferenceTaxonId();
        Collection<Species> allSynonyms = ((EditProtocolUIModel)((Object)this.getModel())).getAllSynonyms(String.valueOf(taxonId));
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().getData().addAll(allSynonyms);
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().getHandler().sortData();
        tableModel.removeRow(rowIndex);
        String speciesStr = this.getDecorator(Species.class, "byCruiseCode").toString((Object)selectedRow.getSpecies());
        this.sendMessage(I18n._((String)"tutti.flash.information.species.remove.from.protocol", (Object[])new Object[]{speciesStr}));
    }
}

