/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import java.awt.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveCatchBatchAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SaveCatchBatchAction.class);
    protected boolean updateUI;

    public SaveCatchBatchAction(EditCatchesUIHandler handler) {
        super(handler, "saveCatchBatch", "save", I18n._((String)"tutti.action.saveCatchBatch", (Object[])new Object[0]), I18n._((String)"tutti.action.saveCatchBatch.tip", (Object[])new Object[0]), true);
    }

    public void setUpdateUI(boolean updateUI) {
        this.updateUI = updateUI;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        this.updateUI = true;
        super.releaseAction(event);
    }

    @Override
    protected void doAction(ActionEvent event) {
        boolean mustSave;
        EditCatchesUIHandler handler = (EditCatchesUIHandler)this.getHandler();
        TuttiBeanMonitor<EditCatchesUIModel> monitor = handler.getCatchBatchMonitor();
        EditCatchesUIModel beanToSave = monitor.getBean();
        boolean bl = mustSave = (beanToSave.isCreate() || beanToSave.isModify()) && beanToSave.isValid();
        if (mustSave) {
            PersistenceService persistenceService = this.getService(PersistenceService.class);
            CatchBatch catchBatch = (CatchBatch)beanToSave.toBean();
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + catchBatch.getId() + " was modified, will save it."));
            }
            ((EditCatchesUIHandler)this.getHandler()).showInformationMessage("[ Captures - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications du r\u00e9sum\u00e9 de la capture.");
            persistenceService.saveCatchBatch(catchBatch);
            monitor.clearModified();
            ((EditCatchesUIModel)((Object)this.getModel())).setModify(false);
        }
        ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getHandler().clearTableSelection();
    }
}

