/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;

public class TuttiActionUIHandler
extends AbstractTuttiUIHandler<TuttiActionUIModel, TuttiActionUI> {
    private static final Log log = LogFactory.getLog(TuttiActionUIHandler.class);
    protected PropertyChangeListener progressionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("message".equals(propertyName)) {
                ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskActionLabel().setText((String)evt.getNewValue());
            } else if ("total".equals(propertyName)) {
                ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskProgressBar().setMaximum((Integer)evt.getNewValue());
            } else if ("message".equals(propertyName)) {
                ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskProgressBar().setValue((Integer)evt.getNewValue());
            }
        }
    };

    public TuttiActionUIHandler(TuttiUIContext context, TuttiActionUI ui) {
        super(context, ui);
    }

    protected void hideAction() {
        ((TuttiActionUIModel)((Object)this.getModel())).setProgressionModel(null);
        ((TuttiActionUI)this.ui).setVisible(false);
    }

    @Override
    public void beforeInitUI() {
        TuttiActionUIModel model = new TuttiActionUIModel();
        ((TuttiActionUI)this.ui).setContextValue(model);
        model.addPropertyChangeListener("action", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiAction action = (AbstractTuttiAction)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Action to use: " + action));
                }
                if (action == null || action.isFailed()) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        TuttiActionUIHandler.this.hideAction();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TuttiActionUIHandler.this.hideAction();
                            }
                        });
                    }
                } else {
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).getGlobalActionLabel().setText(I18n._((String)"tutti.message.action.running", (Object[])new Object[]{action.getActionDescription()}));
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).pack();
                    MainUI mainUI = TuttiActionUIHandler.this.getContext().getMainUI();
                    if (mainUI != null) {
                        JXTitledPanel component = mainUI.getBody();
                        int x = mainUI.getX() + (mainUI.getWidth() - component.getWidth());
                        int y = mainUI.getY() + (mainUI.getHeight() - component.getHeight());
                        ((TuttiActionUI)TuttiActionUIHandler.this.ui).setLocation(x, y);
                    }
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).setVisible(true);
                }
            }
        });
        model.addPropertyChangeListener("progressionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProgressionModel oldValue = (ProgressionModel)((Object)evt.getOldValue());
                ProgressionModel newValue = (ProgressionModel)((Object)evt.getNewValue());
                if (log.isInfoEnabled()) {
                    log.info((Object)("progression model: " + (Object)((Object)newValue)));
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(TuttiActionUIHandler.this.progressionListener);
                }
                if (newValue == null) {
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskPanel().setVisible(false);
                } else {
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskPanel().setVisible(true);
                    newValue.addPropertyChangeListener(TuttiActionUIHandler.this.progressionListener);
                }
            }
        });
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<TuttiActionUIModel> getValidator() {
        return null;
    }

    public void closeAction() {
        ((TuttiActionUIModel)((Object)this.getModel())).clear();
    }
}

