/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportTemporaryGearExampleAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExportTemporaryGearExampleAction.class);
    private File file;

    public ExportTemporaryGearExampleAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, "exportTemporaryGearExample", "export", I18n._((String)"tutti.action.exportTemporaryGearExample", (Object[])new Object[0]), I18n._((String)"tutti.action.exportTemporaryGearExample.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.exportTemporaryGearExampleFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseReferentialGearFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export example gears temporary referential to file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getService(TuttiReferentialImportExportService.class);
        service.exportTemporaryGearExample(this.file);
        this.sendMessage("Exemple de r\u00e9f\u00e9rentiel temporaire d'engins export\u00e9 dans le fichier " + this.file + ".");
    }
}

