/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.ezware.oxbow.swingbits.table.filter.IFilterChangeListener;
import com.ezware.oxbow.swingbits.table.filter.ITableFilter;
import com.ezware.oxbow.swingbits.table.filter.JTableFilter;
import com.ezware.oxbow.swingbits.table.filter.TableRowFilterSupport;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.sort.TableSortController;

public abstract class AbstractTuttiBatchTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiBatchUIModel<R, M>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiTableUIHandler<R, M, UI> {
    private static final Log log = LogFactory.getLog(AbstractTuttiBatchTableUIHandler.class);

    public abstract void selectFishingOperation(FishingOperation var1);

    protected AbstractTuttiBatchTableUIHandler(TuttiUI<?, ?> parentUi, UI ui, String ... properties) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui, properties);
    }

    public final void saveSelectedRowIfRequired(FocusEvent event) {
        Component oppositeComponent = event.getOppositeComponent();
        JXTable parentContainer = null;
        if (oppositeComponent != null) {
            parentContainer = (JXTable)SwingUtil.getParentContainer((Object)oppositeComponent, JXTable.class);
        }
        if (parentContainer == null && ((AbstractTuttiBatchUIModel)this.getModel()).getFishingOperation() != null) {
            this.saveSelectedRowIfNeeded();
        }
    }

    public final void clearTableSelection() {
        JXTable table = this.getTable();
        if (table.isEditing()) {
            table.editingCanceled(null);
        }
        table.clearSelection();
    }

    protected void initBatchTable(JXTable table, TableColumnModel columnModel, AbstractTuttiTableModel<R> tableModel) {
        this.installTableKeyListener(columnModel, (JTable)table);
        JTableFilter tableFilter = new JTableFilter((JTable)table);
        TableRowFilterSupport.forFilter((ITableFilter)tableFilter).searchable(true).useTableRenderers(true).actions(true).apply();
        tableFilter.addChangeListener(new IFilterChangeListener(){

            public void filterChanged(ITableFilter<?> filter) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Filter changed " + filter));
                }
                TableModel model = filter.getTable().getModel();
                int columnCount = model.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    if (!filter.isFiltered(i)) continue;
                    Collection filterState = filter.getFilterState(i);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Column " + i + " is filtered: " + filterState));
                }
            }
        });
        TableSortController sorter = new TableSortController(tableModel);
        sorter.setSortable(false);
        table.setRowSorter((RowSorter)sorter);
        this.initTable(table);
    }
}

