package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiComputedOrNotDataEditor extends NumberEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DECIMAL_NUMBER = "decimalNumber";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVSyUoDQRAtBxNFibiACCK4nTtePHlyRWVIQD0Ic+pkKknLLG13tY4X8RP8BL179OZ3ePMXRPwBsWfGZFwCCs6xqt42/e6eoaQVLJzwJGHKRCRCZPvrx8f1xgk2aQt1UwlJsYL8G3DA8WDU7801wZLnpvDqB7y6GYcyjjD6hF5zYUTTRYC6g0gEc18RTa2rh731WiKN6rL2TPVjvXl9ca79q1sHIJHWXRpl/jdUkWTQBUf4BJNW6YxXAx61rQ0lorb1W0lnmwHXusZDPIVLGHKhLLmyZASLf4+ccWT4RBKMLddM2EC17Qt7tEKw0VJMtBSGqBgZIsGMYPrcmmCGRMAwO2RH6SqVMYR+XdVi2uLEcxYpM/4ywbBUsURFFwTjqX+WZmJ5puJqsIE8Ilj9Rbm/ZEEz1OGRH1g12Pt/ht2cq2Cv+NgUIQ/y30UwUeTZiwjb2a2C2S/PbYvEiiIVLz3gQUkZOyaY8X5278Cu8tbNfGtdSpht36anHh+e7ne6VYN3oiqN5DoDAAA=";
    private static final Log log = LogFactory.getLog(TuttiComputedOrNotDataEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Integer decimalNumber;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TuttiComputedOrNotDataEditor $NumberEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProperty(String property) {
            // cannot change the property
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiComputedOrNotDataEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TuttiComputedOrNotDataEditor() {
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public TuttiComputedOrNotData<?> getBean() {
        return (TuttiComputedOrNotData<?>) super.getBean();
    }

    public Integer getDecimalNumber() {
        return decimalNumber;
    }

    @Override
    public TuttiComputedOrNotDataEditorHandler getHandler() {
        return (TuttiComputedOrNotDataEditorHandler) super.getHandler();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDecimalNumber(Integer decimalNumber) {
        Integer oldValue = this.decimalNumber;
        this.decimalNumber = decimalNumber;
        firePropertyChange(PROPERTY_DECIMAL_NUMBER, oldValue, decimalNumber);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDecimalNumber() {
        $objectMap.put("decimalNumber", decimalNumber = null);
    }

    @Override
    protected void createHandler() {
        $objectMap.put("handler", handler = new TuttiComputedOrNotDataEditorHandler(this));
    }

    @Override
    protected void createProperty() {
        $objectMap.put("property", property = TuttiComputedOrNotData.PROPERTY_DATA);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NumberEditor0", $NumberEditor0);
        createDecimalNumber();
        // inline creation of $NumberEditor0
        setName("$NumberEditor0");
        
        $completeSetup();
    }

}