package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditProtocolUI extends JPanel implements TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SPECIES_PROTOCOL_ENABLED = "addSpeciesProtocol.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_SPECIES_PROTOCOL_ENABLED = "removeSpeciesProtocol.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SAVE_WARNING_CONTAINER_VISIBLE = "saveWarningContainer.visible";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesProtocol;
    protected JButton cancelButton;
    protected JPanel caracteristicActions;
    protected JTabbedPane caracteristicPane;
    protected JPanel caracteristicPanel;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected BeanDoubleList<Caracteristic> environmentList;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JButton exportAllCaracteristic;
    protected JButton exportCaracteristic;
    protected JButton exportSpecies;
    protected BeanDoubleList<Caracteristic> gearList;
    protected EditProtocolUIHandler handler;
    protected EditProtocolUI homePanel = this;
    protected BeanDoubleList<Caracteristic> hydrologyList;
    protected JButton importCaracteristic;
    protected JButton importSpecies;
    protected BeanDoubleList<Caracteristic> lengthClassesList;
    protected EditProtocolUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected Table protocolInfoForm;
    protected JMenuItem removeSpeciesProtocol;
    protected JButton saveButton;
    protected JLabel saveWarning;
    protected JPanel saveWarningContainer;
    protected JPanel speciesActions;
    protected BeanComboBox<Species> speciesComboBox;
    protected JPanel speciesPanel;
    protected JXTable speciesTable;
    protected JPopupMenu tablePopup;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private TabInfo $TabInfo7;
    private TabInfo $TabInfo8;
    private TabInfo $TabInfo9;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditProtocolUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditProtocolUIHandler handler = new EditProtocolUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditProtocolUI() {
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesProtocol() {
        return addSpeciesProtocol;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getCaracteristicActions() {
        return caracteristicActions;
    }

    public JTabbedPane getCaracteristicPane() {
        return caracteristicPane;
    }

    public JPanel getCaracteristicPanel() {
        return caracteristicPanel;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public BeanDoubleList<Caracteristic> getEnvironmentList() {
        return environmentList;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JButton getExportAllCaracteristic() {
        return exportAllCaracteristic;
    }

    public JButton getExportCaracteristic() {
        return exportCaracteristic;
    }

    public JButton getExportSpecies() {
        return exportSpecies;
    }

    public BeanDoubleList<Caracteristic> getGearList() {
        return gearList;
    }

    public EditProtocolUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Caracteristic> getHydrologyList() {
        return hydrologyList;
    }

    public JButton getImportCaracteristic() {
        return importCaracteristic;
    }

    public JButton getImportSpecies() {
        return importSpecies;
    }

    public BeanDoubleList<Caracteristic> getLengthClassesList() {
        return lengthClassesList;
    }

    public EditProtocolUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public Table getProtocolInfoForm() {
        return protocolInfoForm;
    }

    public JMenuItem getRemoveSpeciesProtocol() {
        return removeSpeciesProtocol;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JLabel getSaveWarning() {
        return saveWarning;
    }

    public JPanel getSaveWarningContainer() {
        return saveWarningContainer;
    }

    public JPanel getSpeciesActions() {
        return speciesActions;
    }

    public BeanComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JPanel getSpeciesPanel() {
        return speciesPanel;
    }

    public JXTable getSpeciesTable() {
        return speciesTable;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    protected TabInfo get$TabInfo8() {
        return $TabInfo8;
    }

    protected TabInfo get$TabInfo9() {
        return $TabInfo9;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCaracteristicActions() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicActions.add(importCaracteristic);
        caracteristicActions.add(exportCaracteristic);
        caracteristicActions.add(exportAllCaracteristic);
    }

    protected void addChildrenToCaracteristicPane() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPane.add(lengthClassesList);
        caracteristicPane.add(gearList);
        caracteristicPane.add(environmentList);
        caracteristicPane.add(hydrologyList);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 0));
        caracteristicPane.setTitleAt(0, _("tutti.label.tab.protocol.caracteristic.lengthClasses"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 1));
        caracteristicPane.setTitleAt(1, _("tutti.label.tab.protocol.caracteristic.gear"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 2));
        caracteristicPane.setTitleAt(2, _("tutti.label.tab.protocol.caracteristic.environment"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(caracteristicPane, 3));
        caracteristicPane.setTitleAt(3, _("tutti.label.tab.protocol.caracteristic.hydrology"));
    }

    protected void addChildrenToCaracteristicPanel() {
        if (!allComponentsCreated) {
            return;
        }
        caracteristicPanel.add(caracteristicActions, BorderLayout.NORTH);
        caracteristicPanel.add(caracteristicPane, BorderLayout.CENTER);
    }

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JTabbedPane0, BorderLayout.CENTER);
        add(saveWarningContainer, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!allComponentsCreated) {
            return;
        }
        protocolInfoForm.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        protocolInfoForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaveWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        saveWarningContainer.add(saveWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToSpeciesActions() {
        if (!allComponentsCreated) {
            return;
        }
        speciesActions.add(importSpecies);
        speciesActions.add(exportSpecies);
    }

    protected void addChildrenToSpeciesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesPanel.add(speciesActions, BorderLayout.NORTH);
        speciesPanel.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeSpeciesProtocol);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesProtocol() {
        $objectMap.put("addSpeciesProtocol", addSpeciesProtocol = new JButton());
        
        addSpeciesProtocol.setName("addSpeciesProtocol");
        addSpeciesProtocol.putClientProperty("tuttiAction", AddSpeciesProtocolAction.class);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("tuttiAction", CancelEditProtocolAction.class);
    }

    protected void createCaracteristicActions() {
        $objectMap.put("caracteristicActions", caracteristicActions = new JPanel());
        
        caracteristicActions.setName("caracteristicActions");
        caracteristicActions.setLayout(new GridLayout());
    }

    protected void createCaracteristicPane() {
        $objectMap.put("caracteristicPane", caracteristicPane = new JTabbedPane());
        
        caracteristicPane.setName("caracteristicPane");
    }

    protected void createCaracteristicPanel() {
        $objectMap.put("caracteristicPanel", caracteristicPanel = new JPanel());
        
        caracteristicPanel.setName("caracteristicPanel");
        caracteristicPanel.setLayout(new BorderLayout());
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createEnvironmentList() {
        $objectMap.put("environmentList", environmentList = new BeanDoubleList<Caracteristic>());
        
        environmentList.setName("environmentList");
        environmentList.setProperty("environmentPmfm");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createExportAllCaracteristic() {
        $objectMap.put("exportAllCaracteristic", exportAllCaracteristic = new JButton());
        
        exportAllCaracteristic.setName("exportAllCaracteristic");
        exportAllCaracteristic.putClientProperty("tuttiAction", ExportAllCaracteristicAction.class);
    }

    protected void createExportCaracteristic() {
        $objectMap.put("exportCaracteristic", exportCaracteristic = new JButton());
        
        exportCaracteristic.setName("exportCaracteristic");
        exportCaracteristic.putClientProperty("tuttiAction", ExportProtocolCaracteristicAction.class);
    }

    protected void createExportSpecies() {
        $objectMap.put("exportSpecies", exportSpecies = new JButton());
        
        exportSpecies.setName("exportSpecies");
        exportSpecies.putClientProperty("tuttiAction", ExportProtocolSpeciesAction.class);
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Caracteristic>());
        
        gearList.setName("gearList");
        gearList.setProperty("gearPmfm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditProtocolUIHandler.class));
    }

    protected void createHydrologyList() {
        $objectMap.put("hydrologyList", hydrologyList = new BeanDoubleList<Caracteristic>());
        
        hydrologyList.setName("hydrologyList");
        hydrologyList.setProperty("hydrologyPmfm");
    }

    protected void createImportCaracteristic() {
        $objectMap.put("importCaracteristic", importCaracteristic = new JButton());
        
        importCaracteristic.setName("importCaracteristic");
        importCaracteristic.putClientProperty("tuttiAction", ImportProtocolCaracteristicAction.class);
    }

    protected void createImportSpecies() {
        $objectMap.put("importSpecies", importSpecies = new JButton());
        
        importSpecies.setName("importSpecies");
        importSpecies.putClientProperty("tuttiAction", ImportProtocolSpeciesAction.class);
    }

    protected void createLengthClassesList() {
        $objectMap.put("lengthClassesList", lengthClassesList = new BeanDoubleList<Caracteristic>());
        
        lengthClassesList.setName("lengthClassesList");
        lengthClassesList.setProperty("lengthClassesPmfm");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditProtocolUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.label.program.name"));
    }

    protected void createProtocolInfoForm() {
        $objectMap.put("protocolInfoForm", protocolInfoForm = new Table());
        
        protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveSpeciesProtocol() {
        $objectMap.put("removeSpeciesProtocol", removeSpeciesProtocol = new JMenuItem());
        
        removeSpeciesProtocol.setName("removeSpeciesProtocol");
        removeSpeciesProtocol.setMnemonic(82);
        removeSpeciesProtocol.putClientProperty("tuttiAction", RemoveSpeciesProtocolAction.class);
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.putClientProperty("tuttiAction", SaveProtocolAction.class);
    }

    protected void createSaveWarning() {
        $objectMap.put("saveWarning", saveWarning = new JLabel());
        
        saveWarning.setName("saveWarning");
    }

    protected void createSaveWarningContainer() {
        $objectMap.put("saveWarningContainer", saveWarningContainer = new JPanel());
        
        saveWarningContainer.setName("saveWarningContainer");
        saveWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createSpeciesActions() {
        $objectMap.put("speciesActions", speciesActions = new JPanel());
        
        speciesActions.setName("speciesActions");
        speciesActions.setLayout(new GridLayout());
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setShowReset(false);
    }

    protected void createSpeciesPanel() {
        $objectMap.put("speciesPanel", speciesPanel = new JPanel());
        
        speciesPanel.setName("speciesPanel");
        speciesPanel.setLayout(new BorderLayout());
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new JXTable());
        
        speciesTable.setName("speciesTable");
        speciesTable.setSortable(false);
        speciesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesTable"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditProtocolUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add(protocolInfoForm);
        $JTabbedPane0.add(caracteristicPanel);
        $JTabbedPane0.add(speciesPanel);
        $JTabbedPane0.add($JLabel0);
        $JTabbedPane0.add($JLabel1);
        $JTabbedPane0.add($JLabel2);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("tutti.label.tab.protocol.info"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("tutti.label.tab.protocol.caracteristic"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 2));
        $JTabbedPane0.setTitleAt(2, _("tutti.label.tab.protocol.species"));
        $TabInfo7.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 3));
        $JTabbedPane0.setTitleAt(3, _("tutti.label.tab.protocol.benthos"));
        $JTabbedPane0.setEnabledAt(3, false);
        $TabInfo8.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 4));
        $JTabbedPane0.setTitleAt(4, _("tutti.label.tab.protocol.plankton"));
        $JTabbedPane0.setEnabledAt(4, false);
        $TabInfo9.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 5));
        $JTabbedPane0.setTitleAt(5, _("tutti.label.tab.protocol.accidental"));
        $JTabbedPane0.setEnabledAt(5, false);
        addChildrenToProtocolInfoForm();
        addChildrenToCommentPane();
        addChildrenToCaracteristicPanel();
        addChildrenToCaracteristicActions();
        addChildrenToCaracteristicPane();
        addChildrenToSpeciesPanel();
        addChildrenToSpeciesActions();
        // inline complete setup of $Table0
        $Table0.add(speciesComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addSpeciesProtocol, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(speciesTable);
        addChildrenToSaveWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 28 property setters
        lengthClassesList.setBeanType(Caracteristic.class);
        gearList.setBeanType(Caracteristic.class);
        environmentList.setBeanType(Caracteristic.class);
        hydrologyList.setBeanType(Caracteristic.class);
        speciesComboBox.setBeanType(Species.class);
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        $JLabel1.setHorizontalAlignment(JLabel.CENTER);
        $JLabel2.setHorizontalAlignment(JLabel.CENTER);
        nameLabel.setLabelFor(nameField);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.label.comment")));
        caracteristicPane.setTabPlacement(JTabbedPane.LEFT);
        lengthClassesList.setBean(model);
        gearList.setBean(model);
        environmentList.setBean(model);
        hydrologyList.setBean(model);
        speciesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        speciesTable.setSelectionForeground(Color.BLACK);
        speciesTable.setSelectionBackground(null);
        saveWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        saveWarning.setIcon(SwingUtil.createActionIcon("warning"));
        saveWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createTablePopup();
        createRemoveSpeciesProtocol();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        createProtocolInfoForm();
        createNameLabel();
        createNameField();
        createCommentPane();
        createCommentField();
        createCaracteristicPanel();
        createCaracteristicActions();
        createImportCaracteristic();
        createExportCaracteristic();
        createExportAllCaracteristic();
        createCaracteristicPane();
        createLengthClassesList();
        createGearList();
        createEnvironmentList();
        createHydrologyList();
        createSpeciesPanel();
        createSpeciesActions();
        createImportSpecies();
        createExportSpecies();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesComboBox();
        createAddSpeciesProtocol();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSpeciesTable();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("tutti.to.be.done"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("tutti.to.be.done"));
        createSaveWarningContainer();
        createSaveWarning();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("tutti.label.tab.protocol.info"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("tutti.label.tab.protocol.caracteristic"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("tutti.label.tab.protocol.caracteristic.lengthClasses"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("tutti.label.tab.protocol.caracteristic.gear"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("tutti.label.tab.protocol.caracteristic.environment"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("tutti.label.tab.protocol.caracteristic.hydrology"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(_("tutti.label.tab.protocol.species"));
        // inline creation of $TabInfo7
        $objectMap.put("$TabInfo7", $TabInfo7 = new TabInfo());
        
        $TabInfo7.setEnabled(false);
        $TabInfo7.setTitle(_("tutti.label.tab.protocol.benthos"));
        // inline creation of $TabInfo8
        $objectMap.put("$TabInfo8", $TabInfo8 = new TabInfo());
        
        $TabInfo8.setEnabled(false);
        $TabInfo8.setTitle(_("tutti.label.tab.protocol.plankton"));
        // inline creation of $TabInfo9
        $objectMap.put("$TabInfo9", $TabInfo9 = new TabInfo());
        
        $TabInfo9.setEnabled(false);
        $TabInfo9.setTitle(_("tutti.label.tab.protocol.accidental"));
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_PROTOCOL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesProtocol.setEnabled(model.isRemoveSpeciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, getStringValue(model.getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.setEnabled(!speciesComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SPECIES_PROTOCOL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesComboBox != null) {
                    addSpeciesProtocol.setEnabled(speciesComboBox.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesComboBox != null) {
                    speciesComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cloned", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveWarningContainer.setVisible(model.isImported() || model.isCloned());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("imported", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cloned", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}