
package fr.ifremer.tutti.ui.swing.content.operation.fishing;

/*
 * #%L
 * Tutti :: UI
 * $Id: CaracteristicRowModel.java 308 2013-02-03 13:06:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/CaracteristicRowModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;

import java.io.Serializable;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public abstract class CaracteristicRowModel<RM extends CaracteristicRowModel<RM>> extends AbstractTuttiBeanUIModel<Serializable, RM> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_KEY = "key";

    public static final String PROPERTY_VALUE = "value";

    protected Caracteristic key;

    protected Serializable value;

    public CaracteristicRowModel() {
        super(Serializable.class, null, null);
    }

    public CaracteristicRowModel(Caracteristic key, Serializable value) {
        this();
        this.key = key;
        this.value = value;
    }

    public Caracteristic getKey() {
        return key;
    }

    public void setKey(Caracteristic key) {
        Object oldValue = getKey();
        this.key = key;
        firePropertyChange(PROPERTY_KEY, oldValue, key);
    }

    public Serializable getValue() {
        return value;
    }

    public void setValue(Serializable value) {
        Object oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }
}
