package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosBatchRowModel.java 114 2012-12-28 08:34:01Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/BenthosBatchRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Define a benthos batch row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class BenthosBatchRowModel extends AbstractTuttiBeanUIModel<BenthosBatch, BenthosBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_NUMBER = "number";

    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_ATTACHMENTS = "attachments";

    /**
     * Species observed.
     *
     * @since 0.2
     */
    protected Species species;

    /**
     * Is the species need to be confirmed?.
     *
     * @since 0.2
     */
    protected boolean speciesToConfirm;

    /**
     * Observed weight.
     *
     * @since 0.2
     */
    protected Float weight;

    /**
     * Observed number.
     *
     * @since 0.3
     */
    protected Integer number;

    /**
     * Sample weight.
     *
     * @since 0.2
     */
    protected Float sampleWeight;


    /**
     * Comment on this catches.
     *
     * @since 0.2
     */
    protected String comment;

    /**
     * Attachments
     *
     * @since 0.2
     */
    protected List<Attachment> attachments;

    protected static final Binder<BenthosBatch, BenthosBatchRowModel> fromBeanBinder =
            BinderFactory.newBinder(BenthosBatch.class,
                                    BenthosBatchRowModel.class);

    protected static final Binder<BenthosBatchRowModel, BenthosBatch> toBeanBinder =
            BinderFactory.newBinder(BenthosBatchRowModel.class,
                                    BenthosBatch.class);

    public BenthosBatchRowModel() {
        super(BenthosBatch.class, fromBeanBinder, toBeanBinder);
    }

    public BenthosBatchRowModel(BenthosBatch aBatch) {
        this();
        fromBean(aBatch);
    }

    public Species getSpecies() {
        return species;
    }

    public void setSpecies(Species species) {
        Object oldValue = getSpecies();
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    public Boolean getSpeciesToConfirm() {
        return speciesToConfirm;
    }

    public void setSpeciesToConfirm(Boolean speciesToConfirm) {
        Object oldValue = getSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    public Float getWeight() {
        return weight;
    }

    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public Float getSampleWeight() {
        return sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Object oldValue = getSampleWeight();
        this.sampleWeight = sampleWeight;
        firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        Object oldValue = getNumber();
        this.number = number;
        firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Attachment> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        Object oldValue = getAttachments();
        this.attachments = attachments;
        firePropertyChange(PROPERTY_ATTACHMENTS, oldValue, attachments);
    }

}
